/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.TiledSurfaceObjectRenderer;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceShapeLayer
extends RenderableLayer {
    protected TiledSurfaceObjectRenderer renderer = new TiledSurfaceObjectRenderer();

    public TiledSurfaceObjectRenderer getSurfaceObjectRenderer() {
        return this.renderer;
    }

    public void setSurfaceObjectRenderer(TiledSurfaceObjectRenderer tiledSurfaceObjectRenderer) {
        if (tiledSurfaceObjectRenderer == null) {
            String string = Logging.getMessage("nullValue.RendererIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.renderer = tiledSurfaceObjectRenderer;
    }

    @Override
    protected void doPreRender(DrawContext drawContext) {
        ArrayList<SurfaceShape> arrayList = new ArrayList<SurfaceShape>();
        ArrayList<Renderable> arrayList2 = new ArrayList<Renderable>();
        this.separateSurfaceShapes(this.getActiveRenderables(), arrayList, arrayList2);
        this.getSurfaceObjectRenderer().setPickEnabled(this.isPickEnabled());
        this.getSurfaceObjectRenderer().setSurfaceObjects(arrayList);
        this.getSurfaceObjectRenderer().preRender(drawContext);
        this.doPreRender(drawContext, arrayList2);
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        ArrayList<Renderable> arrayList = new ArrayList<Renderable>();
        this.separateSurfaceShapes(this.getActiveRenderables(), null, arrayList);
        this.getSurfaceObjectRenderer().pick(drawContext, point, this.delegateOwner != null ? this.delegateOwner : this);
        this.doPick(drawContext, arrayList, point);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        ArrayList<Renderable> arrayList = new ArrayList<Renderable>();
        this.separateSurfaceShapes(this.getActiveRenderables(), null, arrayList);
        this.getSurfaceObjectRenderer().render(drawContext);
        this.doRender(drawContext, arrayList);
    }

    protected void separateSurfaceShapes(Iterable<? extends Renderable> iterable, List<SurfaceShape> list, List<Renderable> list2) {
        for (Renderable renderable : iterable) {
            if (renderable == null) continue;
            if (renderable instanceof SurfaceShape) {
                if (list == null) continue;
                list.add((SurfaceShape)renderable);
                continue;
            }
            if (list2 == null) continue;
            list2.add(renderable);
        }
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.SurfaceShapeLayer.Name");
    }
}

