/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileKey;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TiledImageLayer
extends AbstractLayer {
    private static final LevelComparer levelComparer = new LevelComparer();
    private final LevelSet levels;
    private ArrayList<TextureTile> topLevels;
    private boolean forceLevelZeroLoads = false;
    private boolean levelZeroLoaded = false;
    private boolean retainLevelZeroTiles = false;
    private String tileCountName;
    private double splitScale = 0.9;
    private boolean useMipMaps = true;
    private ArrayList<String> supportedImageFormats = new ArrayList();
    private boolean showImageTileOutlines = false;
    private boolean drawTileBoundaries = false;
    private boolean useTransparentTextures = false;
    private boolean drawTileIDs = false;
    private boolean drawBoundingVolumes = false;
    private TextRenderer textRenderer = null;
    private ArrayList<TextureTile> currentTiles = new ArrayList();
    private TextureTile currentResourceTile;
    private Vec4 referencePoint;
    private boolean atMaxResolution = false;
    private PriorityBlockingQueue<Runnable> requestQ = new PriorityBlockingQueue(200);

    protected abstract void requestTexture(DrawContext var1, TextureTile var2);

    protected abstract void forceTextureLoad(TextureTile var1);

    public TiledImageLayer(LevelSet levelSet) {
        if (levelSet == null) {
            String string = Logging.getMessage("nullValue.LevelSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.levels = new LevelSet(levelSet);
        this.createTopLevelTiles();
        this.setPickEnabled(false);
        this.tileCountName = this.getName() + " Tiles";
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.tileCountName = this.getName() + " Tiles";
    }

    public boolean isUseTransparentTextures() {
        return this.useTransparentTextures;
    }

    public void setUseTransparentTextures(boolean bl) {
        this.useTransparentTextures = bl;
    }

    public boolean isForceLevelZeroLoads() {
        return this.forceLevelZeroLoads;
    }

    public void setForceLevelZeroLoads(boolean bl) {
        this.forceLevelZeroLoads = bl;
    }

    public boolean isRetainLevelZeroTiles() {
        return this.retainLevelZeroTiles;
    }

    public void setRetainLevelZeroTiles(boolean bl) {
        this.retainLevelZeroTiles = bl;
    }

    public boolean isDrawTileIDs() {
        return this.drawTileIDs;
    }

    public void setDrawTileIDs(boolean bl) {
        this.drawTileIDs = bl;
    }

    public boolean isDrawTileBoundaries() {
        return this.drawTileBoundaries;
    }

    public void setDrawTileBoundaries(boolean bl) {
        this.drawTileBoundaries = bl;
    }

    public boolean isShowImageTileOutlines() {
        return this.showImageTileOutlines;
    }

    public void setShowImageTileOutlines(boolean bl) {
        this.showImageTileOutlines = bl;
    }

    public boolean isDrawBoundingVolumes() {
        return this.drawBoundingVolumes;
    }

    public void setDrawBoundingVolumes(boolean bl) {
        this.drawBoundingVolumes = bl;
    }

    protected LevelSet getLevels() {
        return this.levels;
    }

    protected void setSplitScale(double d) {
        this.splitScale = d;
    }

    protected PriorityBlockingQueue<Runnable> getRequestQ() {
        return this.requestQ;
    }

    @Override
    public boolean isMultiResolution() {
        return this.getLevels() != null && this.getLevels().getNumLevels() > 1;
    }

    @Override
    public boolean isAtMaxResolution() {
        return this.atMaxResolution;
    }

    public boolean isUseMipMaps() {
        return this.useMipMaps;
    }

    public void setUseMipMaps(boolean bl) {
        this.useMipMaps = bl;
    }

    private void createTopLevelTiles() {
        Sector sector = this.levels.getSector();
        gov.nasa.worldwind.util.Level level = this.levels.getFirstLevel();
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = this.levels.getTileOrigin().getLatitude();
        Angle angle4 = this.levels.getTileOrigin().getLongitude();
        int n = Tile.computeRow(angle, sector.getMinLatitude(), angle3);
        int n2 = Tile.computeColumn(angle2, sector.getMinLongitude(), angle4);
        int n3 = Tile.computeRow(angle, sector.getMaxLatitude(), angle3);
        int n4 = Tile.computeColumn(angle2, sector.getMaxLongitude(), angle4);
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        this.topLevels = new ArrayList(n5 * n6);
        Angle angle5 = Tile.computeRowLatitude(n, angle, angle3);
        for (int i = n; i <= n3; ++i) {
            Angle angle6 = angle5.add(angle);
            Angle angle7 = Tile.computeColumnLongitude(n2, angle2, angle4);
            for (int j = n2; j <= n4; ++j) {
                Angle angle8 = angle7.add(angle2);
                this.topLevels.add(new TextureTile(new Sector(angle5, angle6, angle7, angle8), level, i, j));
                angle7 = angle8;
            }
            angle5 = angle6;
        }
    }

    private void loadAllTopLevelTextures(DrawContext drawContext) {
        for (TextureTile textureTile : this.topLevels) {
            if (textureTile.isTextureInMemory(drawContext.getTextureCache())) continue;
            this.forceTextureLoad(textureTile);
        }
        this.levelZeroLoaded = true;
    }

    private void assembleTiles(DrawContext drawContext) {
        this.currentTiles.clear();
        for (TextureTile textureTile : this.topLevels) {
            if (!this.isTileVisible(drawContext, textureTile)) continue;
            this.currentResourceTile = null;
            this.addTileOrDescendants(drawContext, textureTile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTileOrDescendants(DrawContext drawContext, TextureTile textureTile) {
        if (this.meetsRenderCriteria(drawContext, textureTile)) {
            this.addTile(drawContext, textureTile);
            return;
        }
        TextureTile textureTile2 = null;
        try {
            TextureTile[] textureTileArray;
            if (textureTile.isTextureInMemory(drawContext.getTextureCache()) || textureTile.getLevelNumber() == 0) {
                textureTile2 = this.currentResourceTile;
                this.currentResourceTile = textureTile;
            } else if (!textureTile.getLevel().isEmpty()) {
                // empty if block
            }
            for (TextureTile textureTile3 : textureTileArray = textureTile.createSubTiles(this.levels.getLevel(textureTile.getLevelNumber() + 1))) {
                if (!this.isTileVisible(drawContext, textureTile3)) continue;
                this.addTileOrDescendants(drawContext, textureTile3);
            }
        }
        finally {
            if (textureTile2 != null) {
                this.currentResourceTile = textureTile2;
            }
        }
    }

    private void addTile(DrawContext drawContext, TextureTile textureTile) {
        textureTile.setFallbackTile(null);
        if (textureTile.isTextureInMemory(drawContext.getTextureCache())) {
            this.addTileToCurrent(textureTile);
            return;
        }
        if (textureTile.getLevelNumber() == 0 && this.forceLevelZeroLoads && !textureTile.isTextureInMemory(drawContext.getTextureCache())) {
            this.forceTextureLoad(textureTile);
            if (textureTile.isTextureInMemory(drawContext.getTextureCache())) {
                this.addTileToCurrent(textureTile);
                return;
            }
        }
        if (textureTile.getLevelNumber() < this.levels.getNumLevels() && !this.levels.isResourceAbsent(textureTile)) {
            this.requestTexture(drawContext, textureTile);
        }
        if (this.currentResourceTile != null) {
            if (this.currentResourceTile.getLevelNumber() == 0 && this.forceLevelZeroLoads && !this.currentResourceTile.isTextureInMemory(drawContext.getTextureCache()) && !this.currentResourceTile.isTextureInMemory(drawContext.getTextureCache())) {
                this.forceTextureLoad(this.currentResourceTile);
            }
            if (this.currentResourceTile.isTextureInMemory(drawContext.getTextureCache())) {
                textureTile.setFallbackTile(this.currentResourceTile);
                this.addTileToCurrent(textureTile);
            }
        }
    }

    private void addTileToCurrent(TextureTile textureTile) {
        this.currentTiles.add(textureTile);
    }

    private boolean isTileVisible(DrawContext drawContext, TextureTile textureTile) {
        return textureTile.getExtent(drawContext).intersects(drawContext.getView().getFrustumInModelCoordinates()) && (drawContext.getVisibleSector() == null || drawContext.getVisibleSector().intersects(textureTile.getSector()));
    }

    private boolean meetsRenderCriteria(DrawContext drawContext, TextureTile textureTile) {
        return this.levels.isFinalLevel(textureTile.getLevelNumber()) || !this.needToSplit(drawContext, textureTile.getSector());
    }

    private boolean needToSplit(DrawContext drawContext, Sector sector) {
        double d;
        Vec4[] vec4Array = sector.computeCornerPoints(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
        Vec4 vec4 = sector.computeCenterPoint(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
        View view = drawContext.getView();
        double d2 = view.getEyePoint().distanceTo3(vec4Array[0]);
        double d3 = view.getEyePoint().distanceTo3(vec4Array[1]);
        double d4 = view.getEyePoint().distanceTo3(vec4Array[2]);
        double d5 = view.getEyePoint().distanceTo3(vec4Array[3]);
        double d6 = view.getEyePoint().distanceTo3(vec4);
        double d7 = d2;
        if (d3 < d7) {
            d7 = d3;
        }
        if (d4 < d7) {
            d7 = d4;
        }
        if (d5 < d7) {
            d7 = d5;
        }
        if (d6 < d7) {
            d7 = d6;
        }
        return !(Math.log10(d = Math.PI * sector.getDeltaLatRadians() * drawContext.getGlobe().getRadius() / 20.0) <= Math.log10(d7) - this.splitScale);
    }

    private boolean atMaxLevel(DrawContext drawContext) {
        Position position = drawContext.getViewportCenterPosition();
        if (drawContext.getView() == null || this.getLevels() == null || position == null) {
            return false;
        }
        if (!this.getLevels().getSector().contains(position.getLatitude(), position.getLongitude())) {
            return true;
        }
        gov.nasa.worldwind.util.Level level = this.getLevels().getNextToLastLevel();
        if (level == null) {
            return true;
        }
        Sector sector = level.computeSectorForPosition(position.getLatitude(), position.getLongitude(), this.levels.getTileOrigin());
        return this.needToSplit(drawContext, sector);
    }

    @Override
    public void render(DrawContext drawContext) {
        this.atMaxResolution = this.atMaxLevel(drawContext);
        super.render(drawContext);
    }

    @Override
    protected final void doRender(DrawContext drawContext) {
        if (this.forceLevelZeroLoads && !this.levelZeroLoaded) {
            this.loadAllTopLevelTextures(drawContext);
        }
        if (drawContext.getSurfaceGeometry() == null || drawContext.getSurfaceGeometry().size() < 1) {
            return;
        }
        drawContext.getGeographicSurfaceTileRenderer().setShowImageTileOutlines(this.showImageTileOutlines);
        this.draw(drawContext);
    }

    private void draw(DrawContext drawContext) {
        this.referencePoint = this.computeReferencePoint(drawContext);
        this.assembleTiles(drawContext);
        if (this.currentTiles.size() >= 1) {
            TextureTile[] textureTileArray = new TextureTile[this.currentTiles.size()];
            textureTileArray = this.currentTiles.toArray(textureTileArray);
            Arrays.sort(textureTileArray, levelComparer);
            GL gL = drawContext.getGL();
            if (this.isUseTransparentTextures() || this.getOpacity() < 1.0) {
                gL.glPushAttrib(16393);
                this.setBlendingFunction(drawContext);
            } else {
                gL.glPushAttrib(16392);
            }
            gL.glPolygonMode(1028, 6914);
            gL.glEnable(2884);
            gL.glCullFace(1029);
            drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.ImageTileCount", this.tileCountName, this.currentTiles.size());
            drawContext.getGeographicSurfaceTileRenderer().renderTiles(drawContext, this.currentTiles);
            gL.glPopAttrib();
            if (this.drawTileIDs) {
                this.drawTileIDs(drawContext, this.currentTiles);
            }
            if (this.drawBoundingVolumes) {
                this.drawBoundingVolumes(drawContext, this.currentTiles);
            }
            this.currentTiles.clear();
        }
        this.sendRequests();
        this.requestQ.clear();
    }

    protected void setBlendingFunction(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        double d = this.getOpacity();
        gL.glColor4d(d, d, d, d);
        gL.glEnable(3042);
        gL.glBlendFunc(1, 771);
    }

    private void sendRequests() {
        Runnable runnable = this.requestQ.poll();
        while (runnable != null) {
            if (!WorldWind.getTaskService().isFull()) {
                WorldWind.getTaskService().addTask(runnable);
            }
            runnable = this.requestQ.poll();
        }
    }

    @Override
    public boolean isLayerInView(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getView() == null) {
            String string = Logging.getMessage("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return drawContext.getVisibleSector() == null || this.levels.getSector().intersects(drawContext.getVisibleSector());
    }

    private Vec4 computeReferencePoint(DrawContext drawContext) {
        if (drawContext.getViewportCenterPosition() != null) {
            return drawContext.getGlobe().computePointFromPosition(drawContext.getViewportCenterPosition());
        }
        Rectangle rectangle = drawContext.getView().getViewport();
        int n = (int)((RectangularShape)rectangle).getWidth() / 2;
        for (int i = (int)(0.5 * ((RectangularShape)rectangle).getHeight()); i >= 0; --i) {
            Position position = drawContext.getView().computePositionFromScreenPoint(n, i);
            if (position == null) continue;
            return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), 0.0);
        }
        return null;
    }

    protected Vec4 getReferencePoint() {
        return this.referencePoint;
    }

    private void drawTileIDs(DrawContext drawContext, ArrayList<TextureTile> arrayList) {
        Rectangle rectangle = drawContext.getView().getViewport();
        if (this.textRenderer == null) {
            this.textRenderer = new TextRenderer(Font.decode("Arial-Plain-13"), true, true);
            this.textRenderer.setUseVertexArrays(false);
        }
        drawContext.getGL().glDisable(2929);
        drawContext.getGL().glDisable(3042);
        drawContext.getGL().glDisable(3553);
        this.textRenderer.beginRendering(rectangle.width, rectangle.height);
        this.textRenderer.setColor(Color.YELLOW);
        for (TextureTile textureTile : arrayList) {
            String string = textureTile.getLabel();
            if (textureTile.getFallbackTile() != null) {
                string = string + "/" + textureTile.getFallbackTile().getLabel();
            }
            LatLon latLon = textureTile.getSector().getCentroid();
            Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), drawContext.getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude()));
            vec4 = drawContext.getView().project(vec4);
            this.textRenderer.draw(string, (int)vec4.x, (int)vec4.y);
        }
        this.textRenderer.setColor(Color.WHITE);
        this.textRenderer.endRendering();
    }

    private void drawBoundingVolumes(DrawContext drawContext, ArrayList<TextureTile> arrayList) {
        float[] fArray = new float[4];
        drawContext.getGL().glGetFloatv(2816, fArray, 0);
        drawContext.getGL().glColor3d(0.0, 1.0, 0.0);
        for (TextureTile textureTile : arrayList) {
            ((Cylinder)textureTile.getExtent(drawContext)).render(drawContext);
        }
        Cylinder cylinder = drawContext.getGlobe().computeBoundingCylinder(drawContext.getVerticalExaggeration(), this.levels.getSector());
        drawContext.getGL().glColor3d(1.0, 1.0, 0.0);
        cylinder.render(drawContext);
        drawContext.getGL().glColor4fv(fArray, 0);
    }

    public ArrayList<String> getAvailableImageFormats() {
        return new ArrayList<String>(this.supportedImageFormats);
    }

    public boolean isImageFormatAvailable(String string) {
        return string != null && this.supportedImageFormats.contains(string);
    }

    public String getDefaultImageFormat() {
        return this.supportedImageFormats.size() > 0 ? this.supportedImageFormats.get(0) : null;
    }

    protected void setAvailableImageFormats(String[] stringArray) {
        this.supportedImageFormats.clear();
        if (stringArray != null) {
            this.supportedImageFormats.addAll(Arrays.asList(stringArray));
        }
    }

    private BufferedImage requestImage(TextureTile textureTile, String string) throws URISyntaxException, InterruptedIOException {
        String string2 = textureTile.getPath().substring(0, textureTile.getPath().lastIndexOf("."));
        String string3 = WWIO.makeSuffixForMimeType(string);
        String string4 = string2 + string3;
        URL uRL = WorldWind.getDataFileStore().findFile(string4, false);
        if (uRL == null) {
            return null;
        }
        if (WWIO.isFileOutOfDate(uRL, textureTile.getLevel().getExpiryTime())) {
            WorldWind.getDataFileStore().removeFile(uRL);
            String string5 = Logging.getMessage("generic.DataFileExpired", uRL);
            Logging.logger().fine(string5);
        } else {
            try {
                File file = new File(uRL.toURI());
                BufferedImage bufferedImage = ImageIO.read(file);
                if (bufferedImage == null) {
                    String string6 = Logging.getMessage("generic.ImageReadFailed", file);
                    throw new RuntimeException(string6);
                }
                this.levels.unmarkResourceAbsent(textureTile);
                return bufferedImage;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                WorldWind.getDataFileStore().removeFile(uRL);
                this.levels.markResourceAbsent(textureTile);
                String string7 = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                Logging.logger().info(string7);
            }
        }
        return null;
    }

    private void downloadImage(TextureTile textureTile, String string) throws Exception {
        URL uRL = textureTile.getResourceURL(string);
        String string2 = uRL.getProtocol();
        if (!"http".equalsIgnoreCase(string2) && !"https".equalsIgnoreCase(string2)) {
            String string3 = Logging.getMessage("layers.TextureLayer.UnknownRetrievalProtocol", uRL);
            throw new RuntimeException(string3);
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new HttpRetrievalPostProcessor(textureTile));
        hTTPRetriever.setConnectTimeout(10000);
        hTTPRetriever.setReadTimeout(20000);
        hTTPRetriever.call();
    }

    public int computeLevelForResolution(Sector sector, double d) {
        double d2;
        gov.nasa.worldwind.util.Level level;
        double d3;
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        gov.nasa.worldwind.util.Level level2 = this.levels.getLastLevel();
        for (int i = 0; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
            double d4;
            if (this.levels.isLevelEmpty(i) || (d4 = this.levels.getLevel(i).getTexelSize()) > d) continue;
            level2 = this.levels.getLevel(i);
            break;
        }
        if (level2.getLevelNumber() != 0 && !this.levels.isLevelEmpty(level2.getLevelNumber() - 1) && (d3 = Math.abs((level = this.levels.getLevel(level2.getLevelNumber() - 1)).getTexelSize() - d)) < (d2 = Math.abs(level2.getTexelSize() - d))) {
            level2 = level;
        }
        Logging.logger().fine(Logging.getMessage("layers.TiledImageLayer.LevelSelection", level2.getLevelNumber(), Double.toString(level2.getTexelSize())));
        return level2.getLevelNumber();
    }

    public BufferedImage composeImageForSector(Sector sector, int n, int n2, double d, int n3, String string, boolean bl, BufferedImage bufferedImage) throws Exception {
        TextureTile[][] textureTileArray;
        if (sector == null) {
            String string2 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (n3 < 0) {
            n3 = this.levels.getLastLevel().getLevelNumber();
        } else if (n3 > this.levels.getLastLevel().getLevelNumber()) {
            Logging.logger().warning(Logging.getMessage("generic.LevelRequestedGreaterThanMaxLevel", n3, this.levels.getLastLevel().getLevelNumber()));
            n3 = this.levels.getLastLevel().getLevelNumber();
        }
        int n4 = 0;
        for (TextureTile[] textureTileArray2 : textureTileArray = this.getTilesInSector(sector, n3)) {
            n4 += textureTileArray2.length;
        }
        if (textureTileArray.length == 0 || textureTileArray[0].length == 0) {
            Logging.logger().severe(Logging.getMessage("layers.TiledImageLayer.NoImagesAvailable"));
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(n, n2, 1);
        }
        double d2 = 0.0;
        TextureTile[][] textureTileArray3 = textureTileArray;
        int n5 = textureTileArray3.length;
        for (int i = 0; i < n5; ++i) {
            TextureTile[] textureTileArray4;
            for (TextureTile textureTile : textureTileArray4 = textureTileArray3[i]) {
                if (textureTile == null) continue;
                try {
                    BufferedImage bufferedImage2 = this.getImage(textureTile, string);
                    Thread.sleep(1L);
                    ImageUtil.mergeImage(sector, textureTile.getSector(), d, bufferedImage2, bufferedImage);
                    this.firePropertyChange("gov.nasa.worldwind.avkey.Progress", d2 / (double)n4, (d2 += 1.0) / (double)n4);
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (InterruptedIOException interruptedIOException) {
                    throw interruptedIOException;
                }
                catch (Exception exception) {
                    if (bl) {
                        throw exception;
                    }
                    String string3 = Logging.getMessage("generic.ExceptionWhileRequestingImage", textureTile.getPath());
                    Logging.logger().log(Level.WARNING, string3, exception);
                }
            }
        }
        return bufferedImage;
    }

    public int countImagesInSector(Sector sector) {
        int n = 0;
        for (int i = 0; i <= this.getLevels().getLastLevel().getLevelNumber(); ++i) {
            if (this.levels.isLevelEmpty(i)) continue;
            n += this.countImagesInSector(sector, i);
        }
        return n;
    }

    public int countImagesInSector(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel();
        if (n >= 0) {
            for (int i = n; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
                if (this.levels.isLevelEmpty(i)) continue;
                level = this.levels.getLevel(i);
                break;
            }
        }
        LatLon latLon = level.getTileDelta();
        LatLon latLon2 = this.levels.getTileOrigin();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), latLon2.getLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), latLon2.getLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), latLon2.getLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), latLon2.getLongitude());
        int n6 = n2 - n4 + 1;
        int n7 = n5 - n3 + 1;
        return n6 * n7;
    }

    public TextureTile[][] getTilesInSector(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel();
        if (n >= 0) {
            for (int i = n; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
                if (this.levels.isLevelEmpty(i)) continue;
                level = this.levels.getLevel(i);
                break;
            }
        }
        LatLon latLon = level.getTileDelta();
        LatLon latLon2 = this.levels.getTileOrigin();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), latLon2.getLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), latLon2.getLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), latLon2.getLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), latLon2.getLongitude());
        int n6 = n2 - n4 + 1;
        int n7 = n5 - n3 + 1;
        TextureTile[][] textureTileArray = new TextureTile[n6][n7];
        for (int i = n2; i >= n4; --i) {
            for (int j = n3; j <= n5; ++j) {
                TileKey tileKey = new TileKey(level.getLevelNumber(), i, j, level.getCacheName());
                Sector sector2 = this.levels.computeSectorForKey(tileKey);
                textureTileArray[n2 - i][j - n3] = new TextureTile(sector2, level, i, j);
            }
        }
        return textureTileArray;
    }

    private BufferedImage getImage(TextureTile textureTile, String string) throws Exception {
        BufferedImage bufferedImage = this.requestImage(textureTile, string);
        Thread.sleep(1L);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        this.downloadImage(textureTile, string);
        bufferedImage = this.requestImage(textureTile, string);
        Thread.sleep(1L);
        if (bufferedImage == null) {
            String string2 = Logging.getMessage("layers.TiledImageLayer.ImageUnavailable", textureTile.getPath());
            throw new RuntimeException(string2);
        }
        return bufferedImage;
    }

    private class HttpRetrievalPostProcessor
    implements RetrievalPostProcessor {
        private TextureTile tile;

        public HttpRetrievalPostProcessor(TextureTile textureTile) {
            this.tile = textureTile;
        }

        public ByteBuffer run(Retriever retriever) {
            if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                return null;
            }
            HTTPRetriever hTTPRetriever = (HTTPRetriever)retriever;
            if (hTTPRetriever.getResponseCode() == 204) {
                TiledImageLayer.this.levels.markResourceAbsent(this.tile);
                return null;
            }
            if (hTTPRetriever.getResponseCode() != 200) {
                return null;
            }
            URLRetriever uRLRetriever = (URLRetriever)retriever;
            ByteBuffer byteBuffer = uRLRetriever.getBuffer();
            String string = WWIO.makeSuffixForMimeType(hTTPRetriever.getContentType());
            if (string == null) {
                return null;
            }
            String string2 = this.tile.getPath().substring(0, this.tile.getPath().lastIndexOf("."));
            string2 = string2 + string;
            File file = WorldWind.getDataFileStore().newFile(string2);
            if (file == null) {
                return null;
            }
            try {
                WWIO.saveBuffer(byteBuffer, file);
                return byteBuffer;
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                Logging.logger().log(Level.FINE, Logging.getMessage("generic.OperationCancelled", "image retrieval"), closedByInterruptException);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LevelComparer
    implements Comparator<TextureTile> {
        private LevelComparer() {
        }

        @Override
        public int compare(TextureTile textureTile, TextureTile textureTile2) {
            int n;
            int n2 = textureTile.getFallbackTile() == null ? textureTile.getLevelNumber() : textureTile.getFallbackTile().getLevelNumber();
            int n3 = n = textureTile2.getFallbackTile() == null ? textureTile2.getLevelNumber() : textureTile2.getFallbackTile().getLevelNumber();
            return n2 < n ? -1 : (n2 == n ? 0 : 1);
        }
    }
}

