/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPointIterator;
import gov.nasa.worldwind.tracks.TrackPointIteratorImpl;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TrackLayer
extends AbstractLayer {
    private Collection<Track> tracks = new ArrayList<Track>();
    private Iterable<Track> tracksOverride;
    private Sector boundingSector;
    private int lowerLimit;
    private int upperLimit;
    private boolean overrideElevation = false;
    private double elevation = 10.0;

    public TrackLayer() {
    }

    public TrackLayer(Collection<Track> collection) {
        if (collection == null) {
            String string = Logging.getMessage("nullValue.TracksIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tracks.addAll(collection);
        this.boundingSector = Sector.boundingSector(this.iterator());
    }

    public TrackPointIterator iterator() {
        return new TrackPointIteratorImpl(this.getActiveTracks());
    }

    public int getNumPoints() {
        return ((TrackPointIteratorImpl)this.iterator()).getNumPoints();
    }

    public Iterable<Track> getTracks() {
        return this.getActiveTracks();
    }

    private Iterable<Track> getActiveTracks() {
        if (this.tracksOverride != null) {
            return this.tracksOverride;
        }
        return this.tracks != null ? Collections.unmodifiableCollection(this.tracks) : null;
    }

    public void setTracks(Collection<Track> collection) {
        if (collection == null) {
            String string = Logging.getMessage("nullValue.TracksIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.tracksOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.clearTracks();
        this.tracks.addAll(collection);
    }

    public void setTrackIterable(Iterable<Track> iterable) {
        this.tracksOverride = iterable;
        this.clearTracks();
    }

    private void clearTracks() {
        if (this.tracks != null && this.tracks.size() > 0) {
            this.tracks.clear();
        }
    }

    public Sector getBoundingSector() {
        return this.boundingSector;
    }

    public void setBoundingSector(Sector sector) {
        this.boundingSector = sector;
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(int n) {
        this.lowerLimit = n;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(int n) {
        this.upperLimit = n;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double d) {
        this.elevation = d;
    }

    public boolean isOverrideElevation() {
        return this.overrideElevation;
    }

    public void setOverrideElevation(boolean bl) {
        this.overrideElevation = bl;
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.TrackLayer.Name");
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        this.draw(drawContext, point);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        this.draw(drawContext, null);
    }

    protected void draw(DrawContext drawContext, Point point) {
        TrackPointIterator trackPointIterator = this.iterator();
        if (!trackPointIterator.hasNext()) {
            return;
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (!drawContext.getVisibleSector().intersects(this.getBoundingSector())) {
            return;
        }
        this.doDraw(drawContext, trackPointIterator, point);
    }

    protected abstract void doDraw(DrawContext var1, TrackPointIterator var2, Point var3);
}

