/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.placename;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.AbsentResourceList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class PlaceNameService {
    private final String service;
    private final String dataset;
    private final String fileCachePath;
    private static final String FORMAT_SUFFIX = ".xml.gz";
    private final Sector sector;
    private final LatLon tileDelta;
    private Extent extent = null;
    private double extentVerticalExaggeration = Double.MIN_VALUE;
    private final Font font;
    private boolean enabled;
    private Color color;
    private Color backgroundColor;
    private double minDisplayDistance;
    private double maxDisplayDistance;
    private int numColumns;
    private static final int MAX_ABSENT_TILE_TRIES = 2;
    private static final int MIN_ABSENT_TILE_CHECK_INTERVAL = 10000;
    private final AbsentResourceList absentTiles = new AbsentResourceList(2, 10000);
    private boolean addVersionTag = false;

    public PlaceNameService(String string, String string2, String string3, Sector sector, LatLon latLon, Font font, boolean bl) {
        this.service = string;
        this.dataset = string2;
        this.fileCachePath = string3;
        this.sector = sector;
        this.tileDelta = latLon;
        this.font = font;
        this.enabled = true;
        this.color = Color.white;
        this.minDisplayDistance = Double.MIN_VALUE;
        this.maxDisplayDistance = Double.MAX_VALUE;
        this.addVersionTag = bl;
        String string4 = this.validate();
        if (string4 != null) {
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.numColumns = this.numColumnsInLevel();
    }

    public String createFileCachePathFromTile(int n, int n2) {
        if (n < 0 || n2 < 0) {
            String string = Logging.getMessage("PlaceNameService.RowOrColumnOutOfRange", n, n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder(this.fileCachePath);
        stringBuilder.append(File.separator).append(this.dataset);
        stringBuilder.append(File.separator).append(n);
        stringBuilder.append(File.separator).append(n).append('_').append(n2);
        stringBuilder.append(FORMAT_SUFFIX);
        String string = stringBuilder.toString();
        return string.replaceAll("[:*?<>|]", "");
    }

    private int numColumnsInLevel() {
        int n = Tile.computeColumn(this.tileDelta.getLongitude(), this.sector.getMinLongitude(), Angle.NEG180);
        int n2 = Tile.computeColumn(this.tileDelta.getLongitude(), this.sector.getMaxLongitude().subtract(this.tileDelta.getLongitude()), Angle.NEG180);
        return n2 - n + 1;
    }

    public long getTileNumber(int n, int n2) {
        return n * this.numColumns + n2;
    }

    public URL createServiceURLFromSector(Sector sector) throws MalformedURLException {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder(this.service);
        if (stringBuilder.charAt(stringBuilder.length() - 1) != '?') {
            stringBuilder.append('?');
        }
        if (this.addVersionTag) {
            stringBuilder.append("version=1.0.0&TypeName=").append(this.dataset);
        } else {
            stringBuilder.append("TypeName=").append(this.dataset);
        }
        stringBuilder.append("&Request=GetFeature");
        stringBuilder.append("&Service=WFS");
        stringBuilder.append("&OUTPUTFORMAT=GML2-GZIP");
        stringBuilder.append("&BBOX=");
        stringBuilder.append(sector.getMinLongitude().getDegrees()).append(',');
        stringBuilder.append(sector.getMinLatitude().getDegrees()).append(',');
        stringBuilder.append(sector.getMaxLongitude().getDegrees()).append(',');
        stringBuilder.append(sector.getMaxLatitude().getDegrees());
        return new URL(stringBuilder.toString());
    }

    public final synchronized PlaceNameService deepCopy() {
        PlaceNameService placeNameService = new PlaceNameService(this.service, this.dataset, this.fileCachePath, this.sector, this.tileDelta, this.font, this.addVersionTag);
        placeNameService.enabled = this.enabled;
        placeNameService.color = this.color;
        placeNameService.minDisplayDistance = this.minDisplayDistance;
        placeNameService.maxDisplayDistance = this.maxDisplayDistance;
        return placeNameService;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PlaceNameService placeNameService = (PlaceNameService)object;
        if (this.service != null ? !this.service.equals(placeNameService.service) : placeNameService.service != null) {
            return false;
        }
        if (this.dataset != null ? !this.dataset.equals(placeNameService.dataset) : placeNameService.dataset != null) {
            return false;
        }
        if (this.fileCachePath != null ? !this.fileCachePath.equals(placeNameService.fileCachePath) : placeNameService.fileCachePath != null) {
            return false;
        }
        if (this.sector != null ? !this.sector.equals(placeNameService.sector) : placeNameService.sector != null) {
            return false;
        }
        if (this.tileDelta != null ? !this.tileDelta.equals(placeNameService.tileDelta) : placeNameService.tileDelta != null) {
            return false;
        }
        if (this.font != null ? !this.font.equals(placeNameService.font) : placeNameService.font != null) {
            return false;
        }
        if (this.color != null ? !this.color.equals(placeNameService.color) : placeNameService.color != null) {
            return false;
        }
        if (this.backgroundColor != null ? !this.backgroundColor.equals(placeNameService.backgroundColor) : placeNameService.backgroundColor != null) {
            return false;
        }
        if (this.minDisplayDistance != placeNameService.minDisplayDistance) {
            return false;
        }
        return this.maxDisplayDistance == placeNameService.maxDisplayDistance;
    }

    public final synchronized Color getColor() {
        return this.color;
    }

    public final synchronized Color getBackgroundColor() {
        if (this.backgroundColor == null) {
            this.backgroundColor = this.suggestBackgroundColor(this.color);
        }
        return this.backgroundColor;
    }

    private Color suggestBackgroundColor(Color color) {
        float[] fArray = new float[4];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        int n = fArray[2] < 0.5f ? 255 : 0;
        int n2 = color.getAlpha();
        return new Color(n, n, n, n2);
    }

    public final String getDataset() {
        return this.dataset;
    }

    public final Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.extent == null || this.extentVerticalExaggeration != drawContext.getVerticalExaggeration()) {
            this.extentVerticalExaggeration = drawContext.getVerticalExaggeration();
            this.extent = drawContext.getGlobe().computeBoundingCylinder(this.extentVerticalExaggeration, this.sector);
        }
        return this.extent;
    }

    public final String getFileCachePath() {
        return this.fileCachePath;
    }

    public final Font getFont() {
        return this.font;
    }

    public final synchronized double getMaxDisplayDistance() {
        return this.maxDisplayDistance;
    }

    public final synchronized double getMinDisplayDistance() {
        return this.minDisplayDistance;
    }

    public final LatLon getTileDelta() {
        return this.tileDelta;
    }

    public final Sector getSector() {
        return this.sector;
    }

    public final String getService() {
        return this.service;
    }

    public boolean isAddVersionTag() {
        return this.addVersionTag;
    }

    public void setAddVersionTag(boolean bl) {
        this.addVersionTag = bl;
    }

    public int hashCode() {
        int n = this.service != null ? this.service.hashCode() : 0;
        n = 29 * n + (this.dataset != null ? this.dataset.hashCode() : 0);
        n = 29 * n + (this.fileCachePath != null ? this.fileCachePath.hashCode() : 0);
        n = 29 * n + (this.sector != null ? this.sector.hashCode() : 0);
        n = 29 * n + (this.tileDelta != null ? this.tileDelta.hashCode() : 0);
        n = 29 * n + (this.font != null ? this.font.hashCode() : 0);
        n = 29 * n + (this.color != null ? this.color.hashCode() : 0);
        n = 29 * n + Double.valueOf(this.minDisplayDistance).hashCode();
        n = 29 * n + Double.valueOf(this.maxDisplayDistance).hashCode();
        return n;
    }

    public final synchronized boolean isEnabled() {
        return this.enabled;
    }

    public final synchronized void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    public final synchronized void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public final synchronized void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final synchronized void setMaxDisplayDistance(double d) {
        if (d < this.minDisplayDistance) {
            String string = Logging.getMessage("PlaceNameService.MaxDisplayDistanceLessThanMinDisplayDistance", d, this.minDisplayDistance);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.maxDisplayDistance = d;
    }

    public final synchronized void setMinDisplayDistance(double d) {
        if (d > this.maxDisplayDistance) {
            String string = Logging.getMessage("PlaceNameService.MinDisplayDistanceGrtrThanMaxDisplayDistance", d, this.maxDisplayDistance);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minDisplayDistance = d;
    }

    public final synchronized void markResourceAbsent(long l) {
        this.absentTiles.markResourceAbsent(l);
    }

    public final synchronized boolean isResourceAbsent(long l) {
        return this.absentTiles.isResourceAbsent(l);
    }

    public final synchronized void unmarkResourceAbsent(long l) {
        this.absentTiles.unmarkResourceAbsent(l);
    }

    public final String validate() {
        String string = "";
        if (this.service == null) {
            string = string + Logging.getMessage("nullValue.ServiceIsNull") + ", ";
        }
        if (this.dataset == null) {
            string = string + Logging.getMessage("nullValue.DataSetIsNull") + ", ";
        }
        if (this.fileCachePath == null) {
            string = string + Logging.getMessage("nullValue.FileStorePathIsNull") + ", ";
        }
        if (this.sector == null) {
            string = string + Logging.getMessage("nullValue.SectorIsNull") + ", ";
        }
        if (this.tileDelta == null) {
            string = string + Logging.getMessage("nullValue.TileDeltaIsNull") + ", ";
        }
        if (this.font == null) {
            string = string + Logging.getMessage("nullValue.FontIsNull") + ", ";
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }
}

