/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf.wizard;

import gov.nasa.worldwind.formats.rpf.RPFDataSeries;
import gov.nasa.worldwind.formats.rpf.RPFFrameFilename;
import gov.nasa.worldwind.layers.rpf.wizard.FileSet;
import gov.nasa.worldwind.layers.rpf.wizard.ProgressPanel;
import gov.nasa.worldwind.layers.rpf.wizard.RPFWizardUtil;
import gov.nasa.worldwind.util.FileTree;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.wizard.DefaultPanelDescriptor;
import gov.nasa.worldwind.util.wizard.Wizard;
import gov.nasa.worldwind.util.wizard.WizardModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSearchPanelDescriptor
extends DefaultPanelDescriptor {
    private ProgressPanel panelComponent = new ProgressPanel();
    private PropertyEvents propertyEvents = new PropertyEvents();
    private Thread workerThread;
    public static final String IDENTIFIER = "gov.nasa.worldwind.rpf.wizard.FileSearchPanel";

    public FileSearchPanelDescriptor() {
        this.panelComponent.addPropertyChangeListener(this.propertyEvents);
        this.setPanelIdentifier(IDENTIFIER);
        this.setPanelComponent(this.panelComponent);
    }

    @Override
    public Object getBackPanelDescriptor() {
        return "gov.nasa.worldwind.rpf.wizard.FileChooserPanel";
    }

    @Override
    public Object getNextPanelDescriptor() {
        return "gov.nasa.worldwind.rpf.wizard.DataChooserPanel";
    }

    @Override
    public void registerPanel(Wizard wizard) {
        WizardModel wizardModel = this.getWizardModel();
        if (wizardModel != null) {
            wizardModel.removePropertyChangeListener(this.propertyEvents);
        }
        super.registerPanel(wizard);
        WizardModel wizardModel2 = this.getWizardModel();
        if (wizardModel2 != null) {
            wizardModel2.addPropertyChangeListener(this.propertyEvents);
        }
    }

    @Override
    public void aboutToDisplayPanel() {
        File file;
        this.panelComponent.setTitle(RPFWizardUtil.makeLarger("Searching for Imagery"));
        this.panelComponent.setProgressDescription1(" ");
        this.panelComponent.setProgressDescription2(" ");
        this.panelComponent.getProgressBar().setIndeterminate(false);
        WizardModel wizardModel = this.getWizardModel();
        if (wizardModel != null && (file = RPFWizardUtil.getSelectedFile(wizardModel)) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<br>");
            stringBuilder.append("Searching ");
            stringBuilder.append("'").append(file.getAbsolutePath()).append(File.separator).append("...'");
            stringBuilder.append("<br>");
            this.panelComponent.setDescription(RPFWizardUtil.makeBold(stringBuilder.toString()));
        }
    }

    @Override
    public void displayingPanel() {
        WizardModel wizardModel = this.getWizardModel();
        if (wizardModel != null && !RPFWizardUtil.isFileListCurrent(wizardModel)) {
            this.panelComponent.getProgressBar().setIndeterminate(true);
            this.startWorkerThread(new Runnable(){

                public void run() {
                    FileSearchPanelDescriptor.this.refreshFileList();
                    WizardModel wizardModel = FileSearchPanelDescriptor.this.getWizardModel();
                    if (wizardModel != null) {
                        RPFWizardUtil.setFileListCurrent(wizardModel, true);
                    }
                    FileSearchPanelDescriptor.this.moveToNextPanel();
                }
            });
        }
    }

    @Override
    public void aboutToHidePanel() {
        this.killWorkerThread();
    }

    private void moveToNextPanel() {
        Wizard wizard = this.getWizard();
        Object object = this.getNextPanelDescriptor();
        if (wizard != null && object != null) {
            wizard.setCurrentPanelDescriptor(object);
        }
    }

    private void selectedFileChanged() {
        WizardModel wizardModel = this.getWizardModel();
        if (wizardModel != null) {
            RPFWizardUtil.setFileListCurrent(wizardModel, false);
        }
    }

    private void refreshFileList() {
        WizardModel wizardModel = this.getWizardModel();
        if (wizardModel != null) {
            boolean bl = wizardModel.isBackButtonEnabled();
            boolean bl2 = wizardModel.isNextButtonEnabled();
            wizardModel.setBackButtonEnabled(false);
            wizardModel.setNextButtonEnabled(false);
            File file = RPFWizardUtil.getSelectedFile(wizardModel);
            AcceptRPFFilter acceptRPFFilter = new AcceptRPFFilter();
            UpdateDescriptionFilter updateDescriptionFilter = new UpdateDescriptionFilter(acceptRPFFilter, this.panelComponent);
            List<File> list = this.searchSelectedFile(file, updateDescriptionFilter);
            RPFWizardUtil.setFileList(wizardModel, list);
            List<FileSet> list2 = this.makeFileSetList(list);
            if (list2 != null) {
                this.makeDefaultSelections(list2);
                this.makeTitles(list2);
                this.sortFileSetList(list2);
            }
            RPFWizardUtil.setFileSetList(wizardModel, list2);
            wizardModel.firePropertyChange("fileSetList", null, list2);
            wizardModel.setBackButtonEnabled(bl);
            wizardModel.setNextButtonEnabled(bl2);
        }
    }

    private List<File> searchSelectedFile(File file, FileFilter fileFilter) {
        List<File> list;
        if (Thread.interrupted()) {
            return null;
        }
        try {
            FileTree fileTree = new FileTree(file);
            fileTree.setMode(1);
            list = fileTree.asList(fileFilter);
        }
        catch (Throwable throwable) {
            String string = String.format("Exception while searching file: %s", file);
            Logging.logger().log(Level.SEVERE, string, throwable);
            list = null;
        }
        return list;
    }

    private List<FileSet> makeFileSetList(List<File> list) {
        ArrayList arrayList = null;
        if (list != null) {
            HashMap<String, FileSet> hashMap = new HashMap<String, FileSet>();
            for (File file : list) {
                try {
                    String string = file.getName().toUpperCase();
                    RPFFrameFilename rPFFrameFilename = RPFFrameFilename.parseFilename(string);
                    String string2 = rPFFrameFilename.getDataSeriesCode();
                    FileSet fileSet = (FileSet)hashMap.get(string2);
                    if (fileSet == null) {
                        fileSet = new FileSet();
                        fileSet.setIdentifier(string2);
                        fileSet.setFiles(new LinkedList<File>());
                        hashMap.put(string2, fileSet);
                    }
                    fileSet.getFiles().add(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            arrayList = new ArrayList(hashMap.values());
        }
        return arrayList;
    }

    private void makeDefaultSelections(List<FileSet> list) {
        if (list != null && list.size() == 1 && list.get(0) != null) {
            list.get(0).setSelected(true);
        }
    }

    private void makeTitles(Iterable<FileSet> iterable) {
        if (iterable != null) {
            for (FileSet fileSet : iterable) {
                this.makeTitle(fileSet);
            }
        }
    }

    private void makeTitle(FileSet fileSet) {
        if (fileSet != null && fileSet.getIdentifier() != null) {
            RPFDataSeries rPFDataSeries;
            String string = fileSet.getIdentifier();
            try {
                rPFDataSeries = RPFDataSeries.dataSeriesFor(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                rPFDataSeries = null;
            }
            if (rPFDataSeries != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(rPFDataSeries.dataSeries);
                stringBuilder.append(" (");
                stringBuilder.append(rPFDataSeries.seriesCode);
                stringBuilder.append(")");
                fileSet.setTitle(stringBuilder.toString());
            }
        }
    }

    private void sortFileSetList(List<FileSet> list) {
        Comparator<FileSet> comparator = new Comparator<FileSet>(){

            @Override
            public int compare(FileSet fileSet, FileSet fileSet2) {
                RPFDataSeries rPFDataSeries;
                RPFDataSeries rPFDataSeries2;
                if (fileSet == null || fileSet2 == null) {
                    return 0;
                }
                String string = fileSet.getIdentifier();
                String string2 = fileSet2.getIdentifier();
                if (string == null || string2 == null) {
                    return 0;
                }
                try {
                    rPFDataSeries2 = RPFDataSeries.dataSeriesFor(string);
                    rPFDataSeries = RPFDataSeries.dataSeriesFor(string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    rPFDataSeries = null;
                    rPFDataSeries2 = null;
                }
                return rPFDataSeries2 != null && rPFDataSeries != null ? rPFDataSeries2.compareTo(rPFDataSeries) : string.compareTo(string2);
            }
        };
        Collections.sort(list, comparator);
    }

    private void startWorkerThread(Runnable runnable) {
        this.killWorkerThread();
        this.workerThread = new Thread(runnable);
        this.workerThread.start();
    }

    private void killWorkerThread() {
        if (this.workerThread != null && this.workerThread.isAlive()) {
            this.workerThread.interrupt();
        }
        this.workerThread = null;
    }

    private static class AcceptRPFFilter
    implements FileFilter {
        private AcceptRPFFilter() {
        }

        public boolean accept(File file) {
            if (file != null && file.getName() != null) {
                String string = file.getName().toUpperCase();
                return RPFFrameFilename.isFilename(string);
            }
            return false;
        }
    }

    private static class UpdateDescriptionFilter
    implements FileFilter {
        private FileFilter delegate;
        private ProgressPanel panel;

        private UpdateDescriptionFilter(FileFilter fileFilter, ProgressPanel progressPanel) {
            this.delegate = fileFilter;
            this.panel = progressPanel;
        }

        public boolean accept(File file) {
            if (!Thread.interrupted()) {
                if (this.panel != null && file != null) {
                    String string = this.panel.getProgressDescription2();
                    String string2 = file.getParent();
                    if (string2 != null ? !string2.equals(string) : string != null) {
                        this.panel.setProgressDescription1(string2);
                    }
                }
                return this.delegate != null && this.delegate.accept(file);
            }
            return false;
        }
    }

    private class PropertyEvents
    implements PropertyChangeListener {
        private PropertyEvents() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() != null && (string = propertyChangeEvent.getPropertyName()).equals("selectedFile")) {
                FileSearchPanelDescriptor.this.selectedFileChanged();
            }
        }
    }
}

