/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.poi;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.exception.NoItemException;
import gov.nasa.worldwind.exception.ServiceException;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.poi.BasicPointOfInterest;
import gov.nasa.worldwind.poi.Gazetteer;
import gov.nasa.worldwind.poi.POIUtils;
import gov.nasa.worldwind.poi.PointOfInterest;
import gov.nasa.worldwind.util.Logging;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooGazetteer
extends WWObjectImpl
implements Gazetteer {
    protected static final String GEOCODE_SERVICE = "http://local.yahooapis.com/MapsService/V1/geocode?appid=nasaworldwind&location=";

    @Override
    public List<PointOfInterest> findPlaces(String string) throws NoItemException, ServiceException {
        if (string == null || string.length() < 1) {
            return null;
        }
        String string2 = POIUtils.callService(GEOCODE_SERVICE + string.replaceAll(" ", "+"));
        if (string2 == null || string2.length() < 1) {
            return null;
        }
        return this.parseLocationString(string2);
    }

    protected ArrayList<PointOfInterest> parseLocationString(String string) throws WWRuntimeException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("/ResultSet/Result", document, XPathConstants.NODESET);
            ArrayList<PointOfInterest> arrayList = new ArrayList<PointOfInterest>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string2 = xPath.evaluate("Latitude", node);
                String string3 = xPath.evaluate("Longitude", node);
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = xPath.evaluate("Address", node);
                if (string4.length() > 0) {
                    stringBuilder.append(string4);
                    stringBuilder.append(", ");
                }
                stringBuilder.append(xPath.evaluate("City", node));
                stringBuilder.append(", ");
                stringBuilder.append(xPath.evaluate("State", node));
                if (string2 == null || string3 == null) continue;
                LatLon latLon = LatLon.fromDegrees(Double.parseDouble(string2), Double.parseDouble(string3));
                BasicPointOfInterest basicPointOfInterest = new BasicPointOfInterest(latLon);
                basicPointOfInterest.setValue("gov.nasa.worldwind.avkey.DisplayName", stringBuilder.toString());
                arrayList.add(basicPointOfInterest);
            }
            return arrayList;
        }
        catch (Exception exception) {
            String string5 = Logging.getMessage("Gazetteer.URLException", string);
            Logging.logger().log(Level.SEVERE, string5);
            throw new WWRuntimeException(string5);
        }
    }
}

