/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.j2d.TextRenderer;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.TextureCache;
import gov.nasa.worldwind.data.ImageIOReader;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FrameFactory;
import gov.nasa.worldwind.render.MultiLineTextRenderer;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.util.logging.Level;
import javax.media.opengl.GL;

public abstract class AbstractAnnotation
extends AVListImpl
implements Annotation {
    protected String text;
    protected AnnotationAttributes attributes = new AnnotationAttributes();
    private boolean alwaysOnTop = false;
    protected RenderInfo renderInfo;
    protected Object delegateOwner;
    private float[] compArray;
    private Dimension minSize = new Dimension(1, 1);
    private PickSupport pickSupport;
    protected double scaleFactor;
    protected double alphaFactor;
    protected Rectangle drawRectangle;
    protected Rectangle freeRectangle;

    protected abstract void doDraw(DrawContext var1);

    protected AbstractAnnotation() {
        if (!WorldWind.getMemoryCacheSet().containsCache(AnnotationTexture.class.getName())) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.AnnotationImageSourceCacheSize", 3000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName("Annotation Image Sources");
            WorldWind.getMemoryCacheSet().addCache(AnnotationTexture.class.getName(), basicMemoryCache);
        }
    }

    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.text = string;
    }

    public AnnotationAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AnnotationAttributes annotationAttributes) {
        if (annotationAttributes == null) {
            String string = Logging.getMessage("nullValue.AnnotationAttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = annotationAttributes;
    }

    public void render(DrawContext drawContext) {
        drawContext.getAnnotationRenderer().render(drawContext, this, null);
    }

    public void draw(DrawContext drawContext) {
        this.doDraw(drawContext);
    }

    public void pick(DrawContext drawContext, Point point) {
        drawContext.getAnnotationRenderer().pick(drawContext, this, null, point, null);
    }

    public void dispose() {
    }

    protected TextRenderer getTextRenderer(DrawContext drawContext, Font font) {
        TextRenderer textRenderer = drawContext.getTextRendererCache().get(font);
        if (textRenderer == null) {
            textRenderer = new TextRenderer(font, true, true);
            textRenderer.setUseVertexArrays(false);
            drawContext.getTextRendererCache().add(font, textRenderer);
        }
        return textRenderer;
    }

    protected RenderInfo getRenderInfo(DrawContext drawContext, Annotation annotation) {
        return this.renderInfo;
    }

    protected void cacheRenderInfo(Annotation annotation, RenderInfo renderInfo) {
        this.renderInfo = renderInfo;
    }

    protected AnnotationTexture getAnnotationTexture(Object object) {
        return (AnnotationTexture)WorldWind.getMemoryCache(AnnotationTexture.class.getName()).getObject(object);
    }

    protected void putAnnotationTexture(Object object, AnnotationTexture annotationTexture) {
        WorldWind.getMemoryCache(AnnotationTexture.class.getName()).add(object, annotationTexture);
    }

    public PickSupport getPickSupport() {
        return this.pickSupport;
    }

    public void setPickSupport(PickSupport pickSupport) {
        if (pickSupport == null) {
            String string = Logging.getMessage("nullValue.PickSupportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pickSupport = pickSupport;
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setAlwaysOnTop(boolean bl) {
        this.alwaysOnTop = bl;
    }

    protected void drawAnnotation(DrawContext drawContext, Point point, double d, double d2, Position position) {
        Object object;
        Object object2;
        Double d3;
        Double d4;
        Rectangle2D rectangle2D;
        String string;
        TextRenderer textRenderer = this.getTextRenderer(drawContext, this.attributes.getFont());
        MultiLineTextRenderer multiLineTextRenderer = new MultiLineTextRenderer(textRenderer);
        multiLineTextRenderer.setLineSpacing(-2);
        multiLineTextRenderer.setTextAlign(this.attributes.getTextAlign());
        AnnotationTexture annotationTexture = null;
        Object object3 = this.attributes.getImageSource();
        if (object3 != null && (annotationTexture = this.getAnnotationTexture(object3)) == null) {
            annotationTexture = new AnnotationTexture(object3);
            this.putAnnotationTexture(object3, annotationTexture);
        }
        Color color = this.attributes.getTextColor();
        Color color2 = this.attributes.getBackgroundColor();
        Color color3 = this.attributes.getBorderColor();
        String string2 = this.attributes.getFrameShape();
        String string3 = this.attributes.getLeader();
        String string4 = this.attributes.getAdjustWidthToText();
        Insets insets = this.attributes.getInsets();
        double d5 = this.attributes.getBorderWidth();
        Point point2 = this.attributes.getDrawOffset();
        int n = this.attributes.getCornerRadius();
        this.scaleFactor = this.attributes.getScale() * d;
        this.alphaFactor = this.attributes.getOpacity() * d2;
        if (this.attributes.isHighlighted()) {
            this.scaleFactor *= this.attributes.getHighlightScale();
            this.alphaFactor = 1.0;
        }
        Dimension dimension = this.attributes.getSize();
        dimension.setSize(Math.max(dimension.getWidth(), this.minSize.getWidth()), dimension.getHeight() > 0.0 ? Math.max(dimension.getHeight(), this.minSize.getHeight()) : 0.0);
        Dimension dimension2 = new Dimension((int)dimension.getWidth() - insets.left - insets.right, dimension.getHeight() > 0.0 ? Math.max((int)dimension.getHeight() - insets.top - insets.bottom, 1) : 0);
        DoubleBuffer doubleBuffer = null;
        DoubleBuffer doubleBuffer2 = null;
        RenderInfo renderInfo = this.getRenderInfo(drawContext, this);
        RenderInfo renderInfo2 = new RenderInfo(this.getText(), dimension, insets, this.attributes.getFont(), d5, this.attributes.getImageSource(), string2, string3, n, point2, string4, null, null, null, null);
        if (renderInfo2.equals(renderInfo)) {
            string = renderInfo.getDrawText();
            rectangle2D = renderInfo.getTextBounds();
            doubleBuffer = renderInfo.getVertices();
            doubleBuffer2 = renderInfo.getTextureCoordinates();
            d4 = string4.equals("render.Annotation.SizeFitText") && this.getText().length() > 0 ? Double.valueOf(rectangle2D.getWidth() + (double)insets.left + (double)insets.right) : Double.valueOf(dimension.getWidth());
            d3 = dimension.getHeight() > 0.0 ? dimension.getHeight() : rectangle2D.getHeight() + (double)insets.top + (double)insets.bottom;
        } else {
            if (this.getText().length() > 0) {
                if (MultiLineTextRenderer.containsHTML(this.getText())) {
                    string = MultiLineTextRenderer.processLineBreaksHTML(this.getText());
                    string = multiLineTextRenderer.wrapHTML(string, dimension2, drawContext.getTextRendererCache());
                    rectangle2D = multiLineTextRenderer.getBoundsHTML(string, drawContext.getTextRendererCache());
                } else {
                    string = multiLineTextRenderer.wrap(this.getText(), dimension2);
                    rectangle2D = multiLineTextRenderer.getBounds(string);
                }
            } else {
                string = "";
                rectangle2D = new Rectangle(0, 0, 0, 0);
            }
            d4 = string4.equals("render.Annotation.SizeFitText") && this.getText().length() > 0 ? Double.valueOf(rectangle2D.getWidth() + (double)insets.left + (double)insets.right) : Double.valueOf(dimension.getWidth());
            d3 = dimension.getHeight() > 0.0 ? dimension.getHeight() : rectangle2D.getHeight() + (double)insets.top + (double)insets.bottom;
            if (!string2.equals("Render.FrameFactory.ShapeNone")) {
                object2 = new Point((int)(d4 / 2.0 - (double)point2.x), -point2.y);
                doubleBuffer = this.attributes.getLeader().equals("Render.FrameFactory.LeaderTriangle") ? FrameFactory.createShapeWithLeaderBuffer(string2, d4, d3, (Point)object2, n) : FrameFactory.createShapeBuffer(string2, d4, d3, n);
                doubleBuffer2 = null;
                if (annotationTexture != null && doubleBuffer != null && (object = annotationTexture.getTexture(drawContext)) != null) {
                    doubleBuffer2 = FrameFactory.getTextureCoordinates(doubleBuffer, d4, d3, ((Texture)object).getWidth(), ((Texture)object).getHeight());
                }
            }
            renderInfo2 = new RenderInfo(this.getText(), dimension, insets, this.attributes.getFont(), d5, this.attributes.getImageSource(), string2, string3, n, point2, string4, string, (Rectangle)rectangle2D, doubleBuffer, doubleBuffer2);
            this.cacheRenderInfo(this, renderInfo2);
        }
        this.drawRectangle = new Rectangle((int)((double)(point.x + point2.x) - d4 / 2.0 + (double)insets.left), point.y + point2.y + insets.bottom, (int)(d4 - (double)insets.left - (double)insets.right - 1.0), (int)(d3 - (double)insets.bottom - (double)insets.top - 1.0));
        this.freeRectangle = new Rectangle(this.drawRectangle.x, this.drawRectangle.y, this.drawRectangle.width, this.drawRectangle.height - (int)rectangle2D.getHeight());
        object2 = drawContext.getGL();
        object2.glMatrixMode(5888);
        object2.glLoadIdentity();
        object2.glTranslated(point.x, point.y, 0.0);
        object2.glScaled(this.scaleFactor, this.scaleFactor, 1.0);
        object2.glTranslated(-d4.doubleValue() / 2.0 + (double)point2.x, point2.y, 0.0);
        if (drawContext.isPickingMode()) {
            object = drawContext.getUniquePickColor();
            int n2 = ((Color)object).getRGB();
            this.pickSupport.addPickableObject(n2, this.delegateOwner != null ? this.delegateOwner : this, position, false);
            object2.glColor3ub((byte)((Color)object).getRed(), (byte)((Color)object).getGreen(), (byte)((Color)object).getBlue());
        } else {
            this.setDrawColor(drawContext, new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), (int)((double)color2.getAlpha() * this.alphaFactor)));
        }
        if (doubleBuffer != null && (color2.getAlpha() > 10 || drawContext.isPickingMode())) {
            object2.glDisable(3553);
            FrameFactory.drawBuffer(drawContext, 6, doubleBuffer);
        }
        if (!drawContext.isPickingMode() && annotationTexture != null && doubleBuffer != null && annotationTexture.bind(drawContext)) {
            if (this.attributes.getImageRepeat().equals("render.Annotation.RepeatX") || this.attributes.getImageRepeat().equals("render.Annotation.RepeatXY")) {
                object2.glTexParameteri(3553, 10242, 10497);
            } else {
                object2.glTexParameteri(3553, 10242, 33069);
            }
            if (this.attributes.getImageRepeat().equals("render.Annotation.RepeatY") || this.attributes.getImageRepeat().equals("render.Annotation.RepeatXY")) {
                object2.glTexParameteri(3553, 10243, 10497);
            } else {
                object2.glTexParameteri(3553, 10243, 33069);
            }
            object2.glMatrixMode(5890);
            object2.glLoadIdentity();
            annotationTexture.applyTransform(drawContext, this.attributes);
            object2.glEnable(3553);
            object2.glTexEnvf(8960, 8704, 8448.0f);
            byte by = (byte)(this.attributes.getImageOpacity() * this.alphaFactor * 255.0);
            object2.glColor4ub(by, by, by, by);
            FrameFactory.drawBuffer(drawContext, 6, doubleBuffer, doubleBuffer2);
            object2.glDisable(3553);
            object2.glLoadIdentity();
            object2.glMatrixMode(5888);
        }
        if (!drawContext.isPickingMode() && d5 > 0.0 && doubleBuffer != null) {
            object2.glLineWidth((float)(d5 * this.scaleFactor));
            this.setDrawColor(drawContext, new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), (int)((double)color3.getAlpha() * this.alphaFactor)));
            if (this.attributes.getBorderStippleFactor() > 0) {
                object2.glEnable(2852);
                object2.glLineStipple(this.attributes.getBorderStippleFactor(), this.attributes.getBorderStipplePattern());
            } else {
                object2.glDisable(2852);
            }
            if (this.attributes.getAntiAliasHint() == 4354) {
                object2.glEnable(2848);
                object2.glHint(3154, this.attributes.getAntiAliasHint());
                object2.glEnable(3042);
                object2.glBlendFunc(770, 771);
            } else {
                object2.glDisable(2848);
            }
            FrameFactory.drawBuffer(drawContext, 3, doubleBuffer);
            object2.glLineWidth(1.0f);
        }
        double d6 = rectangle2D.getMinY() / 6.0;
        object2.glLoadIdentity();
        object2.glTranslated(point.x, point.y, 0.0);
        object2.glScaled(this.scaleFactor, this.scaleFactor, 1.0);
        if (this.getText().length() == 0) {
            return;
        }
        Point point3 = new Point((int)(-d4.doubleValue() / 2.0 + (double)insets.left + (double)point2.x), (int)((double)(point2.y + insets.bottom) + (dimension2.getHeight() > 0.0 ? dimension2.getHeight() : rectangle2D.getHeight()) + d6) + 2);
        if (this.attributes.getTextAlign() == 1) {
            point3.setLocation(point2.x + (insets.left - insets.right) / 2, point3.y);
        }
        if (this.attributes.getTextAlign() == 2) {
            point3.setLocation((int)(d4 / 2.0 - (double)insets.right + (double)point2.x), point3.y);
        }
        if (MultiLineTextRenderer.containsHTML(this.getText())) {
            if (!drawContext.isPickingMode()) {
                multiLineTextRenderer.setTextColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() * this.alphaFactor)));
                multiLineTextRenderer.drawHTML(string, point3.x, point3.y, drawContext.getTextRendererCache());
            } else if (drawContext.getPickPoint() != null && this.getRectangleInViewportCoordinates(drawContext, this.drawRectangle, point, this.scaleFactor).contains(drawContext.getPickPoint())) {
                multiLineTextRenderer.pickHTML(string, point3.x, point3.y, drawContext.getTextRendererCache(), drawContext, this.pickSupport, this.delegateOwner != null ? this.delegateOwner : this, position);
            }
        } else if (!drawContext.isPickingMode()) {
            multiLineTextRenderer.setTextColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() * this.alphaFactor)));
            multiLineTextRenderer.setBackColor(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), (int)((double)color2.getAlpha() * this.alphaFactor)));
            multiLineTextRenderer.getTextRenderer().begin3DRendering();
            multiLineTextRenderer.draw(string, point3.x, point3.y, (int)rectangle2D.getMinY(), this.attributes.getEffect());
            multiLineTextRenderer.getTextRenderer().end3DRendering();
        } else if (drawContext.getPickPoint() != null && this.getRectangleInViewportCoordinates(drawContext, this.drawRectangle, point, this.scaleFactor).contains(drawContext.getPickPoint())) {
            multiLineTextRenderer.pick(string, point3.x, point3.y, (int)rectangle2D.getMinY(), drawContext, this.pickSupport, this.delegateOwner != null ? this.delegateOwner : this, position);
        }
    }

    protected double computeLookAtDistance(DrawContext drawContext) {
        View view = drawContext.getView();
        Position position = view.computePositionFromScreenPoint(view.getViewport().getWidth() / 2.0, view.getViewport().getHeight() / 2.0);
        if (position == null) {
            return view.getEyePosition().getElevation();
        }
        return view.getEyePoint().distanceTo3(drawContext.getGlobe().computePointFromPosition(position));
    }

    protected Rectangle getRectangleInViewportCoordinates(DrawContext drawContext, Rectangle rectangle, Point point, double d) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.translate(-point.x, -point.y);
        rectangle2.setRect((double)rectangle2.x * d, (double)rectangle2.y * d, (double)rectangle2.width * d, (double)rectangle2.height * d);
        rectangle2.translate(point.x, point.y);
        return new Rectangle(rectangle2.x, drawContext.getView().getViewport().height - rectangle2.y - rectangle2.height, rectangle2.width, rectangle2.height);
    }

    protected void setDrawColor(DrawContext drawContext, float f, float f2, float f3, float f4) {
        GL gL = drawContext.getGL();
        drawContext.getGL().glColor4f(f * f4, f2 * f4, f3 * f4, f4);
    }

    protected void setDrawColor(DrawContext drawContext, Color color) {
        if (this.compArray == null) {
            this.compArray = new float[4];
        }
        color.getRGBComponents(this.compArray);
        this.setDrawColor(drawContext, this.compArray[0], this.compArray[1], this.compArray[2], this.compArray[3]);
    }

    protected void setDepthFunc(DrawContext drawContext, Vec4 vec4) {
        GL gL = drawContext.getGL();
        Position position = drawContext.getView().getEyePosition();
        if (position == null) {
            gL.glDepthFunc(519);
            return;
        }
        double d = position.getElevation();
        if (d < drawContext.getGlobe().getMaxElevation() * drawContext.getVerticalExaggeration()) {
            double d2 = vec4.z - 0.00391006472;
            d2 = d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
            gL.glDepthFunc(513);
            gL.glDepthRange(d2, d2);
        } else if (vec4.z >= 1.0) {
            gL.glDepthFunc(514);
            gL.glDepthRange(1.0, 1.0);
        } else {
            gL.glDepthFunc(519);
        }
    }

    public String getRestorableState() {
        String string;
        RestorableSupport restorableSupport = null;
        if (this.attributes != null && (string = this.attributes.getRestorableState()) != null) {
            try {
                restorableSupport = RestorableSupport.parse(string);
            }
            catch (Exception exception) {
                String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
                Logging.logger().severe(string2);
            }
        }
        if (restorableSupport == null) {
            restorableSupport = RestorableSupport.newRestorableSupport();
        }
        if (restorableSupport == null) {
            return null;
        }
        if (this.text != null) {
            restorableSupport.addStateValueAsString("text", this.text, true);
        }
        restorableSupport.addStateValueAsBoolean("alwaysOnTop", this.alwaysOnTop);
        return restorableSupport.getStateAsXml();
    }

    public void restoreState(String string) {
        Boolean bl;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AnnotationAttributes annotationAttributes = this.attributes;
        if (annotationAttributes == null) {
            annotationAttributes = new AnnotationAttributes();
        }
        annotationAttributes.restoreState(string);
        this.setAttributes(annotationAttributes);
        String string4 = restorableSupport.getStateValueAsString("text");
        if (string4 != null) {
            this.setText(string4);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean("alwaysOnTop")) != null) {
            this.setAlwaysOnTop(bl);
        }
    }

    protected static class AnnotationTexture
    implements Cacheable {
        private Object source;
        private int[] sourceDimensions;

        public AnnotationTexture(Object object) {
            if (object == null) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
            this.source = object;
        }

        public Object getSource() {
            return this.source;
        }

        public int[] getSourceDimensions() {
            if (this.sourceDimensions == null) {
                this.sourceDimensions = this.getImageDimensionsFromSource();
            }
            return this.sourceDimensions;
        }

        public Texture getTexture(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
            Texture texture = this.getTexture(drawContext.getTextureCache());
            if (texture == null) {
                texture = this.initializeTexture(drawContext);
            }
            return texture;
        }

        public boolean bind(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
            Texture texture = this.getTexture(drawContext.getTextureCache());
            if (texture == null && (texture = this.initializeTexture(drawContext)) != null) {
                return true;
            }
            if (texture != null) {
                texture.bind();
            }
            return texture != null;
        }

        public void applyTransform(DrawContext drawContext, AnnotationAttributes annotationAttributes) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
            Texture texture = this.getTexture(drawContext.getTextureCache());
            if (texture == null) {
                texture = this.initializeTexture(drawContext);
            }
            int[] nArray = this.getSourceDimensions();
            GL gL = drawContext.getGL();
            gL.glScaled(1.0 / annotationAttributes.getImageScale(), 1.0 / annotationAttributes.getImageScale(), 1.0);
            if (annotationAttributes.getImageOffset() != null) {
                gL.glTranslated((double)(-annotationAttributes.getImageOffset().x) / (double)nArray[0], (double)(-annotationAttributes.getImageOffset().y) / (double)nArray[1], 0.0);
            }
            gL.glScaled((double)texture.getWidth() / (double)nArray[0], (double)texture.getHeight() / (double)nArray[1], 1.0);
            if (texture.getMustFlipVertically()) {
                gL.glScaled(1.0, -1.0, 1.0);
                gL.glTranslated(0.0, -1.0, 0.0);
            }
        }

        public long getSizeInBytes() {
            return this.getSizeOfSource();
        }

        protected Texture getTexture(TextureCache textureCache) {
            return textureCache.get(this.source);
        }

        protected void setTexture(TextureCache textureCache, Texture texture) {
            textureCache.put(this.source, texture);
        }

        protected Texture initializeTexture(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
            Texture texture = this.getTexture(drawContext.getTextureCache());
            if (texture != null) {
                return texture;
            }
            BufferedImage bufferedImage = this.getImageFromSource();
            if (bufferedImage == null) {
                return null;
            }
            this.sourceDimensions = new int[]{bufferedImage.getWidth(), bufferedImage.getHeight()};
            BufferedImage bufferedImage2 = ImageUtil.convertToPowerOfTwoImage(bufferedImage, true);
            try {
                texture = TextureIO.newTexture(bufferedImage2, true);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "layers.TextureLayer.ExceptionAttemptingToReadTextureFile", exception);
                return null;
            }
            this.setTexture(drawContext.getTextureCache(), texture);
            texture.bind();
            GL gL = drawContext.getGL();
            gL.glTexParameteri(3553, 10241, 9987);
            gL.glTexParameteri(3553, 10240, 9729);
            gL.glTexParameteri(3553, 10242, 33071);
            gL.glTexParameteri(3553, 10243, 33071);
            return texture;
        }

        protected BufferedImage getImageFromSource() {
            try {
                BufferedImage bufferedImage;
                if (this.source instanceof BufferedImage) {
                    bufferedImage = (BufferedImage)this.source;
                } else {
                    ImageIOReader imageIOReader = new ImageIOReader();
                    bufferedImage = imageIOReader.read(this.source);
                }
                return bufferedImage;
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("generic.IOExceptionDuringTextureInitialization");
                Logging.logger().log(Level.SEVERE, string, iOException);
                return null;
            }
        }

        protected int[] getImageDimensionsFromSource() {
            try {
                int[] nArray;
                if (this.source instanceof BufferedImage) {
                    BufferedImage bufferedImage = (BufferedImage)this.source;
                    nArray = new int[]{bufferedImage.getWidth(), bufferedImage.getHeight()};
                } else {
                    AVListImpl aVListImpl = new AVListImpl();
                    ImageIOReader imageIOReader = new ImageIOReader();
                    imageIOReader.readMetadata(this.source, aVListImpl);
                    Integer n = AVListImpl.getIntegerValue(aVListImpl, "gov.nasa.worldwind.avkey.Width");
                    Integer n2 = AVListImpl.getIntegerValue(aVListImpl, "gov.nasa.worldwind.avkey.Height");
                    nArray = new int[]{n, n2};
                }
                return nArray;
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("generic.IOExceptionDuringTextureInitialization");
                Logging.logger().log(Level.SEVERE, string, iOException);
                return null;
            }
        }

        protected long getSizeOfSource() {
            if (this.source instanceof BufferedImage) {
                return ImageUtil.computeSizeInBytes((BufferedImage)this.source);
            }
            return 1L;
        }
    }

    private class RenderInfo {
        private final String text;
        private final Dimension size;
        private final Insets insets;
        private final Font font;
        private final double borderWidth;
        private final Object imageSource;
        private final String shape;
        private final String leader;
        private final int cornerRadius;
        private final Point offset;
        private final String adjustWidthToText;
        private final String drawText;
        private final Rectangle textBounds;
        private final DoubleBuffer verts;
        private final DoubleBuffer coords;

        public RenderInfo(String string, Dimension dimension, Insets insets, Font font, double d, Object object, String string2, String string3, int n, Point point, String string4, String string5, Rectangle rectangle, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
            this.text = string;
            this.size = dimension;
            this.insets = insets;
            this.font = font;
            this.borderWidth = d;
            this.imageSource = object;
            this.shape = string2;
            this.leader = string3;
            this.cornerRadius = n;
            this.offset = point;
            this.adjustWidthToText = string4;
            this.drawText = string5;
            this.textBounds = rectangle;
            this.verts = doubleBuffer;
            this.coords = doubleBuffer2;
        }

        public String getDrawText() {
            return this.drawText;
        }

        public Rectangle getTextBounds() {
            return this.textBounds;
        }

        public DoubleBuffer getVertices() {
            return this.verts;
        }

        public DoubleBuffer getTextureCoordinates() {
            return this.coords;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RenderInfo renderInfo = (RenderInfo)object;
            if (this.text == null ^ renderInfo.text == null) {
                return false;
            }
            if (this.text != null && renderInfo.text != null && !this.text.equals(renderInfo.text)) {
                return false;
            }
            if (this.size == null ^ renderInfo.size == null) {
                return false;
            }
            if (this.size != null && renderInfo.size != null && !this.size.equals(renderInfo.size)) {
                return false;
            }
            if (this.insets == null ^ renderInfo.insets == null) {
                return false;
            }
            if (this.insets != null && renderInfo.insets != null && !this.insets.equals(renderInfo.insets)) {
                return false;
            }
            if (this.font == null ^ renderInfo.font == null) {
                return false;
            }
            if (this.font != null && renderInfo.font != null && !this.font.equals(renderInfo.font)) {
                return false;
            }
            if (this.borderWidth != renderInfo.borderWidth) {
                return false;
            }
            if (this.imageSource == null ^ renderInfo.imageSource == null) {
                return false;
            }
            if (this.imageSource != null && renderInfo.imageSource != null && !this.imageSource.equals(renderInfo.imageSource)) {
                return false;
            }
            if (this.shape == null ^ renderInfo.shape == null) {
                return false;
            }
            if (this.shape != null && renderInfo.shape != null && !this.shape.equals(renderInfo.shape)) {
                return false;
            }
            if (this.leader == null ^ renderInfo.leader == null) {
                return false;
            }
            if (this.leader != null && renderInfo.leader != null && !this.leader.equals(renderInfo.leader)) {
                return false;
            }
            if (this.cornerRadius != renderInfo.cornerRadius) {
                return false;
            }
            if (this.offset == null ^ renderInfo.offset == null) {
                return false;
            }
            if (this.offset != null && renderInfo.offset != null && this.offset.distance(renderInfo.offset) != 0.0) {
                return false;
            }
            if (this.adjustWidthToText == null ^ renderInfo.adjustWidthToText == null) {
                return false;
            }
            return this.adjustWidthToText == null || renderInfo.adjustWidthToText == null || this.adjustWidthToText.equals(renderInfo.adjustWidthToText);
        }
    }
}

