/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.AbstractSurfaceObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.TiledSurfaceObjectRenderer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLOrtho2DSupport;
import gov.nasa.worldwind.util.OGLStateSupport;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Color;
import java.util.Arrays;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSurfaceRenderable
extends AbstractSurfaceObject
implements PreRenderable,
Renderable {
    private double opacity = 1.0;
    protected TiledSurfaceObjectRenderer renderer;
    protected final OGLStateSupport stateSupport = new OGLStateSupport();
    protected final OGLOrtho2DSupport renderToTextureSupport = new OGLOrtho2DSupport();
    protected final PickSupport pickSupport = new PickSupport();

    @Override
    public abstract Iterable<? extends Sector> getSectors(DrawContext var1);

    @Override
    public abstract void doRenderToRegion(DrawContext var1, Sector var2, int var3, int var4, int var5, int var6);

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        this.opacity = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getRenderer().preRender(drawContext);
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getRenderer().render(drawContext);
    }

    protected TiledSurfaceObjectRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new TiledSurfaceObjectRenderer();
            this.renderer.setPickEnabled(false);
            this.renderer.setSurfaceObjects(Arrays.asList(this));
        }
        return this.renderer;
    }

    protected Angle getViewHeading(DrawContext drawContext) {
        Angle angle = Angle.ZERO;
        if (drawContext.getView() instanceof OrbitView) {
            angle = ((OrbitView)drawContext.getView()).getHeading();
        }
        return angle;
    }

    protected double computePixelSizeAtLocation(DrawContext drawContext, LatLon latLon) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), globe.getElevation(latLon.getLatitude(), latLon.getLongitude()));
        double d = drawContext.getView().getEyePoint().distanceTo3(vec4);
        return drawContext.getView().computePixelSizeAtDistance(d);
    }

    protected double computeDrawPixelSize(DrawContext drawContext, Sector sector, int n, int n2) {
        return drawContext.getGlobe().getRadius() * sector.getDeltaLatRadians() / (double)n2;
    }

    protected Vec4 computeDrawPoint(LatLon latLon, Sector sector, int n, int n2, int n3, int n4) {
        Matrix matrix = Matrix.fromGeographicToViewport(sector, n, n2, n3, n4);
        Vec4 vec4 = new Vec4(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 1.0);
        return vec4.transformBy4(matrix);
    }

    protected Sector computeRotatedSectorBounds(Sector sector, LatLon latLon, Angle angle) {
        LatLon[] latLonArray = new LatLon[]{new LatLon(sector.getMaxLatitude(), sector.getMinLongitude()), new LatLon(sector.getMaxLatitude(), sector.getMaxLongitude()), new LatLon(sector.getMinLatitude(), sector.getMinLongitude()), new LatLon(sector.getMinLatitude(), sector.getMaxLongitude())};
        for (int i = 0; i < latLonArray.length; ++i) {
            Angle angle2 = LatLon.greatCircleAzimuth(latLon, latLonArray[i]);
            Angle angle3 = LatLon.greatCircleDistance(latLon, latLonArray[i]);
            latLonArray[i] = LatLon.greatCircleEndPosition(latLon, angle2.add(angle), angle3);
        }
        return Sector.boundingSector(Arrays.asList(latLonArray));
    }

    protected void applyPremultipliedAlphaColor(GL gL, Color color, double d) {
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[3] = (float)WWMath.clamp(d, 0.0, 1.0);
        fArray[0] = fArray[0] * fArray[3];
        fArray[1] = fArray[1] * fArray[3];
        fArray[2] = fArray[2] * fArray[3];
        gL.glColor4fv(fArray, 0);
    }
}

