/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FrameFactory;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.TiledSurfaceObjectRenderer;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Insets;
import java.awt.Point;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationShadow
extends GlobeAnnotation
implements PreRenderable {
    protected SurfacePolygon shadowShape;
    protected TiledSurfaceObjectRenderer surfaceRenderer;
    private double shadowOpacity = 0.3;

    public AnnotationShadow(String string, Position position) {
        super(string, position);
    }

    public double getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setShadowOpacity(double d) {
        double d2 = d < 0.0 ? 0.0 : (this.shadowOpacity = d > 1.0 ? 1.0 : d);
        if (this.shadowShape != null) {
            this.shadowShape.getAttributes().setInteriorOpacity(this.shadowOpacity);
            this.shadowShape.getAttributes().setOutlineOpacity(this.shadowOpacity / 2.0);
        }
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (this.shadowShape != null) {
            this.getSurfaceRenderer().preRender(drawContext);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (this.shadowShape != null) {
            this.getSurfaceRenderer().render(drawContext);
        }
        super.render(drawContext);
    }

    @Override
    protected void drawAnnotation(DrawContext drawContext, Point point, double d, double d2, Position position) {
        super.drawAnnotation(drawContext, point, d, d2, position);
        ArrayList<LatLon> arrayList = this.computeShadowLocations(drawContext);
        if (arrayList == null) {
            return;
        }
        if (this.shadowShape == null) {
            this.shadowShape = new SurfacePolygon(arrayList);
            this.shadowShape.getAttributes().setInteriorMaterial(Material.BLACK);
            this.shadowShape.getAttributes().setOutlineMaterial(Material.BLACK);
            this.shadowShape.getAttributes().setInteriorOpacity(this.shadowOpacity);
            this.shadowShape.getAttributes().setOutlineOpacity(this.shadowOpacity / 2.0);
        } else {
            this.shadowShape.setLocations(arrayList);
        }
    }

    protected ArrayList<LatLon> computeShadowLocations(DrawContext drawContext) {
        Globe globe = drawContext.getGlobe();
        DoubleBuffer doubleBuffer = this.getCalloutVertices();
        Matrix matrix = this.computeCalloutTransform(drawContext, this.getPosition());
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        int n = doubleBuffer.limit() / 2;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Vec4 vec4 = new Vec4(doubleBuffer.get(n2++), doubleBuffer.get(n2++), 0.0);
            vec4 = vec4.transformBy4(matrix);
            Position position = globe.computePositionFromPoint(vec4);
            arrayList.add(position.getLatLon());
        }
        return arrayList;
    }

    protected DoubleBuffer getCalloutVertices() {
        Insets insets = this.getAttributes().getInsets();
        Point point = this.getAttributes().getDrawOffset();
        String string = this.getAttributes().getFrameShape();
        String string2 = this.getAttributes().getLeader();
        int n = this.getAttributes().getCornerRadius();
        int n2 = this.drawRectangle.width + insets.left + insets.right + 1;
        int n3 = this.drawRectangle.height + insets.bottom + insets.top + 1;
        Point point2 = new Point(n2 / 2 - point.x, -point.y);
        return string2.equals("Render.FrameFactory.LeaderTriangle") ? FrameFactory.createShapeWithLeaderBuffer(string, n2, n3, point2, n) : FrameFactory.createShapeBuffer(string, n2, n3, n);
    }

    protected Matrix computeCalloutTransform(DrawContext drawContext, Position position) {
        Insets insets = this.getAttributes().getInsets();
        Point point = this.getAttributes().getDrawOffset();
        int n = this.drawRectangle.width + insets.left + insets.right + 1;
        Point point2 = new Point(n / 2 - point.x, -point.y);
        double d = this.getPixelSizeAtLocation(drawContext, position);
        Matrix matrix = Matrix.IDENTITY;
        matrix = matrix.multiply(drawContext.getGlobe().computeTransformToPosition(position));
        matrix = matrix.multiply(Matrix.fromScale(d * this.scaleFactor));
        matrix = matrix.multiply(Matrix.fromRotationZ(this.getDrawHeading(drawContext).multiply(-1.0)));
        matrix = matrix.multiply(Matrix.fromTranslation(-point2.x, -point2.y, 0.0));
        return matrix;
    }

    protected double getPixelSizeAtLocation(DrawContext drawContext, LatLon latLon) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), globe.getElevation(latLon.getLatitude(), latLon.getLongitude()));
        double d = drawContext.getView().getEyePoint().distanceTo3(vec4);
        return drawContext.getView().computePixelSizeAtDistance(d);
    }

    protected Angle getDrawHeading(DrawContext drawContext) {
        Angle angle = Angle.ZERO;
        if (drawContext.getView() instanceof OrbitView) {
            angle = ((OrbitView)drawContext.getView()).getHeading();
        }
        return angle;
    }

    protected TiledSurfaceObjectRenderer getSurfaceRenderer() {
        if (this.surfaceRenderer == null) {
            this.surfaceRenderer = new TiledSurfaceObjectRenderer();
            this.surfaceRenderer.setPickEnabled(false);
            this.surfaceRenderer.setSurfaceObjects(Arrays.asList(this.shadowShape));
        }
        return this.surfaceRenderer;
    }
}

