/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationRenderer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.Iterator;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAnnotationRenderer
implements AnnotationRenderer {
    private PickSupport pickSupport = new PickSupport();

    private static boolean isAnnotationValid(Annotation annotation, boolean bl) {
        if (annotation == null || annotation.getText() == null) {
            return false;
        }
        if (bl && annotation instanceof Locatable) {
            return ((Locatable)((Object)annotation)).getPosition() != null;
        }
        return true;
    }

    @Override
    public void pick(DrawContext drawContext, Iterable<Annotation> iterable, Point point, Layer layer) {
        this.drawMany(drawContext, iterable, layer);
    }

    @Override
    public void pick(DrawContext drawContext, Annotation annotation, Vec4 vec4, Point point, Layer layer) {
        if (!BasicAnnotationRenderer.isAnnotationValid(annotation, false)) {
            return;
        }
        this.drawOne(drawContext, annotation, vec4, layer);
    }

    @Override
    public void render(DrawContext drawContext, Iterable<Annotation> iterable) {
        this.drawMany(drawContext, iterable, null);
    }

    @Override
    public void render(DrawContext drawContext, Annotation annotation, Vec4 vec4) {
        if (!BasicAnnotationRenderer.isAnnotationValid(annotation, false)) {
            return;
        }
        this.drawOne(drawContext, annotation, vec4, null);
    }

    private void drawMany(DrawContext drawContext, Iterable<Annotation> iterable, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.AnnotationIterator");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<Annotation> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            if (!BasicAnnotationRenderer.isAnnotationValid(annotation, true) || !annotation.getAttributes().isVisible()) continue;
            double d = 1.0;
            if (annotation instanceof Locatable) {
                Vec4 vec4 = this.getAnnotationDrawPoint(drawContext, annotation);
                if (vec4 == null) continue;
                d = annotation.isAlwaysOnTop() ? 0.0 : drawContext.getView().getEyePoint().distanceTo3(vec4);
            }
            drawContext.addOrderedRenderable(new OrderedAnnotation(annotation, layer, d));
        }
    }

    private void drawOne(DrawContext drawContext, Annotation annotation, Vec4 vec4, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (!annotation.getAttributes().isVisible()) {
            return;
        }
        double d = 1.0;
        if (annotation instanceof Locatable) {
            if (vec4 == null) {
                Position position = ((Locatable)((Object)annotation)).getPosition();
                if (!drawContext.getVisibleSector().contains(position.getLatitude(), position.getLongitude())) {
                    return;
                }
                vec4 = this.getAnnotationDrawPoint(drawContext, annotation);
                if (vec4 == null) {
                    return;
                }
            }
            if (!drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) {
                return;
            }
            double d2 = drawContext.getView().computeHorizonDistance();
            double d3 = d = annotation.isAlwaysOnTop() ? 0.0 : drawContext.getView().getEyePoint().distanceTo3(vec4);
            if (d > d2) {
                return;
            }
        }
        drawContext.addOrderedRenderable(new OrderedAnnotation(annotation, layer, d));
    }

    @Override
    public Vec4 getAnnotationDrawPoint(DrawContext drawContext, Annotation annotation) {
        Vec4 vec4 = null;
        if (annotation instanceof Locatable) {
            Position position = ((Locatable)((Object)annotation)).getPosition();
            if (position.getElevation() < drawContext.getGlobe().getMaxElevation()) {
                vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(position.getLatitude(), position.getLongitude(), position.getElevation());
            }
            if (vec4 == null) {
                vec4 = drawContext.getGlobe().computePointFromPosition(position);
            }
        }
        return vec4;
    }

    private void beginDrawAnnotations(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        int n = 325893;
        gL.glPushAttrib(n);
        gL.glEnable(2929);
        gL.glDepthMask(false);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.001f);
        gL.glDisable(2896);
        gL.glDisable(2884);
        int[] nArray = new int[4];
        gL.glGetIntegerv(2978, nArray, 0);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glOrtho(0.0, nArray[2], 0.0, nArray[3], -1.0, 1.0);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glMatrixMode(5890);
        gL.glPushMatrix();
        if (drawContext.isPickingMode()) {
            this.pickSupport.beginPicking(drawContext);
            gL.glDisable(3553);
            gL.glDisable(3042);
        } else {
            gL.glEnable(3553);
            gL.glEnable(3042);
            gL.glBlendFunc(1, 771);
        }
    }

    private void endDrawAnnotations(DrawContext drawContext) {
        if (drawContext.isPickingMode()) {
            this.pickSupport.endPicking(drawContext);
        }
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    private class OrderedAnnotation
    implements OrderedRenderable {
        Annotation annotation;
        double eyeDistance;
        Layer layer;

        OrderedAnnotation(Annotation annotation, double d) {
            this.annotation = annotation;
            this.eyeDistance = d;
        }

        OrderedAnnotation(Annotation annotation, Layer layer, double d) {
            this.annotation = annotation;
            this.eyeDistance = d;
            this.layer = layer;
        }

        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render(DrawContext drawContext) {
            BasicAnnotationRenderer.this.beginDrawAnnotations(drawContext);
            try {
                this.annotation.draw(drawContext);
                while (drawContext.getOrderedRenderables().peek() instanceof OrderedAnnotation) {
                    OrderedAnnotation orderedAnnotation = (OrderedAnnotation)drawContext.getOrderedRenderables().poll();
                    orderedAnnotation.annotation.draw(drawContext);
                }
            }
            catch (WWRuntimeException wWRuntimeException) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingAnnotation", wWRuntimeException);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingAnnotation", exception);
            }
            finally {
                BasicAnnotationRenderer.this.endDrawAnnotations(drawContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pick(DrawContext drawContext, Point point) {
            BasicAnnotationRenderer.this.pickSupport.clearPickList();
            BasicAnnotationRenderer.this.beginDrawAnnotations(drawContext);
            try {
                this.annotation.setPickSupport(BasicAnnotationRenderer.this.pickSupport);
                this.annotation.draw(drawContext);
                while (drawContext.getOrderedRenderables().peek() instanceof OrderedAnnotation) {
                    OrderedAnnotation orderedAnnotation = (OrderedAnnotation)drawContext.getOrderedRenderables().poll();
                    orderedAnnotation.annotation.setPickSupport(BasicAnnotationRenderer.this.pickSupport);
                    orderedAnnotation.annotation.draw(drawContext);
                }
            }
            catch (WWRuntimeException wWRuntimeException) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhilePickingAnnotation", wWRuntimeException);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhilePickingAnnotation", exception);
            }
            finally {
                BasicAnnotationRenderer.this.endDrawAnnotations(drawContext);
                BasicAnnotationRenderer.this.pickSupport.resolvePick(drawContext, point, this.layer);
                BasicAnnotationRenderer.this.pickSupport.clearPickList();
            }
        }
    }
}

