/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;

public class BasicShapeAttributes
extends WWObjectImpl
implements ShapeAttributes {
    protected boolean drawInterior;
    protected boolean drawOutline;
    protected boolean enableAntialiasing;
    protected Material interiorMaterial;
    protected Material outlineMaterial;
    protected double interiorOpacity;
    protected double outlineOpacity;
    protected double outlineWidth;

    public BasicShapeAttributes() {
        this.drawInterior = true;
        this.drawOutline = true;
        this.enableAntialiasing = true;
        this.interiorMaterial = Material.WHITE;
        this.outlineMaterial = Material.BLACK;
        this.interiorOpacity = 1.0;
        this.outlineOpacity = 1.0;
        this.outlineWidth = 1.0;
    }

    public BasicShapeAttributes(ShapeAttributes shapeAttributes) {
        if (shapeAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.drawInterior = shapeAttributes.isDrawInterior();
        this.drawOutline = shapeAttributes.isDrawOutline();
        this.enableAntialiasing = shapeAttributes.isEnableAntialiasing();
        this.interiorMaterial = shapeAttributes.getInteriorMaterial();
        this.outlineMaterial = shapeAttributes.getOutlineMaterial();
        this.interiorOpacity = shapeAttributes.getInteriorOpacity();
        this.outlineOpacity = shapeAttributes.getOutlineOpacity();
        this.outlineWidth = shapeAttributes.getOutlineWidth();
    }

    public boolean isDrawInterior() {
        return this.drawInterior;
    }

    public void setDrawInterior(boolean bl) {
        this.drawInterior = bl;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ShapeAttributes", null, this);
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setDrawOutline(boolean bl) {
        this.drawOutline = bl;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ShapeAttributes", null, this);
    }

    public boolean isEnableAntialiasing() {
        return this.enableAntialiasing;
    }

    public void setEnableAntialiasing(boolean bl) {
        this.enableAntialiasing = bl;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ShapeAttributes", null, this);
    }

    public Material getInteriorMaterial() {
        return this.interiorMaterial;
    }

    public void setInteriorMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorMaterial = material;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ShapeAttributes", null, this);
    }

    public Material getOutlineMaterial() {
        return this.outlineMaterial;
    }

    public void setOutlineMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineMaterial = material;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ShapeAttributes", null, this);
    }

    public double getInteriorOpacity() {
        return this.interiorOpacity;
    }

    public void setInteriorOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "opacity < 0 or opacity > 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorOpacity = d;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ShapeAttributes", null, this);
    }

    public double getOutlineOpacity() {
        return this.outlineOpacity;
    }

    public void setOutlineOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "opacity < 0 or opacity > 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineOpacity = d;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ShapeAttributes", null, this);
    }

    public double getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineWidth = d;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ShapeAttributes", null, this);
    }

    public void getRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsBoolean(stateObject, "drawInterior", this.isDrawInterior());
        restorableSupport.addStateValueAsBoolean(stateObject, "drawOutline", this.isDrawOutline());
        restorableSupport.addStateValueAsBoolean(stateObject, "enableAntialiasing", this.isEnableAntialiasing());
        this.getInteriorMaterial().getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "interiorMaterial"));
        this.getOutlineMaterial().getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "outlineMaterial"));
        restorableSupport.addStateValueAsDouble(stateObject, "interiorOpacity", this.getInteriorOpacity());
        restorableSupport.addStateValueAsDouble(stateObject, "outlineOpacity", this.getOutlineOpacity());
        restorableSupport.addStateValueAsDouble(stateObject, "outlineWidth", this.getOutlineWidth());
    }

    public void restoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        RestorableSupport.StateObject stateObject2;
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawInterior");
        if (bl != null) {
            this.setDrawInterior(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawOutline")) != null) {
            this.setDrawOutline(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "enableAntialiasing")) != null) {
            this.setEnableAntialiasing(bl);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "interiorMaterial")) != null) {
            this.setInteriorMaterial(this.getInteriorMaterial().restoreState(restorableSupport, stateObject2));
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "outlineMaterial")) != null) {
            this.setOutlineMaterial(this.getOutlineMaterial().restoreState(restorableSupport, stateObject2));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "interiorOpacity")) != null) {
            this.setInteriorOpacity(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "outlineOpacity")) != null) {
            this.setOutlineOpacity(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "outlineWidth")) != null) {
            this.setOutlineWidth(d);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicShapeAttributes basicShapeAttributes = (BasicShapeAttributes)object;
        if (this.drawOutline != basicShapeAttributes.drawOutline) {
            return false;
        }
        if (this.drawInterior != basicShapeAttributes.drawInterior) {
            return false;
        }
        if (this.enableAntialiasing != basicShapeAttributes.enableAntialiasing) {
            return false;
        }
        if (Double.compare(basicShapeAttributes.outlineOpacity, this.outlineOpacity) != 0) {
            return false;
        }
        if (Double.compare(basicShapeAttributes.interiorOpacity, this.interiorOpacity) != 0) {
            return false;
        }
        if (Double.compare(basicShapeAttributes.outlineWidth, this.outlineWidth) != 0) {
            return false;
        }
        if (this.interiorMaterial != null ? !this.interiorMaterial.equals(basicShapeAttributes.interiorMaterial) : basicShapeAttributes.interiorMaterial != null) {
            return false;
        }
        return !(this.outlineMaterial != null ? !this.outlineMaterial.equals(basicShapeAttributes.outlineMaterial) : basicShapeAttributes.outlineMaterial != null);
    }

    public int hashCode() {
        int n = this.drawInterior ? 1 : 0;
        n = 31 * n + (this.drawOutline ? 1 : 0);
        n = 31 * n + (this.enableAntialiasing ? 1 : 0);
        n = 31 * n + (this.interiorMaterial != null ? this.interiorMaterial.hashCode() : 0);
        n = 31 * n + (this.outlineMaterial != null ? this.outlineMaterial.hashCode() : 0);
        long l = this.interiorOpacity != 0.0 ? Double.doubleToLongBits(this.interiorOpacity) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        l = this.outlineOpacity != 0.0 ? Double.doubleToLongBits(this.outlineOpacity) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        l = this.outlineWidth != 0.0 ? Double.doubleToLongBits(this.outlineWidth) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }
}

