/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class BasicWWTexture
implements WWTexture {
    private Object imageSource;
    private int width;
    private int height;

    public BasicWWTexture(Object object) {
        this.initialize(object);
    }

    protected void initialize(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ImageSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageSource = object;
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isTextureCurrent(DrawContext drawContext) {
        return true;
    }

    public boolean bind(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = drawContext.getTextureCache().get(this.imageSource);
        if (texture == null && (texture = this.initializeTexture(drawContext)) != null) {
            return true;
        }
        if (texture != null) {
            texture.bind();
        }
        return texture != null;
    }

    public void applyInternalTransform(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = drawContext.getTextureCache().get(this.imageSource);
        if (texture == null) {
            texture = this.initializeTexture(drawContext);
        }
        if (texture != null && texture.getMustFlipVertically()) {
            GL gL = GLContext.getCurrent().getGL();
            gL.glMatrixMode(5890);
            gL.glLoadIdentity();
            gL.glScaled(1.0, -1.0, 1.0);
            gL.glTranslated(0.0, -1.0, 0.0);
        }
    }

    protected Texture initializeTexture(DrawContext drawContext) {
        Texture texture;
        Object object;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.imageSource instanceof String) {
            object = (String)this.imageSource;
            Object object2 = WWIO.getFileOrResourceAsStream((String)object, this.getClass());
            if (object2 == null || object2 instanceof Exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionAttemptingToReadImageFile", object2 != null ? object2 : object);
                return null;
            }
            try {
                texture = TextureIO.newTexture((InputStream)object2, true, null);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "layers.TextureLayer.ExceptionAttemptingToReadTextureFile", exception);
                return null;
            }
        } else if (this.imageSource instanceof BufferedImage) {
            try {
                texture = TextureIO.newTexture((BufferedImage)this.imageSource, true);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.IOExceptionDuringTextureInitialization");
                Logging.logger().log(Level.SEVERE, string, exception);
                return null;
            }
        } else {
            Logging.logger().log(Level.SEVERE, "generic.UnrecognizedImageSourceTypeeType", this.imageSource.getClass().getName());
            return null;
        }
        if (texture == null) {
            Logging.logger().log(Level.SEVERE, "generic.TextureUnreadable", this.imageSource instanceof String ? this.imageSource : this.imageSource.getClass().getName());
            return null;
        }
        drawContext.getTextureCache().put(this.imageSource, texture);
        texture.bind();
        object = drawContext.getGL();
        object.glTexParameteri(3553, 10241, 9729);
        object.glTexParameteri(3553, 10240, 9729);
        object.glTexParameteri(3553, 10242, 33071);
        object.glTexParameteri(3553, 10243, 33071);
        this.width = texture.getWidth();
        this.height = texture.getHeight();
        return texture;
    }
}

