/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.ConformingShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.terrain.SectorGeometry;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.measure.AreaMeasurer;
import java.awt.Color;
import java.util.ArrayList;
import javax.media.opengl.GL;

public class ConformingEllipse
extends ConformingShape {
    private LatLon center;
    private double semiMajorAxisLength;
    private double semiMinorAxisLength;
    private Angle orientation;
    private Sector bounds;
    private int serialNumber;
    Vec4 Cxyz = null;
    Vec4 uHat = null;
    Vec4 vHat = null;
    private AreaMeasurer areaMeasurer = null;

    public ConformingEllipse(LatLon latLon, double d, double d2, Angle angle) {
        this(latLon, d, d2, angle, null, null);
    }

    public ConformingEllipse(LatLon latLon, double d, double d2, Angle angle, Color color, Color color2) {
        super(color, color2);
        this.center = latLon;
        this.semiMajorAxisLength = d;
        this.semiMinorAxisLength = d2;
        this.orientation = angle == null ? Angle.ZERO : angle;
        this.serialNumber = ConformingShape.getUniqueSerialNumber();
        this.bounds = null;
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsDouble(stateObject, "semiMajorAxisLength", this.getSemiMajorAxisLength());
        restorableSupport.addStateValueAsDouble(stateObject, "semiMinorAxisLength", this.getSemiMinorAxisLength());
        restorableSupport.addStateValueAsLatLon(stateObject, "center", this.getCenter());
        restorableSupport.addStateValueAsDouble(stateObject, "orientationDegrees", this.getOrientation().degrees);
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        LatLon latLon;
        super.doRestoreState(restorableSupport, stateObject);
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "semiMajorAxisLength");
        Double d3 = restorableSupport.getStateValueAsDouble(stateObject, "semiMinorAxisLength");
        if (d2 != null && d3 != null) {
            this.setAxisLengths(d2, d3);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "center")) != null) {
            this.setCenter(latLon);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "orientationDegrees")) != null) {
            this.setOrientation(Angle.fromDegrees(d));
        }
    }

    public LatLon getCenter() {
        return this.center;
    }

    public void setCenter(LatLon latLon) {
        this.invalidateCache();
        this.center = latLon;
    }

    public double getSemiMajorAxisLength() {
        return this.semiMajorAxisLength;
    }

    public double getSemiMinorAxisLength() {
        return this.semiMinorAxisLength;
    }

    public void setAxisLengths(double d, double d2) {
        this.invalidateCache();
        this.semiMajorAxisLength = d;
        this.semiMinorAxisLength = d2;
    }

    public Angle getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Angle angle) {
        this.invalidateCache();
        this.orientation = angle;
    }

    public Position getReferencePosition() {
        return new Position(this.center.getLatitude(), this.center.getLongitude(), 0.0);
    }

    public double getLength(Globe globe) {
        if (this.areaMeasurer == null) {
            this.makeAreaMeasurer(globe);
        }
        return this.areaMeasurer.getLength(globe);
    }

    public double getArea(Globe globe) {
        if (this.areaMeasurer == null) {
            this.makeAreaMeasurer(globe);
        }
        return this.areaMeasurer.getArea(globe);
    }

    public double getPerimeter(Globe globe) {
        if (this.areaMeasurer == null) {
            this.makeAreaMeasurer(globe);
        }
        return this.areaMeasurer.getPerimeter(globe);
    }

    public double getWidth(Globe globe) {
        if (this.areaMeasurer == null) {
            this.makeAreaMeasurer(globe);
        }
        return this.areaMeasurer.getWidth(globe);
    }

    public double getHeight(Globe globe) {
        if (this.areaMeasurer == null) {
            this.makeAreaMeasurer(globe);
        }
        return this.areaMeasurer.getHeight(globe);
    }

    private void makeAreaMeasurer(Globe globe) {
        if (this.Cxyz == null) {
            this.makeEllipticalReferenceFrame(globe);
        }
        ArrayList<Position> arrayList = new ArrayList<Position>(201);
        double d = 0.031415926535897934;
        double d2 = 0.0;
        double d3 = globe.getRadiusAt(this.center.getLatitude(), this.center.getLongitude());
        for (int i = 0; i < 200; ++i) {
            double d4 = this.semiMajorAxisLength * Math.cos(d2);
            double d5 = this.semiMinorAxisLength * Math.sin(d2);
            d2 += d;
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            double d7 = 1.5707963267948966 - (Math.acos(d4 / d6) * Math.signum(d5) + this.orientation.radians);
            LatLon latLon = LatLon.greatCircleEndPosition(this.center, d7, d6 / d3);
            arrayList.add(new Position(latLon.getLatitude(), latLon.getLongitude(), 0.0));
        }
        arrayList.add((Position)arrayList.get(0));
        this.areaMeasurer = new AreaMeasurer(arrayList);
        this.areaMeasurer.setFollowTerrain(true);
    }

    private void makeEllipticalReferenceFrame(Globe globe) {
        this.Cxyz = globe.computePointFromPosition(this.center.getLatitude(), this.center.getLongitude(), 0.0);
        double d = globe.getRadiusAt(this.center.getLatitude(), this.center.getLongitude());
        double d2 = 1.5707963267948966 + this.orientation.radians;
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(4);
        arrayList.add(LatLon.greatCircleEndPosition(this.center, d2, this.semiMajorAxisLength / d));
        arrayList.add(LatLon.greatCircleEndPosition(this.center, d2, -this.semiMajorAxisLength / d));
        Vec4 vec4 = globe.computePointFromPosition(((LatLon)arrayList.get(0)).getLatitude(), ((LatLon)arrayList.get(0)).getLongitude(), 0.0);
        this.uHat = vec4.subtract3(this.Cxyz).normalize3();
        d2 = this.orientation.radians;
        arrayList.add(LatLon.greatCircleEndPosition(this.center, d2, this.semiMinorAxisLength / d));
        arrayList.add(LatLon.greatCircleEndPosition(this.center, d2, -this.semiMinorAxisLength / d));
        Vec4 vec42 = globe.computePointFromPosition(((LatLon)arrayList.get(2)).getLatitude(), ((LatLon)arrayList.get(2)).getLongitude(), 0.0);
        this.vHat = vec42.subtract3(this.Cxyz).normalize3();
        this.bounds = Sector.boundingSector(arrayList);
    }

    protected void invalidateCache() {
        MemoryCache memoryCache = WorldWind.getMemoryCache(CONFORMINGSHAPE_CACHE_KEY);
        memoryCache.remove(new ConformingShape.CacheKey(this.getClass(), null, this.serialNumber));
        this.Cxyz = null;
        this.uHat = null;
        this.vHat = null;
        this.areaMeasurer = null;
    }

    public void moveTo(Position position) {
        this.invalidateCache();
        this.center = new LatLon(position.getLatitude(), position.getLongitude());
    }

    protected boolean renderInterior(DrawContext drawContext, GL gL) {
        boolean bl = false;
        if (this.drawInterior || this.drawBorder) {
            Globe globe = drawContext.getGlobe();
            if (this.Cxyz == null) {
                this.makeEllipticalReferenceFrame(globe);
            }
            float[] fArray = new float[4];
            MemoryCache memoryCache = WorldWind.getMemoryCache(CONFORMINGSHAPE_CACHE_KEY);
            ConformingShape.CacheKey cacheKey = new ConformingShape.CacheKey(this.getClass(), null, this.serialNumber);
            CachedShapeDescription cachedShapeDescription = (CachedShapeDescription)memoryCache.getObject(cacheKey);
            ArrayList<SectorGeometry.ExtractedShapeDescription> arrayList = null;
            if (cachedShapeDescription != null) {
                arrayList = cachedShapeDescription.esdL;
            }
            if (arrayList == null || this.isExpired(drawContext)) {
                if (arrayList != null) {
                    memoryCache.remove(cacheKey);
                    arrayList = null;
                }
                for (SectorGeometry object : drawContext.getSurfaceGeometry()) {
                    Object object2;
                    if (!object.getSector().intersects(this.bounds) || (object2 = object.getIntersectingTessellationPieces(this.Cxyz, this.uHat, this.vHat, this.semiMajorAxisLength, this.semiMinorAxisLength)) == null) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList(4);
                    }
                    arrayList.add((SectorGeometry.ExtractedShapeDescription)object2);
                    bl = true;
                }
                if (arrayList != null) {
                    memoryCache.add(cacheKey, new CachedShapeDescription(arrayList), ConformingEllipse.sizeInBytesOf(arrayList));
                }
            }
            if (this.drawInterior && arrayList != null) {
                for (SectorGeometry.ExtractedShapeDescription extractedShapeDescription : arrayList) {
                    for (Vec4[] vec4Array : extractedShapeDescription.interiorPolys) {
                        if (!drawContext.isPickingMode()) {
                            gL.glColor4fv(this.fillColor.getComponents(fArray), 0);
                        }
                        gL.glBegin(9);
                        for (Vec4 vec4 : vec4Array) {
                            gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
                        }
                        gL.glEnd();
                    }
                }
            }
        }
        this.updateExpiryCriteria(drawContext);
        return bl;
    }

    protected void renderBoundary(DrawContext drawContext, GL gL, boolean bl) {
        if (this.drawBorder) {
            MemoryCache memoryCache = WorldWind.getMemoryCache(CONFORMINGSHAPE_CACHE_KEY);
            ConformingShape.CacheKey cacheKey = new ConformingShape.CacheKey(this.getClass(), null, this.serialNumber);
            CachedShapeDescription cachedShapeDescription = (CachedShapeDescription)memoryCache.getObject(cacheKey);
            ArrayList<SectorGeometry.ExtractedShapeDescription> arrayList = null;
            if (cachedShapeDescription != null) {
                arrayList = cachedShapeDescription.esdL;
            }
            if (arrayList != null) {
                float[] fArray = new float[4];
                if (!drawContext.isPickingMode()) {
                    gL.glColor4fv(this.borderColor.getComponents(fArray), 0);
                }
                gL.glBegin(1);
                for (SectorGeometry.ExtractedShapeDescription extractedShapeDescription : arrayList) {
                    for (SectorGeometry.BoundaryEdge boundaryEdge : extractedShapeDescription.shapeOutline) {
                        gL.glVertex3d(boundaryEdge.vertices[boundaryEdge.i1].x, boundaryEdge.vertices[boundaryEdge.i1].y, boundaryEdge.vertices[boundaryEdge.i1].z);
                        gL.glVertex3d(boundaryEdge.vertices[boundaryEdge.i2].x, boundaryEdge.vertices[boundaryEdge.i2].y, boundaryEdge.vertices[boundaryEdge.i2].z);
                    }
                }
                gL.glEnd();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedShapeDescription {
        ArrayList<SectorGeometry.ExtractedShapeDescription> esdL;

        CachedShapeDescription(ArrayList<SectorGeometry.ExtractedShapeDescription> arrayList) {
            this.esdL = arrayList;
        }
    }
}

