/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeographicTextRenderer
implements Disposable {
    private Map<Font, TextRenderer> textRenderers = new HashMap<Font, TextRenderer>();
    private TextRenderer lastTextRenderer = null;
    private final GLU glu = new GLU();
    private static final Font DEFAULT_FONT = Font.decode("Arial-PLAIN-12");
    private static final Color DEFAULT_COLOR = Color.white;
    private boolean cullText = false;
    private boolean hasJOGLv111Bug = false;
    private final int[] viewportArray = new int[4];

    public boolean isCullTextEnabled() {
        return this.cullText;
    }

    public void setCullTextEnabled(boolean bl) {
        this.cullText = bl;
    }

    @Override
    public void dispose() {
        if (GLContext.getCurrent() == null) {
            return;
        }
        for (TextRenderer textRenderer : this.textRenderers.values()) {
            if (textRenderer == null) continue;
            textRenderer.dispose();
        }
        this.textRenderers.clear();
    }

    public void render(DrawContext drawContext, Iterable<GeographicText> iterable) {
        this.drawMany(drawContext, iterable);
    }

    public void render(DrawContext drawContext, GeographicText geographicText, Vec4 vec4) {
        if (!GeographicTextRenderer.isTextValid(geographicText, false)) {
            return;
        }
        this.drawOne(drawContext, geographicText, vec4);
    }

    private void drawMany(DrawContext drawContext, Iterable<GeographicText> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        Iterator<GeographicText> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Frustum frustum = drawContext.getView().getFrustumInModelCoordinates();
        double d = drawContext.getView().computeHorizonDistance();
        while (iterator.hasNext()) {
            double d2;
            Vec4 vec4;
            GeographicText geographicText = iterator.next();
            if (!GeographicTextRenderer.isTextValid(geographicText, true) || !geographicText.isVisible()) continue;
            Angle angle = geographicText.getPosition().getLatitude();
            Angle angle2 = geographicText.getPosition().getLongitude();
            if (!drawContext.getVisibleSector().contains(angle, angle2) || (vec4 = sectorGeometryList.getSurfacePoint(angle, angle2, geographicText.getPosition().getElevation())) == null || (d2 = drawContext.getView().getEyePoint().distanceTo3(vec4)) > d || !frustum.contains(vec4)) continue;
            drawContext.addOrderedRenderable(new OrderedText(geographicText, vec4, d2));
        }
    }

    private void drawOne(DrawContext drawContext, GeographicText geographicText, Vec4 vec4) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getView() == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (!geographicText.isVisible()) {
            return;
        }
        if (vec4 == null) {
            if (geographicText.getPosition() == null) {
                return;
            }
            Angle angle = geographicText.getPosition().getLatitude();
            Angle angle2 = geographicText.getPosition().getLongitude();
            if (!drawContext.getVisibleSector().contains(angle, angle2)) {
                return;
            }
            vec4 = sectorGeometryList.getSurfacePoint(angle, angle2, geographicText.getPosition().getElevation());
            if (vec4 == null) {
                return;
            }
        }
        double d = drawContext.getView().computeHorizonDistance();
        double d2 = drawContext.getView().getEyePoint().distanceTo3(vec4);
        if (d2 > d) {
            return;
        }
        if (!drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) {
            return;
        }
        drawContext.addOrderedRenderable(new OrderedText(geographicText, vec4, d2));
    }

    private static boolean isTextValid(GeographicText geographicText, boolean bl) {
        if (geographicText == null || geographicText.getText() == null) {
            return false;
        }
        return !bl || geographicText.getPosition() != null;
    }

    private Rectangle2D computeTextBounds(DrawContext drawContext, OrderedText orderedText) throws Exception {
        GeographicText geographicText = orderedText.text;
        CharSequence charSequence = geographicText.getText();
        if (charSequence == null) {
            return null;
        }
        Vec4 vec4 = drawContext.getView().project(orderedText.point);
        if (vec4 == null) {
            return null;
        }
        Font font = geographicText.getFont();
        if (font == null) {
            font = DEFAULT_FONT;
        }
        try {
            TextRenderer textRenderer = this.textRenderers.get(font);
            if (textRenderer == null) {
                textRenderer = this.initializeTextRenderer(font);
            }
            if (textRenderer != this.lastTextRenderer) {
                if (this.lastTextRenderer != null) {
                    this.lastTextRenderer.end3DRendering();
                }
                textRenderer.begin3DRendering();
                this.lastTextRenderer = textRenderer;
            }
            this.setDepthFunc(drawContext, orderedText, vec4);
            Rectangle2D rectangle2D = textRenderer.getBounds(charSequence);
            float f = (float)(vec4.x - rectangle2D.getWidth() / 2.0);
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            ((Rectangle2D)float_).setRect(f, (float)vec4.y, rectangle2D.getWidth(), (float)rectangle2D.getHeight());
            return float_;
        }
        catch (Exception exception) {
            this.handleTextRendererExceptions(exception);
            return null;
        }
    }

    private void beginRendering(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        int n = 30977;
        gL.glPushAttrib(n);
        gL.glGetIntegerv(2978, this.viewportArray, 0);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        this.glu.gluOrtho2D(0.0, this.viewportArray[2], 0.0, this.viewportArray[3]);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMatrixMode(5890);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glEnable(2929);
        gL.glDepthMask(false);
        gL.glDisable(2884);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.001f);
    }

    private void endRendering(DrawContext drawContext) {
        if (this.lastTextRenderer != null) {
            this.lastTextRenderer.end3DRendering();
            this.lastTextRenderer = null;
        }
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    private Vec4 drawText(DrawContext drawContext, OrderedText orderedText) throws Exception {
        if (orderedText.point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().fine(string);
            return null;
        }
        GeographicText geographicText = orderedText.text;
        CharSequence charSequence = geographicText.getText();
        if (charSequence == null) {
            return null;
        }
        Vec4 vec4 = drawContext.getView().project(orderedText.point);
        if (vec4 == null) {
            return null;
        }
        Font font = geographicText.getFont();
        if (font == null) {
            font = DEFAULT_FONT;
        }
        try {
            TextRenderer textRenderer = this.textRenderers.get(font);
            if (textRenderer == null) {
                textRenderer = this.initializeTextRenderer(font);
            }
            if (textRenderer != this.lastTextRenderer) {
                if (this.lastTextRenderer != null) {
                    this.lastTextRenderer.end3DRendering();
                }
                textRenderer.begin3DRendering();
                this.lastTextRenderer = textRenderer;
            }
            this.setDepthFunc(drawContext, orderedText, vec4);
            Rectangle2D rectangle2D = textRenderer.getBounds(charSequence);
            Point2D.Float float_ = this.computeDrawPoint(drawContext, rectangle2D, vec4);
            if (float_ != null) {
                Color color;
                Color color2 = geographicText.getColor();
                if (color2 == null) {
                    color2 = DEFAULT_COLOR;
                }
                if ((color = geographicText.getBackgroundColor()) != null) {
                    textRenderer.setColor(color);
                    textRenderer.draw3D(charSequence, float_.x + 1.0f, float_.y - 1.0f, 0.0f, 1.0f);
                }
                textRenderer.setColor(color2);
                textRenderer.draw3D(charSequence, float_.x, float_.y, 0.0f, 1.0f);
                textRenderer.flush();
            }
        }
        catch (Exception exception) {
            this.handleTextRendererExceptions(exception);
        }
        return vec4;
    }

    protected void handleTextRendererExceptions(Exception exception) throws Exception {
        if (exception instanceof IOException) {
            if (!this.hasJOGLv111Bug) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingText", exception);
                this.hasJOGLv111Bug = true;
            }
        } else {
            throw exception;
        }
    }

    protected Point2D.Float computeDrawPoint(DrawContext drawContext, Rectangle2D rectangle2D, Vec4 vec4) {
        return new Point2D.Float((float)(vec4.x - rectangle2D.getWidth() / 2.0), (float)vec4.y);
    }

    private void setDepthFunc(DrawContext drawContext, OrderedText orderedText, Vec4 vec4) {
        GL gL = drawContext.getGL();
        Position position = drawContext.getView().getEyePosition();
        if (position == null) {
            gL.glDepthFunc(519);
            return;
        }
        double d = position.getElevation();
        if (d < drawContext.getGlobe().getMaxElevation() * drawContext.getVerticalExaggeration()) {
            double d2 = vec4.z - 0.00391006472;
            d2 = d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
            gL.glDepthFunc(513);
            gL.glDepthRange(d2, d2);
        } else {
            gL.glDepthFunc(519);
        }
    }

    private TextRenderer initializeTextRenderer(Font font) {
        TextRenderer textRenderer = new TextRenderer(font, true, true);
        textRenderer.setUseVertexArrays(false);
        TextRenderer textRenderer2 = this.textRenderers.put(font, textRenderer);
        if (textRenderer2 != null) {
            textRenderer2.dispose();
        }
        return textRenderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OrderedText
    implements OrderedRenderable,
    Comparable<OrderedText> {
        GeographicText text;
        Vec4 point;
        double eyeDistance;

        OrderedText(GeographicText geographicText, Vec4 vec4, double d) {
            this.text = geographicText;
            this.point = vec4;
            this.eyeDistance = d;
        }

        @Override
        public int compareTo(OrderedText orderedText) {
            if (orderedText.text.getPriority() - this.text.getPriority() == 0.0) {
                return (int)(this.eyeDistance - orderedText.eyeDistance);
            }
            return (int)(orderedText.text.getPriority() - this.text.getPriority());
        }

        @Override
        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        private GeographicTextRenderer getRenderer() {
            return GeographicTextRenderer.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void render(DrawContext drawContext) {
            GeographicTextRenderer.this.beginRendering(drawContext);
            try {
                Object object;
                if (GeographicTextRenderer.this.cullText) {
                    Object object2;
                    object = new ArrayList<OrderedText>();
                    ((ArrayList)object).add(this);
                    OrderedRenderable orderedRenderable = drawContext.getOrderedRenderables().peek();
                    while (orderedRenderable != null && orderedRenderable instanceof OrderedText) {
                        object2 = (OrderedText)orderedRenderable;
                        if (super.getRenderer() != GeographicTextRenderer.this) {
                            return;
                        }
                        ((ArrayList)object).add(object2);
                        drawContext.getOrderedRenderables().poll();
                        orderedRenderable = drawContext.getOrderedRenderables().peek();
                    }
                    Collections.sort(object);
                    object2 = new ArrayList();
                    Iterator iterator = ((ArrayList)object).iterator();
                    while (iterator.hasNext()) {
                        OrderedText orderedText = (OrderedText)iterator.next();
                        Rectangle2D rectangle2D = GeographicTextRenderer.this.computeTextBounds(drawContext, orderedText);
                        if (rectangle2D == null) continue;
                        boolean bl = false;
                        Iterator iterator2 = ((ArrayList)object2).iterator();
                        while (iterator2.hasNext()) {
                            Rectangle2D rectangle2D2 = (Rectangle2D)iterator2.next();
                            if (!rectangle2D2.intersects(rectangle2D)) continue;
                            bl = true;
                        }
                        if (bl) continue;
                        ((ArrayList)object2).add(rectangle2D);
                        GeographicTextRenderer.this.drawText(drawContext, orderedText);
                    }
                } else {
                    GeographicTextRenderer.this.drawText(drawContext, this);
                    object = drawContext.getOrderedRenderables().peek();
                    while (object != null && object instanceof OrderedText) {
                        OrderedText orderedText = (OrderedText)object;
                        if (orderedText.getRenderer() != GeographicTextRenderer.this) {
                            return;
                        }
                        GeographicTextRenderer.this.drawText(drawContext, orderedText);
                        drawContext.getOrderedRenderables().poll();
                        object = drawContext.getOrderedRenderables().peek();
                    }
                }
            }
            catch (WWRuntimeException wWRuntimeException) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingText", wWRuntimeException);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingText", exception);
            }
            finally {
                GeographicTextRenderer.this.endRendering(drawContext);
            }
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
        }
    }
}

