/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class PatternFactory {
    public static final String PATTERN_CIRCLE = "PatternFactory.PatternCircle";
    public static final String PATTERN_CIRCLES = "PatternFactory.PatternCircles";
    public static final String PATTERN_SQUARE = "PatternFactory.PatternSquare";
    public static final String PATTERN_SQUARES = "PatternFactory.PatternSquares";
    public static final String PATTERN_TRIANGLE_UP = "PatternFactory.PatternTriangleUp";
    public static final String PATTERN_HLINE = "PatternFactory.PatternHLine";
    public static final String PATTERN_VLINE = "PatternFactory.PatternVLine";
    public static final String PATTERN_HVLINE = "PatternFactory.PatternHVLine";
    public static final String PATTERN_DIAGONAL_UP = "PatternFactory.PatternDiagonalUp";
    public static final String PATTERN_DIAGONAL_DOWN = "PatternFactory.PatternDiagonalDown";
    public static final String GRADIENT_HLINEAR = "PatternFactory.GradientHLinear";
    public static final String GRADIENT_VLINEAR = "PatternFactory.GradientVLinear";
    private static Dimension defaultDimension = new Dimension(32, 32);
    private static float defaultScale = 0.5f;
    private static Color defaultLineColor = Color.LIGHT_GRAY;
    private static Color defaultBackColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);

    public static BufferedImage createPattern(String string) {
        return PatternFactory.createPattern(string, defaultDimension, defaultScale, defaultLineColor, defaultBackColor);
    }

    public static BufferedImage createPattern(String string, Color color) {
        return PatternFactory.createPattern(string, defaultDimension, defaultScale, color, defaultBackColor);
    }

    public static BufferedImage createPattern(String string, float f) {
        return PatternFactory.createPattern(string, defaultDimension, f, defaultLineColor, defaultBackColor);
    }

    public static BufferedImage createPattern(String string, float f, Color color) {
        return PatternFactory.createPattern(string, defaultDimension, f, color, defaultBackColor);
    }

    public static BufferedImage createPattern(String string, float f, Color color, Color color2) {
        return PatternFactory.createPattern(string, defaultDimension, f, color, color2);
    }

    public static BufferedImage createPattern(String string, Dimension dimension, float f, Color color) {
        return PatternFactory.createPattern(string, dimension, f, color, defaultBackColor);
    }

    public static BufferedImage createPattern(String string, Dimension dimension, float f, Color color, Color color2) {
        int n;
        int n2 = dimension.width / 2;
        int n3 = dimension.height / 2;
        int n4 = (int)((float)dimension.width * f);
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(color2);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        if (f <= 0.0f) {
            return bufferedImage;
        }
        graphics2D.setPaint(color);
        graphics2D.setStroke(new BasicStroke(n4));
        if (string.equals(PATTERN_HLINE)) {
            n = n3 - 1 - n4 / 2;
            graphics2D.fillRect(0, n, dimension.width, n4);
        } else if (string.equals(PATTERN_VLINE)) {
            n = n2 - 1 - n4 / 2;
            graphics2D.fillRect(n, 0, n4, dimension.height);
        }
        if (string.equals(PATTERN_HVLINE)) {
            n = n2 - 1 - n4 / 2;
            graphics2D.fillRect(n, 0, n4, dimension.height);
            int n5 = n3 - 1 - n4 / 2;
            graphics2D.fillRect(0, n5, dimension.width, n4);
        } else if (string.equals(PATTERN_SQUARE)) {
            n = n2 - 1 - n4 / 2;
            int n6 = n3 - 1 - n4 / 2;
            graphics2D.fillRect(n, n6, n4, n4);
        } else if (string.equals(PATTERN_SQUARES)) {
            n = n2 - 1 - n4 / 2;
            int n7 = n3 - 1 - n4 / 2;
            graphics2D.fillRect(n, n7, n4, n4);
            graphics2D.fillRect(n - n2, n7 - n3, n4, n4);
            graphics2D.fillRect(n - n2, n7 + n3, n4, n4);
            graphics2D.fillRect(n + n2, n7 - n3, n4, n4);
            graphics2D.fillRect(n + n2, n7 + n3, n4, n4);
        } else if (string.equals(PATTERN_CIRCLE)) {
            n = n2 - 1 - n4 / 2;
            int n8 = n3 - 1 - n4 / 2;
            graphics2D.fillOval(n, n8, n4, n4);
        } else if (string.equals(PATTERN_CIRCLES)) {
            n = n2 - 1 - n4 / 2;
            int n9 = n3 - 1 - n4 / 2;
            graphics2D.fillOval(n, n9, n4, n4);
            graphics2D.fillOval(n - n2, n9 - n3, n4, n4);
            graphics2D.fillOval(n - n2, n9 + n3, n4, n4);
            graphics2D.fillOval(n + n2, n9 - n3, n4, n4);
            graphics2D.fillOval(n + n2, n9 + n3, n4, n4);
        } else if (string.equals(PATTERN_TRIANGLE_UP)) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n2 - 1 - n4 / 2, n3 - 1 + n4 / 2);
            generalPath.lineTo(n2 - 1, n3 - 1 - n4 / 2);
            generalPath.lineTo(n2 - 1 + n4 / 2, n3 - 1 + n4 / 2);
            generalPath.lineTo(n2 - 1 - n4 / 2, n3 - 1 + n4 / 2);
            graphics2D.fill(generalPath);
        } else if (string.equals(PATTERN_DIAGONAL_UP) || string.equals(PATTERN_DIAGONAL_DOWN)) {
            if (string.equals(PATTERN_DIAGONAL_DOWN)) {
                AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
                affineTransform.translate(-dimension.width, 0.0);
                graphics2D.setTransform(affineTransform);
            }
            graphics2D.drawLine(-n4, dimension.height - 1 + n4, dimension.width - 1 + n4, -n4);
            graphics2D.drawLine(-n4 - 1, n4, n4 - 1, -n4);
            graphics2D.drawLine(dimension.width - n4, dimension.height - 1 + n4, dimension.width + n4, dimension.height - 1 - n4);
        } else if (string.equals(GRADIENT_VLINEAR)) {
            graphics2D.setPaint(new GradientPaint(n2, 0.0f, color, n2, (float)dimension.height - 1.0f, color2));
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        } else if (string.equals(GRADIENT_HLINEAR)) {
            graphics2D.setPaint(new GradientPaint(0.0f, n3, color, (float)dimension.width - 1.0f, n3, color2));
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        }
        return bufferedImage;
    }

    public static BufferedImage blur(BufferedImage bufferedImage) {
        return PatternFactory.blur(bufferedImage, 3);
    }

    public static BufferedImage blur(BufferedImage bufferedImage, int n) {
        int n2 = n * n;
        float f = 1.0f / (float)n2;
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray[i] = f;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 6);
        ConvolveOp convolveOp = new ConvolveOp(new Kernel(n, n, fArray));
        convolveOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

