/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.pick.Pickable;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ContourLine;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.TiledSurfaceObjectRenderer;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceContourLine
extends ContourLine
implements PreRenderable,
Pickable {
    protected List<SurfaceShape> surfaceShapes = new ArrayList<SurfaceShape>();
    protected TiledSurfaceObjectRenderer renderer = new TiledSurfaceObjectRenderer();
    protected ShapeAttributes attributes = new BasicShapeAttributes();

    public SurfaceContourLine() {
        this.attributes.setDrawInterior(false);
        this.attributes.setOutlineMaterial(new Material(this.getColor()));
        this.attributes.setOutlineWidth(this.getLineWidth());
    }

    public ShapeAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ShapeAttributes shapeAttributes) {
        this.attributes = shapeAttributes;
    }

    public List<SurfaceShape> getSurfaceShapes(DrawContext drawContext) {
        return this.isValid(drawContext) ? this.surfaceShapes : null;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (this.isValid(drawContext)) {
            this.renderer.setSurfaceObjects(this.surfaceShapes);
            this.renderer.preRender(drawContext);
        }
    }

    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (this.isValid(drawContext)) {
            this.renderer.pick(drawContext, point, null);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (this.isValid(drawContext)) {
            this.renderer.render(drawContext);
        }
    }

    protected boolean isValid(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.getSector().intersects(drawContext.getVisibleSector())) {
            return false;
        }
        if (this.isExpired(drawContext)) {
            this.makeContourLine(drawContext);
            this.updateExpiryCriteria(drawContext);
        }
        return this.surfaceShapes.size() > 0;
    }

    @Override
    protected void makeContourLine(DrawContext drawContext) {
        super.makeContourLine(drawContext);
        this.surfaceShapes.clear();
        for (Renderable renderable : this.getRenderables()) {
            if (!(renderable instanceof Polyline)) continue;
            this.surfaceShapes.add(new SurfacePolyline(this.attributes, ((Polyline)renderable).getPositions()));
        }
    }
}

