/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.pick.Pickable;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceContourLine;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.TiledSurfaceObjectRenderer;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class SurfaceContourLineSet
implements PreRenderable,
Pickable,
Renderable {
    private Sector sector;
    private List<SurfaceContourLine> lines = new ArrayList<SurfaceContourLine>();
    private ShapeAttributes defaultAttributes = new BasicShapeAttributes();
    protected List<SurfaceShape> surfaceShapes = new ArrayList<SurfaceShape>();
    protected TiledSurfaceObjectRenderer renderer = new TiledSurfaceObjectRenderer();
    private boolean enabled = true;

    public SurfaceContourLineSet(double[] dArray, Sector sector) {
        this.sector = sector;
        this.defaultAttributes.setDrawInterior(false);
        this.defaultAttributes.setOutlineMaterial(Material.CYAN);
        for (double d : dArray) {
            SurfaceContourLine surfaceContourLine = new SurfaceContourLine();
            surfaceContourLine.setAttributes(this.getAttributes(d));
            surfaceContourLine.setElevation(d);
            surfaceContourLine.setSector(sector);
            this.lines.add(surfaceContourLine);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    protected ShapeAttributes getAttributes(double d) {
        return this.defaultAttributes;
    }

    public void preRender(DrawContext drawContext) {
        if (this.isValid(drawContext)) {
            this.assembleShapes(drawContext);
            if (this.surfaceShapes.size() > 0) {
                this.renderer.setSurfaceObjects(this.surfaceShapes);
                this.renderer.preRender(drawContext);
            }
        }
    }

    public void pick(DrawContext drawContext, Point point) {
        if (this.isValid(drawContext) && this.surfaceShapes.size() > 0) {
            this.renderer.pick(drawContext, point, null);
        }
    }

    public void render(DrawContext drawContext) {
        if (this.isValid(drawContext) && this.surfaceShapes.size() > 0) {
            this.renderer.render(drawContext);
        }
    }

    protected boolean isValid(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isEnabled()) {
            return false;
        }
        return this.sector.intersects(drawContext.getVisibleSector());
    }

    protected void assembleShapes(DrawContext drawContext) {
        this.surfaceShapes.clear();
        for (SurfaceContourLine surfaceContourLine : this.lines) {
            List<SurfaceShape> list = surfaceContourLine.getSurfaceShapes(drawContext);
            if (list == null) continue;
            this.surfaceShapes.addAll(list);
        }
    }
}

