/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceShapeSupport;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.List;

public abstract class SurfaceConvexShape
extends AbstractSurfaceShape {
    protected SurfaceConvexShape(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    protected SurfaceConvexShape() {
    }

    protected void doRenderToRegion(DrawContext drawContext, Sector sector, int n, int n2, int n3, int n4) {
        ShapeAttributes shapeAttributes;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.isShowBoundingSectors()) {
            this.drawBoundingSectors(drawContext, sector, n, n2, n3, n4);
        }
        if (!((shapeAttributes = this.getAttributes()).isDrawInterior() && shapeAttributes.getInteriorOpacity() > 0.0 || shapeAttributes.isDrawOutline() && shapeAttributes.getOutlineOpacity() > 0.0)) {
            return;
        }
        List<? extends LatLon> list = this.getDrawLocations(drawContext, sector, n, n2, n3, n4);
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        SurfaceShapeSupport surfaceShapeSupport = SurfaceConvexShape.getSurfaceShapeSupport();
        surfaceShapeSupport.assembleShapeVertices(sector, n, n2, n3, n4, list, arrayList);
        Vec4 vec4 = surfaceShapeSupport.computeCenterVertex(arrayList);
        arrayList.add(0, vec4);
        surfaceShapeSupport.beginRendering(drawContext);
        surfaceShapeSupport.bindVertexData(drawContext, 2, arrayList);
        if (shapeAttributes.isDrawInterior() && shapeAttributes.getInteriorOpacity() > 0.0) {
            surfaceShapeSupport.applyInteriorState(drawContext, shapeAttributes);
            surfaceShapeSupport.drawArrays(drawContext, 6, 0, arrayList.size());
        }
        if (shapeAttributes.isDrawOutline() && shapeAttributes.getOutlineOpacity() > 0.0) {
            surfaceShapeSupport.applyOutlineState(drawContext, shapeAttributes);
            surfaceShapeSupport.drawArrays(drawContext, 2, 1, arrayList.size() - 1);
        }
        surfaceShapeSupport.endRendering(drawContext);
    }
}

