/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.texture.TextureCoords;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceRenderable;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceIcon
extends AbstractSurfaceRenderable
implements Movable {
    private Object imageSource;
    private LatLon location;
    private Vec4 locationOffset;
    private double scale = 1.0;
    private Angle heading;
    private Color color = Color.WHITE;
    private double maxSize = Double.MAX_VALUE;
    private double minSize = 0.1;
    protected WWTexture texture;
    protected int imageWidth = 32;
    protected int imageHeight = 32;

    public SurfaceIcon(Object object, LatLon latLon) {
        this.setImageSource(object);
        this.setLocation(latLon);
    }

    public LatLon getLocation() {
        return this.location;
    }

    public void setLocation(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.location = latLon;
    }

    public Vec4 getLocationOffset() {
        return this.locationOffset;
    }

    public void setLocationOffset(Vec4 vec4) {
        this.locationOffset = vec4;
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public void setImageSource(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ImageSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageSource = object;
        this.texture = null;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        this.heading = angle;
    }

    public double getMinSize() {
        return this.minSize;
    }

    public void setMinSize(double d) {
        this.minSize = d;
    }

    public double getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(double d) {
        this.maxSize = d;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    @Override
    public long getLastModifiedTime() {
        return System.currentTimeMillis();
    }

    @Override
    public Iterable<? extends Sector> getSectors(DrawContext drawContext) {
        return Arrays.asList(this.computeSector(drawContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRenderToRegion(DrawContext drawContext, Sector sector, int n, int n2, int n3, int n4) {
        this.beginDraw(drawContext);
        try {
            this.applyDrawTransform(drawContext, sector, n, n2, n3, n4);
            this.applyDrawColor(drawContext);
            this.drawIcon(drawContext);
        }
        finally {
            this.endDraw(drawContext);
        }
    }

    protected Sector computeSector(DrawContext drawContext) {
        Globe globe = drawContext.getGlobe();
        Rectangle2D.Double double_ = this.computeDrawDimension(drawContext);
        double d = double_.height / globe.getRadius();
        double d2 = double_.width / globe.getRadius() / this.location.getLatitude().cos();
        double d3 = this.locationOffset != null ? this.locationOffset.y * d / (double)this.imageHeight : 0.0;
        double d4 = this.locationOffset != null ? this.locationOffset.x * d2 / (double)this.imageWidth : 0.0;
        Sector sector = new Sector(this.location.getLatitude().subtractRadians(d / 2.0).addRadians(d3), this.location.getLatitude().addRadians(d / 2.0).addRadians(d3), this.location.getLongitude().subtractRadians(d2 / 2.0).addRadians(d4), this.location.getLongitude().addRadians(d2 / 2.0).addRadians(d4));
        return this.computeRotatedSectorBounds(sector, this.location, this.computeDrawHeading(drawContext));
    }

    protected Rectangle2D.Double computeDrawDimension(DrawContext drawContext) {
        double d;
        double d2;
        double d3 = this.computePixelSizeAtLocation(drawContext, this.location);
        double d4 = (double)this.imageHeight * this.scale * d3;
        double d5 = d2 = d4 > (d = (double)this.imageWidth * this.scale * d3) ? d4 : d;
        double d6 = d2 > this.maxSize ? this.maxSize / d2 : (d2 < this.minSize ? this.minSize / d2 : 1.0);
        return new Rectangle2D.Double(0.0, 0.0, d * d6, d4 * d6);
    }

    protected Angle computeDrawHeading(DrawContext drawContext) {
        if (this.heading != null) {
            return this.heading;
        }
        return this.getViewHeading(drawContext);
    }

    protected void beginDraw(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        int n = 290817;
        gL.glPushAttrib(n);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.001f);
        gL.glMatrixMode(5890);
        gL.glPushMatrix();
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        if (drawContext.isPickingMode()) {
            this.pickSupport.beginPicking(drawContext);
            gL.glEnable(3553);
            gL.glTexEnvf(8960, 8704, 34160.0f);
            gL.glTexEnvf(8960, 34176, 34168.0f);
            gL.glTexEnvf(8960, 34161, 7681.0f);
        } else {
            gL.glEnable(3553);
            gL.glEnable(3042);
            gL.glBlendFunc(1, 771);
            gL.glTexEnvf(8960, 8704, 8448.0f);
        }
    }

    protected void endDraw(DrawContext drawContext) {
        if (drawContext.isPickingMode()) {
            this.pickSupport.endPicking(drawContext);
        }
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    protected void applyDrawTransform(DrawContext drawContext, Sector sector, int n, int n2, int n3, int n4) {
        Vec4 vec4 = this.computeDrawPoint(this.location, sector, n, n2, n3, n4);
        double d = this.computeDrawPixelSize(drawContext, sector, n3, n4);
        double d2 = this.computeDrawDimension((DrawContext)drawContext).width / (double)this.imageWidth;
        double d3 = d2 / d;
        GL gL = drawContext.getGL();
        gL.glTranslated(vec4.x(), vec4.y(), vec4.z());
        gL.glScaled(d3 / this.location.getLatitude().cos(), d3, 1.0);
        gL.glRotated(this.computeDrawHeading((DrawContext)drawContext).degrees, 0.0, 0.0, -1.0);
        gL.glTranslated(-this.imageWidth / 2, -this.imageHeight / 2, 0.0);
        if (this.locationOffset != null) {
            gL.glTranslated(this.locationOffset.x, this.locationOffset.y, 0.0);
        }
    }

    protected void applyDrawColor(DrawContext drawContext) {
        if (!drawContext.isPickingMode()) {
            this.applyPremultipliedAlphaColor(drawContext.getGL(), this.color, this.getOpacity());
        }
    }

    protected void drawIcon(DrawContext drawContext) {
        WWTexture wWTexture = this.getTexture();
        if (wWTexture == null) {
            return;
        }
        wWTexture.bind(drawContext);
        this.imageWidth = wWTexture.getWidth();
        this.imageHeight = wWTexture.getHeight();
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5890);
        wWTexture.applyInternalTransform(drawContext);
        gL.glMatrixMode(5888);
        gL.glScaled(this.imageWidth, this.imageHeight, 1.0);
        drawContext.drawUnitQuad(new TextureCoords(0.0f, 0.0f, 1.0f, 1.0f));
    }

    protected WWTexture getTexture() {
        if (this.texture == null) {
            this.texture = new BasicWWTexture(this.imageSource);
        }
        return this.texture;
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.location, 0.0);
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.moveTo(this.getReferencePosition().add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setLocation(position.getLatLon());
    }
}

