/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.DragSelectEvent;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class SurfaceImageEditor
implements SelectListener {
    protected static final int NONE = 0;
    protected static final int MOVING = 1;
    protected static final int SIZING = 2;
    protected final WorldWindow wwd;
    protected SurfaceImage shape;
    protected MarkerLayer controlPointLayer;
    protected boolean armed;
    protected boolean active;
    protected int activeOperation = 0;
    protected Position previousPosition = null;

    public SurfaceImageEditor(WorldWindow worldWindow, SurfaceImage surfaceImage) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (surfaceImage == null) {
            String string = Logging.getMessage("nullValue.Shape");
            Logging.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.shape = surfaceImage;
        this.controlPointLayer = new MarkerLayer();
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public SurfaceImage getSurfaceImage() {
        return this.shape;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean bl) {
        if (!this.armed && bl) {
            this.enable();
        } else if (this.armed && !bl) {
            this.disable();
        }
        this.armed = bl;
    }

    protected void enable() {
        LayerList layerList = this.wwd.getModel().getLayers();
        if (!layerList.contains(this.controlPointLayer)) {
            layerList.add(this.controlPointLayer);
        }
        if (!this.controlPointLayer.isEnabled()) {
            this.controlPointLayer.setEnabled(true);
        }
        this.updateAffordances();
        this.wwd.addSelectListener(this);
    }

    protected void disable() {
        LayerList layerList = this.wwd.getModel().getLayers();
        layerList.remove(this.controlPointLayer);
        this.wwd.removeSelectListener(this);
    }

    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (selectEvent.getTopObject() != null && selectEvent.getTopObject() != this.shape && selectEvent.getTopPickedObject().getParentLayer() != this.controlPointLayer) {
            ((Component)((Object)this.wwd)).setCursor(null);
            return;
        }
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            this.active = false;
            this.activeOperation = 0;
            this.previousPosition = null;
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
            if (!(this.wwd instanceof Component)) {
                return;
            }
            if (selectEvent.getTopObject() == null || selectEvent.getTopPickedObject().isTerrain()) {
                ((Component)((Object)this.wwd)).setCursor(null);
                return;
            }
            Cursor cursor = selectEvent.getTopObject() instanceof SurfaceImage ? Cursor.getPredefinedCursor(12) : (selectEvent.getTopObject() instanceof Marker ? Cursor.getPredefinedCursor(1) : null);
            ((Component)((Object)this.wwd)).setCursor(cursor);
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftPress")) {
            this.active = true;
            this.previousPosition = this.wwd.getCurrentPosition();
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
            if (!this.active) {
                return;
            }
            DragSelectEvent dragSelectEvent = (DragSelectEvent)selectEvent;
            Object object = dragSelectEvent.getTopObject();
            if (object == null) {
                return;
            }
            if (object == this.shape || this.activeOperation == 1) {
                this.activeOperation = 1;
                this.dragWholeShape(dragSelectEvent, object);
                this.updateAffordances();
            } else if (dragSelectEvent.getTopPickedObject().getParentLayer() == this.controlPointLayer || this.activeOperation == 2) {
                this.activeOperation = 2;
                this.resizeShape(object);
                this.updateAffordances();
            }
        }
    }

    protected void dragWholeShape(DragSelectEvent dragSelectEvent, Object object) {
        if (!(object instanceof Movable)) {
            return;
        }
        Movable movable = (Movable)object;
        View view = this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        Position position = movable.getReferencePosition();
        double d = this.computeSurfaceElevation(this.wwd, position);
        position = new Position(position, d);
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = view.project(vec4);
        int n = dragSelectEvent.getPickPoint().x - dragSelectEvent.getPreviousPickPoint().x;
        double d2 = vec42.x + (double)n;
        int n2 = dragSelectEvent.getPickPoint().y - dragSelectEvent.getPreviousPickPoint().y;
        double d3 = (double)dragSelectEvent.getMouseEvent().getComponent().getSize().height - vec42.y + (double)n2 - 1.0;
        Line line = view.computeRayFromScreenPoint(d2, d3);
        Intersection[] intersectionArray = globe.intersect(line, position.getElevation());
        if (intersectionArray != null) {
            Position position2 = globe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
            movable.moveTo(position2);
        }
    }

    protected void resizeShape(Object object) {
        if (!(object instanceof ControlPointMarker)) {
            return;
        }
        PickedObject pickedObject = this.wwd.getObjectsAtCurrentPosition().getTerrainObject();
        if (pickedObject == null) {
            return;
        }
        Position position = pickedObject.getPosition();
        Angle angle = position.getLatitude().subtract(this.previousPosition.getLatitude());
        Angle angle2 = position.getLongitude().subtract(this.previousPosition.getLongitude());
        LatLon latLon = new LatLon(angle, angle2);
        this.previousPosition = position;
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(this.shape.getCorners());
        ControlPointMarker controlPointMarker = (ControlPointMarker)object;
        arrayList.set(controlPointMarker.getIndex(), ((LatLon)arrayList.get(controlPointMarker.getIndex())).add(latLon));
        this.shape.setCorners(arrayList);
    }

    protected void updateAffordances() {
        List<LatLon> list = this.shape.getCorners();
        double d = LatLon.getAverageDistance(list).radians * this.wwd.getModel().getGlobe().getRadius();
        BasicMarkerAttributes basicMarkerAttributes = new BasicMarkerAttributes(Material.BLUE, "gov.nasa.worldwind.render.markers.Sphere", 0.7, 10.0, 0.1, d / 30.0);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(8);
        for (LatLon latLon : list) {
            arrayList.add(latLon);
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2.add(new ControlPointMarker(new Position((LatLon)arrayList.get(i), 0.0), (MarkerAttributes)basicMarkerAttributes, i));
        }
        this.controlPointLayer.setOverrideMarkerElevation(true);
        this.controlPointLayer.setElevation(0.0);
        this.controlPointLayer.setKeepSeparated(false);
        this.controlPointLayer.setMarkers(arrayList2);
    }

    protected double computeSurfaceElevation(WorldWindow worldWindow, LatLon latLon) {
        Vec4 vec4;
        SectorGeometryList sectorGeometryList = worldWindow.getSceneController().getTerrain();
        if (sectorGeometryList != null && (vec4 = sectorGeometryList.getSurfacePoint(latLon.getLatitude(), latLon.getLongitude(), 0.0)) != null) {
            Position position = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
            return position.getElevation();
        }
        return worldWindow.getModel().getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude());
    }

    protected static class ControlPointMarker
    extends BasicMarker {
        private int index;

        public ControlPointMarker(Position position, MarkerAttributes markerAttributes, int n) {
            super(position, markerAttributes);
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

