/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.GeometryMath;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLStateSupport;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceShapeSupport {
    protected static final double ESTIMATED_DEGREES_PER_TEXEL = 0.0703125;
    protected int vertexCount;
    protected double[] vertexArray;
    protected DoubleBuffer vertexBuffer;
    protected OGLStackHandler stackHandler = new OGLStackHandler();
    protected OGLStateSupport stateSupport = new OGLStateSupport();

    public void beginRendering(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        this.stateSupport.setEnableColor(!drawContext.isPickingMode());
        this.stackHandler.pushAttrib(gL, this.stateSupport.getAttributeBits() | 4);
        this.stackHandler.pushClientAttrib(gL, 2);
        gL.glEnableClientState(32884);
    }

    public void endRendering(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        this.stackHandler.pop(gL);
    }

    public void applyMaterialState(DrawContext drawContext, Material material, double d) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        Color color = material.getDiffuse();
        this.stateSupport.setColor(color, d);
        this.stateSupport.setColorMode(OGLStateSupport.COLOR_NO_PREMULTIPLIED_ALPHA);
        this.stateSupport.apply(gL);
    }

    public void applyInteriorState(DrawContext drawContext, ShapeAttributes shapeAttributes) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (shapeAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.applyMaterialState(drawContext, shapeAttributes.getInteriorMaterial(), shapeAttributes.getInteriorOpacity());
    }

    public void applyOutlineState(DrawContext drawContext, ShapeAttributes shapeAttributes) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (shapeAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        double d = shapeAttributes.getOutlineWidth();
        if (drawContext.isPickingMode() && !shapeAttributes.isDrawInterior() && d != 0.0) {
            d += 5.0;
        }
        gL.glLineWidth((float)d);
        if (!drawContext.isPickingMode() && shapeAttributes.isEnableAntialiasing()) {
            gL.glEnable(2848);
        } else {
            gL.glDisable(2848);
        }
        this.applyMaterialState(drawContext, shapeAttributes.getOutlineMaterial(), shapeAttributes.getOutlineOpacity());
    }

    public void bindVertexData(DrawContext drawContext, int n, DoubleBuffer doubleBuffer, int n2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (doubleBuffer == null) {
            String string = Logging.getMessage("nullValue.VertexBufferNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.bindVertexBuffer(drawContext, n, doubleBuffer, n2);
    }

    public void bindVertexData(DrawContext drawContext, int n, List<? extends Vec4> list) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.VertexListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = list.size();
        int n3 = n * n2;
        DoubleBuffer doubleBuffer = this.getVertexBuffer(n3);
        doubleBuffer.rewind();
        this.assembleVertexData(n, list, doubleBuffer);
        doubleBuffer.rewind();
        this.bindVertexData(drawContext, n, doubleBuffer, n2);
    }

    public void drawArrays(DrawContext drawContext, int n, int n2, int n3) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "first < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n3 > this.vertexCount) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "count > vertexCount");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        gL.glDrawArrays(n, n2, n3);
    }

    public void drawArraysAsPolygon(DrawContext drawContext, List<? extends Vec4> list) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.VertexListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        final GL gL = drawContext.getGL();
        GLU gLU = new GLU();
        GLUtessellator gLUtessellator = gLU.gluNewTess();
        GLUtessellatorCallbackAdapter gLUtessellatorCallbackAdapter = new GLUtessellatorCallbackAdapter(){

            public void begin(int n) {
                gL.glBegin(n);
            }

            public void vertex(Object object) {
                int n = (Integer)object;
                gL.glArrayElement(n);
            }

            public void end() {
                gL.glEnd();
            }
        };
        gLU.gluTessNormal(gLUtessellator, 0.0, 0.0, 1.0);
        gLU.gluTessCallback(gLUtessellator, 100100, gLUtessellatorCallbackAdapter);
        gLU.gluTessCallback(gLUtessellator, 100101, gLUtessellatorCallbackAdapter);
        gLU.gluTessCallback(gLUtessellator, 100102, gLUtessellatorCallbackAdapter);
        gLU.gluTessBeginPolygon(gLUtessellator, null);
        gLU.gluTessBeginContour(gLUtessellator);
        for (int i = 0; i < list.size(); ++i) {
            double[] dArray = new double[3];
            list.get(i).toArray3(dArray, 0);
            gLU.gluTessVertex(gLUtessellator, dArray, 0, i);
        }
        gLU.gluTessEndContour(gLUtessellator);
        gLU.gluTessEndPolygon(gLUtessellator);
        gLU.gluDeleteTess(gLUtessellator);
    }

    protected void bindVertexBuffer(DrawContext drawContext, int n, DoubleBuffer doubleBuffer, int n2) {
        if (n != 2 && n != 3 && n != 4) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "numCoords must be 2, 3, or 4");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        gL.glVertexPointer(n, 5130, 0, doubleBuffer);
        this.vertexCount = n2;
    }

    protected double[] getVertexArray(int n) {
        if (this.vertexArray == null || this.vertexArray.length < n) {
            this.vertexArray = new double[n];
        }
        return this.vertexArray;
    }

    protected DoubleBuffer getVertexBuffer(int n) {
        if (this.vertexBuffer == null || this.vertexBuffer.capacity() < n) {
            this.vertexBuffer = BufferUtil.newDoubleBuffer(n);
        }
        return this.vertexBuffer;
    }

    public Iterable<? extends Sector> computeBoundingSectors(Iterable<? extends LatLon> iterable, String string) {
        if (iterable == null) {
            String string2 = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Iterable<? extends Sector> iterable2 = LatLon.positionsCrossDateLine(iterable) ? Sector.splitBoundingSectors(iterable) : Arrays.asList(Sector.boundingSector(iterable));
        if (string != null && string == "gov.nasa.worldwind.avkey.GreatCircle") {
            ArrayList<? extends Sector> arrayList = new ArrayList<Sector>();
            for (Sector sector : iterable2) {
                Angle[] angleArray = this.greatArcExtremeLatitudes(iterable);
                double d = sector.getMinLatitude().degrees;
                double d2 = sector.getMaxLatitude().degrees;
                if (d > angleArray[0].degrees) {
                    d = angleArray[0].degrees;
                }
                if (d2 < angleArray[1].degrees) {
                    d2 = angleArray[1].degrees;
                }
                Angle angle = Angle.fromDegreesLatitude(d);
                Angle angle2 = Angle.fromDegreesLatitude(d2);
                arrayList.add(new Sector(angle, angle2, sector.getMinLongitude(), sector.getMaxLongitude()));
            }
            iterable2 = arrayList;
        }
        return iterable2;
    }

    public Iterable<? extends Sector> adjustSectorsByBorderWidth(Iterable<? extends Sector> iterable, ShapeAttributes shapeAttributes) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (shapeAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = 0.0703125 * shapeAttributes.getOutlineWidth();
        double d2 = d / 2.0;
        ArrayList<Sector> arrayList = new ArrayList<Sector>();
        for (Sector sector : iterable) {
            double d3 = sector.getMinLatitude().degrees - d2;
            double d4 = sector.getMaxLatitude().degrees + d2;
            double d5 = sector.getMinLongitude().degrees;
            double d6 = sector.getMaxLongitude().degrees;
            if (LatLon.positionsCrossDateLine(sector)) {
                d5 += d2;
                d6 -= d2;
            } else {
                d5 -= d2;
                d6 += d2;
            }
            Angle angle = Angle.fromDegreesLatitude(d3);
            Angle angle2 = Angle.fromDegreesLatitude(d4);
            Angle angle3 = Angle.fromDegreesLongitude(d5);
            Angle angle4 = Angle.fromDegreesLongitude(d6);
            arrayList.add(new Sector(angle, angle2, angle3, angle4));
        }
        return arrayList;
    }

    public void makeClosedPath(List<LatLon> list) {
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list.size() < 2) {
            return;
        }
        int n = list.size() - 1;
        if (!list.get(0).equals(list.get(n))) {
            list.add(list.get(0));
        }
    }

    public void generateIntermediateLocations(Iterable<? extends LatLon> iterable, String string, double d, int n, int n2, boolean bl, List<LatLon> list) {
        if (iterable == null) {
            String string2 = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (list == null) {
            String string3 = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        LatLon latLon = null;
        LatLon latLon2 = null;
        for (LatLon latLon3 : iterable) {
            if (latLon == null) {
                latLon = latLon3;
            }
            if (latLon2 != null) {
                this.addIntermediateLocations(latLon2, latLon3, string, d, n, n2, list);
            }
            list.add(latLon3);
            latLon2 = latLon3;
        }
        if (bl && latLon != null && latLon2 != null && !latLon.equals(latLon2)) {
            this.addIntermediateLocations(latLon2, latLon, string, d, n, n2, list);
            list.add(latLon);
        }
    }

    protected Angle[] greatArcExtremeLatitudes(Iterable<? extends LatLon> iterable) {
        double d = Angle.POS90.degrees;
        double d2 = Angle.NEG90.degrees;
        LatLon latLon = null;
        for (LatLon latLon2 : iterable) {
            LatLon[] latLonArray;
            if (latLon != null && (latLonArray = LatLon.greatCircleArcExtremeLocations(latLon, latLon2)) != null) {
                for (LatLon latLon3 : latLonArray) {
                    if (d > latLon3.getLatitude().degrees) {
                        d = latLon3.getLatitude().degrees;
                    }
                    if (!(d2 < latLon3.getLatitude().degrees)) continue;
                    d2 = latLon3.getLatitude().degrees;
                }
            }
            latLon = latLon2;
        }
        return new Angle[]{Angle.fromDegrees(d), Angle.fromDegrees(d2)};
    }

    protected void addIntermediateLocations(LatLon latLon, LatLon latLon2, String string, double d, int n, int n2, List<LatLon> list) {
        block5: {
            block4: {
                if (string == null || string != "gov.nasa.worldwind.avkey.GreatCircle") break block4;
                Angle angle = LatLon.greatCircleDistance(latLon, latLon2);
                double d2 = WWMath.clamp(d * angle.degrees, n, n2);
                int n3 = (int)Math.ceil(d2);
                if (n3 <= 1) break block5;
                double d3 = LatLon.greatCircleAzimuth((LatLon)latLon, (LatLon)latLon2).radians;
                double d4 = angle.radians / (double)(n3 + 1);
                for (int i = 1; i <= n3; ++i) {
                    LatLon latLon3 = LatLon.greatCircleEndPosition(latLon, d3, (double)i * d4);
                    list.add(latLon3);
                }
                break block5;
            }
            if (string != null && (string == "gov.nasa.worldwind.avkey.RhumbLine" || string == "gov.nasa.worldwind.avkey.Loxodrome")) {
                Angle angle = LatLon.rhumbDistance(latLon, latLon2);
                double d5 = WWMath.clamp(d * angle.degrees, n, n2);
                int n4 = (int)Math.ceil(d5);
                if (n4 > 1) {
                    double d6 = LatLon.rhumbAzimuth((LatLon)latLon, (LatLon)latLon2).radians;
                    double d7 = angle.radians / (double)(n4 + 1);
                    for (int i = 1; i <= n4; ++i) {
                        LatLon latLon4 = LatLon.rhumbEndPosition(latLon, d6, (double)i * d7);
                        list.add(latLon4);
                    }
                }
            }
        }
    }

    public void assembleVertexData(int n, double[] dArray, int n2, DoubleBuffer doubleBuffer) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.VertexArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (doubleBuffer == null) {
            String string = Logging.getMessage("nullValue.VertexBufferNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = n * n2;
        doubleBuffer.rewind();
        doubleBuffer.put(dArray, 0, n3);
        doubleBuffer.rewind();
    }

    public void assembleVertexData(int n, List<? extends Vec4> list, DoubleBuffer doubleBuffer) {
        if (n != 2 && n != 3 && n != 4) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "numCoords must be 2, 3, or 4");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.VertexListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (doubleBuffer == null) {
            String string = Logging.getMessage("nullValue.VertexBufferNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = list.size();
        int n3 = n * n2;
        double[] dArray = this.getVertexArray(n3);
        if (n == 2) {
            int n4 = 0;
            for (Vec4 vec4 : list) {
                vec4.toArray2(dArray, n * n4);
                ++n4;
            }
        } else if (n == 3) {
            int n5 = 0;
            for (Vec4 vec4 : list) {
                vec4.toArray3(dArray, n * n5);
                ++n5;
            }
        } else {
            int n6 = 0;
            for (Vec4 vec4 : list) {
                vec4.toArray4(dArray, n * n6);
                ++n6;
            }
        }
        this.assembleVertexData(n, dArray, n2, doubleBuffer);
    }

    public void assembleShapeVertices(Sector sector, int n, int n2, int n3, int n4, Iterable<? extends LatLon> iterable, List<Vec4> list) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.VertexListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromGeographicToViewport(sector, n, n2, n3, n4);
        boolean bl = LatLon.positionsCrossDateLine(iterable);
        boolean bl2 = sector.getMaxLongitude().degrees < 0.0;
        for (LatLon latLon : iterable) {
            double d = latLon.getLatitude().degrees;
            double d2 = latLon.getLongitude().degrees;
            if (bl) {
                if (bl2 && latLon.getLongitude().degrees > 0.0) {
                    d2 -= 360.0;
                } else if (!bl2 && latLon.getLongitude().degrees < 0.0) {
                    d2 += 360.0;
                }
            }
            Vec4 vec4 = new Vec4(d2, d, 1.0);
            vec4 = vec4.transformBy4(matrix);
            list.add(vec4);
        }
    }

    public void stripRedundantEndPoint(List<Vec4> list) {
        if (list == null) {
            String string = Logging.getMessage("nullValue.VertexListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list.size() < 2) {
            return;
        }
        int n = list.size() - 1;
        if (list.get(0).equals(list.get(n))) {
            list.remove(n);
        }
    }

    public void makeWindingCounterClockwise(List<Vec4> list) {
        if (list == null) {
            String string = Logging.getMessage("nullValue.VertexListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = GeometryMath.computePolygonWindingOrder2(list);
        if (string != "gov.nasa.worldwind.avkey.CounterClockWise") {
            Collections.reverse(list);
        }
    }

    public Vec4 computeCenterVertex(List<Vec4> list) {
        if (list == null) {
            String string = Logging.getMessage("nullValue.VertexListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = Vec4.ZERO;
        for (Vec4 vec42 : list) {
            vec4 = vec4.add3(vec42);
        }
        return vec4.divide3(list.size());
    }
}

