/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.util.Logging;

public class SurfaceSquare
extends SurfaceQuad {
    public SurfaceSquare(ShapeAttributes shapeAttributes, LatLon latLon, double d, Angle angle) {
        super(shapeAttributes, latLon, d, d, angle);
    }

    public SurfaceSquare(ShapeAttributes shapeAttributes) {
        this(shapeAttributes, LatLon.ZERO, 0.0, Angle.ZERO);
    }

    public SurfaceSquare(LatLon latLon, double d, Angle angle) {
        this(new BasicShapeAttributes(), latLon, d, angle);
    }

    public SurfaceSquare(LatLon latLon, double d) {
        this(latLon, d, Angle.ZERO);
    }

    public SurfaceSquare() {
        this(new BasicShapeAttributes());
    }

    public double getSize() {
        return this.getWidth();
    }

    public void setSize(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "size < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setSize(d, d);
    }
}

