/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.geom.PolarPoint;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.util.Iterator;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackRenderer
implements Disposable {
    protected int lowerLimit = 0;
    protected int upperLimit = Integer.MAX_VALUE;
    protected final Shape SPHERE = new Sphere();
    protected final Shape CONE = new Cone();
    protected final Shape CYLINDER = new Cylinder();
    protected PickSupport pickSupport = new PickSupport();
    private double elevation = 10.0;
    private boolean overrideMarkerElevation = false;
    private Object client;
    private double markerPixels = 8.0;
    private double minMarkerSize = 3.0;
    private Material material = Material.WHITE;
    private String iconFilePath;
    private Shape shape = this.SPHERE;
    private boolean keepSeparated = true;

    @Override
    public void dispose() {
        this.CONE.dispose();
        this.CYLINDER.dispose();
        this.SPHERE.dispose();
    }

    public double getMarkerPixels() {
        return this.markerPixels;
    }

    public void setMarkerPixels(double d) {
        this.markerPixels = d;
    }

    public double getMinMarkerSize() {
        return this.minMarkerSize;
    }

    public void setMinMarkerSize(double d) {
        this.minMarkerSize = d;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.material = material;
    }

    public String getIconFilePath() {
        return this.iconFilePath;
    }

    public void setIconFilePath(String string) {
        this.iconFilePath = string;
    }

    public void setShapeType(String string) {
        this.shape = string.equalsIgnoreCase("Cone") ? this.CONE : (string.equalsIgnoreCase("Cylinder") ? this.CYLINDER : this.SPHERE);
    }

    public boolean isKeepSeparated() {
        return this.keepSeparated;
    }

    public void setKeepSeparated(boolean bl) {
        this.keepSeparated = bl;
    }

    protected Vec4 draw(DrawContext drawContext, Iterator<TrackPoint> iterator) {
        if (drawContext.getVisibleSector() == null) {
            return null;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return null;
        }
        if (!this.shape.isInitialized) {
            this.shape.initialize(drawContext);
        }
        Vec4 vec4 = null;
        this.begin(drawContext);
        if (!drawContext.isPickingMode()) {
            this.material.apply(drawContext.getGL(), 1028);
        }
        Vec4 vec42 = null;
        int n = 0;
        while (iterator.hasNext()) {
            TrackPoint trackPoint = iterator.next();
            if (n >= this.lowerLimit) {
                if (n > this.upperLimit) break;
                Vec4 vec43 = this.computeSurfacePoint(drawContext, trackPoint);
                if (vec43 != null) {
                    if (drawContext.isPickingMode()) {
                        Color color = drawContext.getUniquePickColor();
                        int n2 = color.getRGB();
                        PickedObject pickedObject = new PickedObject(n2, this.getClient() != null ? this.getClient() : trackPoint.getPosition(), trackPoint.getPosition(), false);
                        pickedObject.setValue("gov.nasa.worldwind.avkey.PickedObject.ID", n);
                        this.pickSupport.addPickableObject(pickedObject);
                        drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                    }
                    double d = this.computeMarkerRadius(drawContext, vec43);
                    if (vec42 == null) {
                        vec42 = vec43;
                        this.shape.render(drawContext, vec43, d);
                        vec4 = vec43;
                    } else if (!this.keepSeparated) {
                        vec42 = vec43;
                        this.shape.render(drawContext, vec43, d);
                        vec4 = vec43;
                    } else {
                        double d2;
                        double d3 = vec43.distanceTo3(vec42);
                        if (d3 > (d2 = 4.0 * d)) {
                            vec42 = vec43;
                            this.shape.render(drawContext, vec43, d);
                            vec4 = vec43;
                        }
                    }
                }
            }
            ++n;
        }
        this.end(drawContext);
        return vec4;
    }

    private double computeMarkerRadius(DrawContext drawContext, Vec4 vec4) {
        double d = vec4.distanceTo3(drawContext.getView().getEyePoint());
        double d2 = this.markerPixels * drawContext.getView().computePixelSizeAtDistance(d);
        if (d2 < this.minMarkerSize) {
            d2 = this.minMarkerSize;
        }
        return d2;
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(int n) {
        this.lowerLimit = n;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(int n) {
        this.upperLimit = n;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double d) {
        this.elevation = d;
    }

    public boolean isOverrideElevation() {
        return this.overrideMarkerElevation;
    }

    public Object getClient() {
        return this.client;
    }

    public void setClient(Object object) {
        this.client = object;
    }

    public void setOverrideElevation(boolean bl) {
        this.overrideMarkerElevation = bl;
    }

    protected Vec4 computeSurfacePoint(DrawContext drawContext, TrackPoint trackPoint) {
        Position position = trackPoint.getPosition();
        if (!this.overrideMarkerElevation) {
            return drawContext.getGlobe().computePointFromPosition(position);
        }
        Vec4 vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(position.getLatitude(), position.getLongitude(), this.elevation);
        if (vec4 != null) {
            return vec4;
        }
        return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), this.elevation);
    }

    protected void begin(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        Vec4 vec4 = drawContext.getView().getEyePoint();
        if (drawContext.isPickingMode()) {
            this.pickSupport.beginPicking(drawContext);
            gL.glPushAttrib(12289);
            gL.glDisable(3553);
            gL.glDisable(2903);
        } else {
            gL.glPushAttrib(274497);
            gL.glDisable(3553);
            float[] fArray = new float[]{(float)(vec4.x * 2.0), (float)(vec4.y / 2.0), (float)vec4.z, 0.0f};
            float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            float[] fArray4 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            gL.glDisable(2903);
            gL.glLightfv(16385, 4611, fArray, 0);
            gL.glLightfv(16385, 4609, fArray2, 0);
            gL.glLightfv(16385, 4608, fArray3, 0);
            gL.glLightfv(16385, 4610, fArray4, 0);
            gL.glDisable(16384);
            gL.glEnable(16385);
            gL.glEnable(2896);
            gL.glEnable(2977);
        }
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
    }

    protected void end(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        if (drawContext.isPickingMode()) {
            this.pickSupport.endPicking(drawContext);
        } else {
            gL.glDisable(16385);
            gL.glEnable(16384);
            gL.glDisable(2896);
            gL.glDisable(2977);
        }
        gL.glPopAttrib();
    }

    public Vec4 pick(DrawContext drawContext, Iterator<TrackPoint> iterator, Point point, Layer layer) {
        this.pickSupport.clearPickList();
        Vec4 vec4 = this.draw(drawContext, iterator);
        this.pickSupport.resolvePick(drawContext, point, layer);
        this.pickSupport.clearPickList();
        return vec4;
    }

    public Vec4 render(DrawContext drawContext, Iterator<TrackPoint> iterator) {
        return this.draw(drawContext, iterator);
    }

    protected static class Cylinder
    extends Shape {
        protected Cylinder() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Cylinder";
            int n = 30;
            boolean bl = true;
            int n2 = 1;
            drawContext.getGL().glNewList(this.glListId, 4864);
            drawContext.getGLU().gluCylinder(this.quadric, 1.0, 1.0, 2.0, n, (int)(2.0 * Math.sqrt((double)bl) + 1.0));
            drawContext.getGLU().gluDisk(this.quadric, 0.0, 1.0, n, n2);
            drawContext.getGL().glTranslated(0.0, 0.0, 2.0);
            drawContext.getGLU().gluDisk(this.quadric, 0.0, 1.0, n, n2);
            drawContext.getGL().glTranslated(0.0, 0.0, -2.0);
            drawContext.getGL().glEndList();
            this.isInitialized = true;
        }

        protected void doRender(DrawContext drawContext, Vec4 vec4, double d) {
            PolarPoint polarPoint = PolarPoint.fromCartesian(vec4);
            drawContext.getGL().glScaled(d, d, d);
            drawContext.getGL().glRotated(polarPoint.getLongitude().getDegrees(), 0.0, 1.0, 0.0);
            drawContext.getGL().glRotated(Math.abs(polarPoint.getLatitude().getDegrees()), Math.signum(polarPoint.getLatitude().getDegrees()) * -1.0, 0.0, 0.0);
            drawContext.getGL().glCallList(this.glListId);
        }
    }

    private static class Cone
    extends Shape {
        private Cone() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Cone";
            int n = 30;
            int n2 = 30;
            int n3 = 2;
            drawContext.getGL().glNewList(this.glListId, 4864);
            drawContext.getGLU().gluQuadricOrientation(this.quadric, 100020);
            drawContext.getGLU().gluCylinder(this.quadric, 1.0, 0.0, 2.0, n, (int)(2.0 * Math.sqrt(n2) + 1.0));
            drawContext.getGLU().gluDisk(this.quadric, 0.0, 1.0, n, n3);
            drawContext.getGL().glEndList();
            this.isInitialized = true;
        }

        protected void doRender(DrawContext drawContext, Vec4 vec4, double d) {
            PolarPoint polarPoint = PolarPoint.fromCartesian(vec4);
            drawContext.getGL().glScaled(d, d, d);
            drawContext.getGL().glRotated(polarPoint.getLongitude().getDegrees(), 0.0, 1.0, 0.0);
            drawContext.getGL().glRotated(Math.abs(polarPoint.getLatitude().getDegrees()), Math.signum(polarPoint.getLatitude().getDegrees()) * -1.0, 0.0, 0.0);
            drawContext.getGL().glCallList(this.glListId);
        }
    }

    private static class Sphere
    extends Shape {
        private Sphere() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Sphere";
            double d = 1.0;
            int n = 36;
            int n2 = 18;
            drawContext.getGL().glNewList(this.glListId, 4864);
            drawContext.getGLU().gluSphere(this.quadric, d, n, n2);
            drawContext.getGL().glEndList();
            this.isInitialized = true;
        }

        protected void doRender(DrawContext drawContext, Vec4 vec4, double d) {
            drawContext.getGL().glScaled(d, d, d);
            drawContext.getGL().glCallList(this.glListId);
        }
    }

    protected static abstract class Shape {
        protected String name;
        protected int glListId;
        protected GLUquadric quadric;
        protected boolean isInitialized = false;

        protected Shape() {
        }

        protected abstract void doRender(DrawContext var1, Vec4 var2, double var3);

        protected void initialize(DrawContext drawContext) {
            this.glListId = drawContext.getGL().glGenLists(1);
            this.quadric = drawContext.getGLU().gluNewQuadric();
            drawContext.getGLU().gluQuadricDrawStyle(this.quadric, 100012);
            drawContext.getGLU().gluQuadricNormals(this.quadric, 100000);
            drawContext.getGLU().gluQuadricOrientation(this.quadric, 100020);
            drawContext.getGLU().gluQuadricTexture(this.quadric, false);
        }

        private void dispose() {
            if (this.isInitialized) {
                GLU gLU = new GLU();
                gLU.gluDeleteQuadric(this.quadric);
                this.isInitialized = false;
                GLContext gLContext = GLContext.getCurrent();
                if (gLContext == null) {
                    return;
                }
                gLContext.getGL().glDeleteLists(this.glListId, 1);
                this.glListId = -1;
            }
        }

        protected void render(DrawContext drawContext, Vec4 vec4, double d) {
            drawContext.getView().pushReferenceCenter(drawContext, vec4);
            this.doRender(drawContext, vec4, d);
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }
}

