/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.AirspaceRenderer;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAirspace
extends AVListImpl
implements Airspace,
Movable {
    protected static final String ARC_SLICES = "ArcSlices";
    protected static final String DISABLE_TERRAIN_CONFORMANCE = "DisableTerrainConformance";
    protected static final String EXPIRY_TIME = "ExpiryTime";
    protected static final String GEOMETRY_CACHE_NAME = "Airspace Geometry";
    protected static final String GEOMETRY_CACHE_KEY = Geometry.class.getName();
    protected static final String GLOBE_KEY = "GlobeKey";
    protected static final String LENGTH_SLICES = "LengthSlices";
    protected static final String LOOPS = "Loops";
    protected static final String PILLARS = "Pillars";
    protected static final String SLICES = "Slices";
    protected static final String SPLIT_THRESHOLD = "SplitThreshold";
    protected static final String STACKS = "Stacks";
    protected static final String SUBDIVISIONS = "Subdivisions";
    protected static final String VERTICAL_EXAGGERATION = "VerticalExaggeration";
    private static final long DEFAULT_GEOMETRY_CACHE_SIZE = 0x1000000L;
    private boolean visible = true;
    private AirspaceAttributes attributes;
    private double lowerAltitude = 0.0;
    private double upperAltitude = 1.0;
    private boolean lowerTerrainConforming = false;
    private boolean upperTerrainConforming = false;
    private boolean enableLevelOfDetail = true;
    private Collection<DetailLevel> detailLevels = new TreeSet<DetailLevel>();
    private AirspaceRenderer renderer = new AirspaceRenderer();
    private GeometryBuilder geometryBuilder = new GeometryBuilder();
    private Extent extent;
    private boolean extentOutOfDate = true;
    private Object extentGlobeKey;
    private long expiryTime = -1L;
    private long minExpiryTime = 2000L;
    private long maxExpiryTime = 6000L;
    private static Random rand = new Random();
    private Map<LatLon, Double> elevationMap = new HashMap<LatLon, Double>();

    public AbstractAirspace(AirspaceAttributes airspaceAttributes) {
        if (airspaceAttributes == null) {
            String string = "nullValue.AirspaceAttributesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = airspaceAttributes;
        if (!WorldWind.getMemoryCacheSet().containsCache(GEOMETRY_CACHE_KEY)) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.AirspaceGeometryCacheSize", 0x1000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName(GEOMETRY_CACHE_NAME);
            WorldWind.getMemoryCacheSet().addCache(GEOMETRY_CACHE_KEY, basicMemoryCache);
        }
    }

    public AbstractAirspace() {
        this(new BasicAirspaceAttributes());
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public AirspaceAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(AirspaceAttributes airspaceAttributes) {
        if (airspaceAttributes == null) {
            String string = "nullValue.AirspaceAttributesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = airspaceAttributes;
    }

    @Override
    public double[] getAltitudes() {
        double[] dArray = new double[]{this.lowerAltitude, this.upperAltitude};
        return dArray;
    }

    protected double[] getAltitudes(double d) {
        double[] dArray = this.getAltitudes();
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        return dArray;
    }

    @Override
    public void setAltitudes(double d, double d2) {
        this.lowerAltitude = d;
        this.upperAltitude = d2;
        this.setExtentOutOfDate();
    }

    @Override
    public void setAltitude(double d) {
        this.setAltitudes(d, d);
    }

    @Override
    public boolean[] isTerrainConforming() {
        boolean[] blArray = new boolean[]{this.lowerTerrainConforming, this.upperTerrainConforming};
        return blArray;
    }

    @Override
    public void setTerrainConforming(boolean bl, boolean bl2) {
        this.lowerTerrainConforming = bl;
        this.upperTerrainConforming = bl2;
        this.setExtentOutOfDate();
    }

    public boolean isAirspaceCollapsed() {
        return this.lowerAltitude == this.upperAltitude && this.lowerTerrainConforming == this.upperTerrainConforming;
    }

    @Override
    public void setTerrainConforming(boolean bl) {
        this.setTerrainConforming(bl, bl);
    }

    @Override
    public boolean isEnableLevelOfDetail() {
        return this.enableLevelOfDetail;
    }

    @Override
    public void setEnableLevelOfDetail(boolean bl) {
        this.enableLevelOfDetail = bl;
    }

    @Override
    public Iterable<DetailLevel> getDetailLevels() {
        return this.detailLevels;
    }

    @Override
    public void setDetailLevels(Collection<DetailLevel> collection) {
        this.detailLevels.clear();
        this.addDetailLevels(collection);
    }

    protected void addDetailLevels(Collection<DetailLevel> collection) {
        if (collection != null) {
            for (DetailLevel detailLevel : collection) {
                if (detailLevel == null) continue;
                this.detailLevels.add(detailLevel);
            }
        }
    }

    @Override
    public boolean isAirspaceVisible(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getView() == null) {
            String string = "nullValue.DrawingContextViewIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Extent extent = this.getExtent(drawContext);
        return extent != null && extent.intersects(drawContext.getView().getFrustumInModelCoordinates());
    }

    @Override
    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object = drawContext.getGlobe().getStateKey(drawContext);
        if (this.extentOutOfDate || this.extent == null || this.extentGlobeKey == null || !this.extentGlobeKey.equals(object)) {
            this.extent = this.doComputeExtent(drawContext);
            this.extentOutOfDate = false;
            this.extentGlobeKey = object;
        }
        return this.extent;
    }

    protected boolean isExtentOutOfDate() {
        return this.extentOutOfDate;
    }

    protected void setExtentOutOfDate() {
        this.extentOutOfDate = true;
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if (!this.isAirspaceVisible(drawContext)) {
            return;
        }
        this.doRender(drawContext);
    }

    @Override
    public void renderGeometry(DrawContext drawContext, String string) {
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.doRenderGeometry(drawContext, string);
    }

    @Override
    public void renderExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.doRenderExtent(drawContext);
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.moveTo(this.getReferencePosition().add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        Position position3 = position;
        this.doMoveTo(position2, position3);
    }

    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getAltitudes();
        double d = position2.getElevation() - position.getElevation();
        this.setAltitudes(dArray[0] + d, dArray[1] + d);
    }

    protected Position computeReferencePosition(List<? extends LatLon> list, double[] dArray) {
        if (list == null) {
            String string = "nullValue.LocationsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = "nullValue.AltitudesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = list.size();
        if (n == 0) {
            return null;
        }
        LatLon latLon = n < 3 ? list.get(0) : list.get(n / 2);
        return new Position(latLon, dArray[0]);
    }

    protected abstract Extent doComputeExtent(DrawContext var1);

    protected abstract void doRenderGeometry(DrawContext var1, String var2);

    protected AirspaceRenderer getRenderer() {
        return this.renderer;
    }

    protected void setRenderer(AirspaceRenderer airspaceRenderer) {
        if (airspaceRenderer == null) {
            String string = "nullValue.AirspaceRendererIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.renderer = airspaceRenderer;
    }

    protected GeometryBuilder getGeometryBuilder() {
        return this.geometryBuilder;
    }

    protected void setGeometryBuilder(GeometryBuilder geometryBuilder) {
        if (geometryBuilder == null) {
            String string = "nullValue.GeometryBuilderIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.geometryBuilder = geometryBuilder;
    }

    protected void doRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AirspaceRenderer airspaceRenderer = this.getRenderer();
        airspaceRenderer.render(drawContext, Arrays.asList(this));
    }

    protected void doRenderExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Extent extent = this.getExtent(drawContext);
        if (extent != null && extent instanceof Renderable) {
            ((Renderable)((Object)extent)).render(drawContext);
        }
    }

    protected DetailLevel computeDetailLevel(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterable<DetailLevel> iterable = this.getDetailLevels();
        if (iterable == null) {
            return null;
        }
        Iterator<DetailLevel> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        DetailLevel detailLevel = iterator.next();
        while (iterator.hasNext() && !detailLevel.meetsCriteria(drawContext, this)) {
            detailLevel = iterator.next();
        }
        return detailLevel;
    }

    protected Cylinder computeBoundingCylinder(DrawContext drawContext, Iterable<? extends LatLon> iterable) {
        Object object;
        Object object2;
        Vec4 vec44;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = "nullValue.LocationsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Globe globe = drawContext.getGlobe();
        double d = drawContext.getVerticalExaggeration();
        double[] dArray = this.getAltitudes();
        boolean[] blArray = this.isTerrainConforming();
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        for (int i = 0; i < 2; ++i) {
            for (LatLon object32 : iterable) {
                arrayList.add(globe.computePointFromPosition(object32.getLatitude(), object32.getLongitude(), d * dArray[i]));
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Vec4 object4 = null;
        for (Vec4 vec42 : arrayList) {
            object4 = object4 == null ? vec42 : vec42.add3(object4);
        }
        if (object4 == null) {
            return null;
        }
        object4 = object4.divide3(arrayList.size());
        Position position = globe.computePositionFromPoint(object4);
        arrayList.add(globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d * dArray[0]));
        arrayList.add(globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d * dArray[1]));
        Vec4 vec43 = globe.computeSurfaceNormalAtPoint(object4);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (Vec4 vec44 : arrayList) {
            Vec4 vec45 = vec44.subtract3(object4);
            double d5 = vec45.dot3(vec43);
            object2 = vec43.multiply3(d5);
            object = vec45.subtract3((Vec4)object2);
            double d6 = ((Vec4)object).getLength3();
            if (d5 < d2) {
                d2 = d5;
            } else if (d5 > d3) {
                d3 = d5;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        if (blArray[0] || blArray[1]) {
            double d7;
            double d8;
            if (LatLon.positionsCrossDateLine(iterable)) {
                Sector[] sectorArray = this.computeSplitSectors(iterable);
                object2 = globe.getMinAndMaxElevations(sectorArray[0]);
                object = globe.getMinAndMaxElevations(sectorArray[1]);
                d8 = Math.min(object2[0], (double)object[0]);
                d7 = Math.max(object2[1], (double)object[1]);
            } else {
                Sector sector = Sector.boundingSector(iterable);
                object2 = globe.getMinAndMaxElevations(sector);
                d8 = object2[0];
                d7 = object2[1];
            }
            if (blArray[0] && d8 < 0.0) {
                d2 += d * d8;
            }
            if (blArray[1] && d7 > 0.0) {
                d3 += d * d7;
            }
        }
        Vec4 vec46 = vec43.multiply3(d2).add3(object4);
        vec44 = vec43.multiply3(d3).add3(object4);
        double d9 = d4;
        return new Cylinder(vec46, vec44, d9);
    }

    protected Sector[] computeSplitSectors(Iterable<? extends LatLon> iterable) {
        Sector[] sectorArray = new Sector[2];
        double d = Angle.NEG180.getDegrees();
        double d2 = Angle.POS180.getDegrees();
        double d3 = Angle.POS90.getDegrees();
        double d4 = Angle.NEG90.getDegrees();
        LatLon latLon = null;
        for (LatLon latLon2 : iterable) {
            double d5;
            double d6 = latLon2.getLatitude().getDegrees();
            if (d6 > d4) {
                d4 = d6;
            }
            if (d6 < d3) {
                d3 = d6;
            }
            if ((d5 = latLon2.getLongitude().getDegrees()) <= 0.0 && d5 > d) {
                d = d5;
            }
            if (d5 >= 0.0 && d5 < d2) {
                d2 = d5;
            }
            if (latLon != null) {
                double d7 = latLon.getLongitude().getDegrees();
                if (Math.signum(d5) != Math.signum(d7) && Math.abs(d5 - d7) < 180.0) {
                    d = 0.0;
                    d2 = 0.0;
                }
            }
            latLon = latLon2;
        }
        d = d2 < -d ? -d2 : d;
        d2 = d2 > -d ? -d : d2;
        sectorArray[0] = Sector.fromDegrees(d3, d4, d2, 180.0);
        sectorArray[1] = Sector.fromDegrees(d3, d4, -180.0, d);
        return sectorArray;
    }

    protected MemoryCache getGeometryCache() {
        return WorldWind.getMemoryCache(GEOMETRY_CACHE_KEY);
    }

    protected boolean isExpired(DrawContext drawContext, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = "nullValue.AirspaceGeometryIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object = geometry.getValue(EXPIRY_TIME);
        if (object != null && object instanceof Long && drawContext.getFrameTimeStamp() > (Long)object) {
            return true;
        }
        object = geometry.getValue(GLOBE_KEY);
        return object != null && !drawContext.getGlobe().getStateKey(drawContext).equals(object);
    }

    protected void updateExpiryCriteria(DrawContext drawContext, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = this.getExpiryTime();
        geometry.setValue(EXPIRY_TIME, l >= 0L ? Long.valueOf(l) : null);
        geometry.setValue(GLOBE_KEY, drawContext.getGlobe().getStateKey(drawContext));
    }

    protected long getExpiryTime() {
        return this.expiryTime;
    }

    protected void setExpiryTime(long l) {
        this.expiryTime = l;
    }

    protected long[] getExpiryRange() {
        long[] lArray = new long[]{this.minExpiryTime, this.maxExpiryTime};
        return lArray;
    }

    protected void setExpiryRange(long l, long l2) {
        this.minExpiryTime = l;
        this.maxExpiryTime = l2;
    }

    protected long nextExpiryTime(DrawContext drawContext, boolean[] blArray) {
        long l;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (blArray[0] || blArray[1]) {
            long l2 = AbstractAirspace.nextLong(this.minExpiryTime, this.maxExpiryTime);
            l = drawContext.getFrameTimeStamp() + l2;
        } else {
            l = -1L;
        }
        return l;
    }

    private static long nextLong(long l, long l2) {
        long l3 = l2 - l + 1L;
        long l4 = rand.nextLong() % l3;
        return l + (l4 < 0L ? -l4 : l4);
    }

    protected void clearElevationMap() {
        this.elevationMap.clear();
    }

    public Vec4 computePointFromPosition(DrawContext drawContext, Angle angle, Angle angle2, double d, boolean bl) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = d;
        if (bl) {
            d2 += this.computeElevationAt(drawContext, angle, angle2);
        }
        return drawContext.getGlobe().computePointFromPosition(angle, angle2, d2);
    }

    protected double computeElevationAt(DrawContext drawContext, Angle angle, Angle angle2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = new LatLon(angle, angle2);
        Double d = this.elevationMap.get(latLon);
        if (d == null) {
            Globe globe = drawContext.getGlobe();
            d = 0.0;
            Vec4 vec4 = drawContext.getPointOnGlobe(angle, angle2);
            if (vec4 != null) {
                Position position = globe.computePositionFromPoint(vec4);
                d = d + position.getElevation();
            } else {
                d = d + drawContext.getVerticalExaggeration() * globe.getElevation(angle, angle2);
            }
            this.elevationMap.put(latLon, d);
        }
        return d;
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        this.doMyGetRestorableState(restorableSupport, stateObject);
    }

    private void doMyGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsBoolean(stateObject, "visible", this.isVisible());
        restorableSupport.addStateValueAsDouble(stateObject, "lowerAltitude", this.getAltitudes()[0]);
        restorableSupport.addStateValueAsDouble(stateObject, "upperAltitude", this.getAltitudes()[1]);
        restorableSupport.addStateValueAsBoolean(stateObject, "lowerTerrainConforming", this.isTerrainConforming()[0]);
        restorableSupport.addStateValueAsBoolean(stateObject, "upperTerrainConforming", this.isTerrainConforming()[1]);
        this.attributes.getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "attributes"));
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        this.doMyRestoreState(restorableSupport, stateObject);
    }

    private void doMyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Boolean bl;
        Double d;
        Double d2;
        Boolean bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "visible");
        if (bl2 != null) {
            this.setVisible(bl2);
        }
        if ((d2 = restorableSupport.getStateValueAsDouble(stateObject, "lowerAltitude")) == null) {
            d2 = this.getAltitudes()[0];
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "upperAltitude")) == null) {
            d = this.getAltitudes()[1];
        }
        this.setAltitudes(d2, d);
        Boolean bl3 = restorableSupport.getStateValueAsBoolean(stateObject, "lowerTerrainConforming");
        if (bl3 == null) {
            bl3 = this.isTerrainConforming()[0];
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "upperTerrainConforming")) == null) {
            bl = this.isTerrainConforming()[1];
        }
        this.setTerrainConforming(bl3, bl);
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "attributes");
        if (stateObject2 != null) {
            this.getAttributes().restoreState(restorableSupport, stateObject2);
        }
    }
}

