/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import javax.media.opengl.GL;

public class BasicAirspaceAttributes
implements AirspaceAttributes {
    private boolean drawInterior = true;
    private boolean drawOutline = false;
    private Material material = Material.WHITE;
    private Material outlineMaterial = Material.BLACK;
    private double opacity = 1.0;
    private double outlineOpacity = 1.0;
    private double outlineWidth = 1.0;

    public BasicAirspaceAttributes(Material material, double d) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "opacity=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.material = material;
        this.opacity = d;
    }

    public BasicAirspaceAttributes(AirspaceAttributes airspaceAttributes) {
        if (airspaceAttributes == null) {
            String string = "nullValue.AirspaceAttributesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.drawInterior = airspaceAttributes.isDrawInterior();
        this.drawOutline = airspaceAttributes.isDrawOutline();
        this.material = airspaceAttributes.getMaterial();
        this.outlineMaterial = airspaceAttributes.getOutlineMaterial();
        this.opacity = airspaceAttributes.getOpacity();
        this.outlineOpacity = airspaceAttributes.getOutlineOpacity();
        this.outlineWidth = airspaceAttributes.getOutlineWidth();
    }

    public BasicAirspaceAttributes() {
    }

    public boolean isDrawInterior() {
        return this.drawInterior;
    }

    public void setDrawInterior(boolean bl) {
        this.drawInterior = bl;
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setDrawOutline(boolean bl) {
        this.drawOutline = bl;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.material = material;
    }

    public Material getOutlineMaterial() {
        return this.outlineMaterial;
    }

    public void setOutlineMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineMaterial = material;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "opacity=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.opacity = d;
    }

    public double getOutlineOpacity() {
        return this.outlineOpacity;
    }

    public void setOutlineOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "opacity=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineOpacity = d;
    }

    public double getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineWidth = d;
    }

    public void applyInterior(DrawContext drawContext, boolean bl) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.applyMaterial(drawContext, this.getMaterial(), this.getOpacity(), bl);
    }

    public void applyOutline(DrawContext drawContext, boolean bl) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.applyMaterial(drawContext, this.getOutlineMaterial(), this.getOutlineOpacity(), bl);
        GL gL = drawContext.getGL();
        gL.glLineWidth((float)this.getOutlineWidth());
    }

    public void getRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsBoolean(stateObject, "drawInterior", this.isDrawInterior());
        restorableSupport.addStateValueAsBoolean(stateObject, "drawOutline", this.isDrawOutline());
        this.getMaterial().getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "material"));
        this.getOutlineMaterial().getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "outlineMaterial"));
        restorableSupport.addStateValueAsDouble(stateObject, "opacity", this.getOpacity());
        restorableSupport.addStateValueAsDouble(stateObject, "outlineOpacity", this.getOutlineOpacity());
        restorableSupport.addStateValueAsDouble(stateObject, "outlineWidth", this.getOutlineWidth());
    }

    public void restoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        RestorableSupport.StateObject stateObject2;
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawInterior");
        if (bl != null) {
            this.setDrawInterior(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawOutline")) != null) {
            this.setDrawOutline(bl);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "material")) != null) {
            this.setMaterial(this.getMaterial().restoreState(restorableSupport, stateObject2));
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "outlineMaterial")) != null) {
            this.setOutlineMaterial(this.getOutlineMaterial().restoreState(restorableSupport, stateObject2));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "opacity")) != null) {
            this.setOpacity(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "outlineOpacity")) != null) {
            this.setOutlineOpacity(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "outlineWidth")) != null) {
            this.setOutlineWidth(d);
        }
    }

    protected void applyMaterial(DrawContext drawContext, Material material, double d, boolean bl) {
        GL gL = drawContext.getGL();
        if (material != null) {
            if (bl) {
                material.apply(gL, 1032, (float)d);
            } else {
                float[] fArray = new float[4];
                material.getDiffuse().getRGBComponents(fArray);
                fArray[3] = (float)d;
                gL.glColor4fv(fArray, 0);
            }
        }
    }
}

