/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.CappedCylinder;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;

public class PartialCappedCylinder
extends CappedCylinder {
    private Angle leftAzimuth = Angle.ZERO;
    private Angle rightAzimuth = Angle.POS360;

    public PartialCappedCylinder(LatLon latLon, double d, Angle angle, Angle angle2) {
        super(latLon, d);
        if (angle == null) {
            String string = "nullValue.LeftAzimuthIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2 == null) {
            String string = "nullValue.RightAzimuthIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.leftAzimuth = angle;
        this.rightAzimuth = angle2;
    }

    public PartialCappedCylinder(LatLon latLon, double d) {
        super(latLon, d);
    }

    public PartialCappedCylinder(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
    }

    public PartialCappedCylinder() {
    }

    public Angle[] getAzimuths() {
        Angle[] angleArray = new Angle[]{this.leftAzimuth, this.rightAzimuth};
        return angleArray;
    }

    public void setAzimuths(Angle angle, Angle angle2) {
        if (angle == null) {
            String string = "nullValue.LeftAzimuthIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2 == null) {
            String string = "nullValue.RightAzimuthIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.leftAzimuth = angle;
        this.rightAzimuth = angle2;
        this.setExtentOutOfDate();
    }

    protected double[] computeAngles() {
        Angle angle;
        Angle angle2 = this.normalizedAzimuth(this.leftAzimuth);
        int n = angle2.compareTo(angle = this.normalizedAzimuth(this.rightAzimuth));
        if (n == 0) {
            return null;
        }
        Angle angle3 = n < 0 ? angle.subtract(angle2) : Angle.POS360.subtract(angle2).add(angle);
        double[] dArray = new double[]{angle2.radians, angle.radians, angle3.radians};
        return dArray;
    }

    protected Angle normalizedAzimuth(Angle angle) {
        if (angle == null) {
            String string = "nullValue.AzimuthIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.degrees;
        double d2 = d < 0.0 ? d + 360.0 : (d >= 360.0 ? d - 360.0 : d);
        return Angle.fromDegrees(d2);
    }

    protected Extent doComputeExtent(DrawContext drawContext) {
        double[] dArray = this.computeAngles();
        if (dArray == null) {
            return super.doComputeExtent(drawContext);
        }
        double[] dArray2 = this.getRadii();
        Matrix matrix = this.computeTransform(drawContext);
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        int n = geometryBuilder.getPartialCylinderVertexCount(8, 0);
        int n2 = 3 * n;
        float[] fArray = new float[n2];
        geometryBuilder.makePartialCylinderVertices((float)Math.max(dArray2[0], dArray2[1]), 0.0f, 8, 0, (float)dArray[0], (float)dArray[2], fArray);
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (int i = 0; i < n2; i += 3) {
            Vec4 vec4 = new Vec4(fArray[i], fArray[i + 1], fArray[i + 2]);
            vec4 = vec4.transformBy4(matrix);
            arrayList.add(drawContext.getGlobe().computePositionFromPoint(vec4));
        }
        return this.computeBoundingCylinder(drawContext, arrayList);
    }

    protected void doRenderGeometry(DrawContext drawContext, String string) {
        Object object;
        Object object2;
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (drawContext.getGL() == null) {
            String string3 = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        double[] dArray = this.computeAngles();
        if (dArray == null) {
            super.doRenderGeometry(drawContext, string);
            return;
        }
        double[] dArray2 = this.getAltitudes(drawContext.getVerticalExaggeration());
        boolean[] blArray = this.isTerrainConforming();
        double[] dArray3 = this.getRadii();
        int n = this.getSlices();
        int n2 = this.getStacks();
        int n3 = this.getLoops();
        if (this.isEnableLevelOfDetail()) {
            object2 = this.computeDetailLevel(drawContext);
            object = object2.getValue("Slices");
            if (object != null && object instanceof Integer) {
                n = (Integer)object;
            }
            if ((object = object2.getValue("Stacks")) != null && object instanceof Integer) {
                n2 = (Integer)object;
            }
            if ((object = object2.getValue("Loops")) != null && object instanceof Integer) {
                n3 = (Integer)object;
            }
            if ((object = object2.getValue("DisableTerrainConformance")) != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                blArray[1] = false;
                blArray[0] = false;
            }
        }
        object2 = this.computeReferenceCenter(drawContext);
        this.setExpiryTime(this.nextExpiryTime(drawContext, blArray));
        this.clearElevationMap();
        object = drawContext.getGL();
        drawContext.getView().pushReferenceCenter(drawContext, (Vec4)object2);
        if ("Airspace.DrawStyleOutline".equals(string)) {
            this.drawRadialWallOutline(drawContext, dArray3, dArray[0], dArray2, blArray, n3, n2, 1, (Vec4)object2);
            this.drawRadialWallOutline(drawContext, dArray3, dArray[1], dArray2, blArray, n3, n2, 0, (Vec4)object2);
            if (dArray3[1] != 0.0) {
                this.drawPartialCylinderOutline(drawContext, dArray3[1], dArray2, blArray, n, n2, 0, dArray[0], dArray[2], (Vec4)object2);
            }
            if (dArray3[0] != 0.0) {
                this.drawPartialCylinderOutline(drawContext, dArray3[0], dArray2, blArray, n, n2, 1, dArray[0], dArray[2], (Vec4)object2);
            }
        } else if ("Airspace.DrawStyleFill".equals(string)) {
            if (this.isEnableCaps()) {
                object.glPushAttrib(8);
                object.glEnable(2884);
                object.glFrontFace(2305);
            }
            if (this.isEnableCaps() && dArray3[0] != dArray3[1]) {
                this.drawPartialDisk(drawContext, dArray3, dArray2[1], blArray[1], n, n3, 0, dArray[0], dArray[2], (Vec4)object2);
                if (!this.isAirspaceCollapsed()) {
                    this.drawPartialDisk(drawContext, dArray3, dArray2[0], blArray[0], n, n3, 1, dArray[0], dArray[2], (Vec4)object2);
                }
            }
            if (!this.isAirspaceCollapsed()) {
                this.drawRadialWall(drawContext, dArray3, dArray[0], dArray2, blArray, n3, n2, 1, (Vec4)object2);
                this.drawRadialWall(drawContext, dArray3, dArray[1], dArray2, blArray, n3, n2, 0, (Vec4)object2);
                if (dArray3[1] != 0.0) {
                    this.drawPartialCylinder(drawContext, dArray3[1], dArray2, blArray, n, n2, 0, dArray[0], dArray[2], (Vec4)object2);
                }
                if (dArray3[0] != 0.0) {
                    this.drawPartialCylinder(drawContext, dArray3[0], dArray2, blArray, n, n2, 1, dArray[0], dArray[2], (Vec4)object2);
                }
            }
            if (this.isEnableCaps()) {
                object.glPopAttrib();
            }
        }
        drawContext.getView().popReferenceCenter(drawContext);
    }

    private void drawPartialCylinder(DrawContext drawContext, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, double d2, double d3, Vec4 vec4) {
        Geometry geometry = this.createPartialCylinderVertexGeometry(drawContext, d, dArray, blArray, n, n2, n3, d2, d3, vec4);
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "PartialCylinder.Indices", n, n2, n3);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makePartialCylinderIndices(n, n2, n3, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.getRenderer().drawGeometry(drawContext, geometry2, geometry);
    }

    private void drawPartialCylinderOutline(DrawContext drawContext, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, double d2, double d3, Vec4 vec4) {
        Geometry geometry = this.createPartialCylinderVertexGeometry(drawContext, d, dArray, blArray, n, n2, n3, d2, d3, vec4);
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "PartialCylinder.OutlineIndices", n, n2, n3);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makePartialCylinderOutlineIndices(n, n2, n3, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.getRenderer().drawGeometry(drawContext, geometry2, geometry);
    }

    private Geometry createPartialCylinderVertexGeometry(DrawContext drawContext, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, double d2, double d3, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "PartialCylinder.Vertices", d, dArray[0], dArray[1], blArray[0], blArray[1], n, n2, n3, d2, d3, vec4);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null || this.isExpired(drawContext, geometry)) {
            if (geometry == null) {
                geometry = new Geometry();
            }
            this.makePartialCylinder(drawContext, d, dArray, blArray, n, n2, n3, d2, d3, vec4, geometry);
            this.updateExpiryCriteria(drawContext, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        return geometry;
    }

    private void makePartialCylinder(DrawContext drawContext, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, double d2, double d3, Vec4 vec4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        float f = (float)(dArray[1] - dArray[0]);
        int n4 = geometryBuilder.getPartialCylinderVertexCount(n, n2);
        int n5 = 3 * n4;
        float[] fArray = new float[n5];
        float[] fArray2 = new float[n5];
        geometryBuilder.makePartialCylinderVertices((float)d, f, n, n2, (float)d2, (float)d3, fArray);
        geometryBuilder.makePartialCylinderNormals((float)d, f, n, n2, (float)d2, (float)d3, fArray2);
        this.makePartialCylinderTerrainConformant(drawContext, n, n2, fArray, dArray, blArray, vec4);
        geometry.setVertexData(n4, fArray);
        geometry.setNormalData(n4, fArray2);
    }

    private void makePartialCylinderTerrainConformant(DrawContext drawContext, int n, int n2, float[] fArray, double[] dArray, boolean[] blArray, Vec4 vec4) {
        Globe globe = drawContext.getGlobe();
        Matrix matrix = this.computeTransform(drawContext);
        for (int i = 0; i <= n; ++i) {
            int n3 = i * (n2 + 1);
            n3 = 3 * n3;
            Vec4 vec42 = new Vec4(fArray[n3], fArray[n3 + 1], fArray[n3 + 2]);
            vec42 = vec42.transformBy4(matrix);
            Position position = globe.computePositionFromPoint(vec42);
            for (int j = 0; j <= n2; ++j) {
                double d = dArray[j];
                if (blArray[j]) {
                    d += this.computeElevationAt(drawContext, position.getLatitude(), position.getLongitude());
                }
                vec42 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
                n3 = j + i * (n2 + 1);
                n3 = 3 * n3;
                fArray[n3] = (float)(vec42.x - vec4.x);
                fArray[n3 + 1] = (float)(vec42.y - vec4.y);
                fArray[n3 + 2] = (float)(vec42.z - vec4.z);
            }
        }
    }

    private void makePartialCylinderIndices(int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getPartialCylinderDrawMode();
        int n5 = geometryBuilder.getPartialCylinderIndexCount(n, n2);
        int[] nArray = new int[n5];
        geometryBuilder.makePartialCylinderIndices(n, n2, nArray);
        geometry.setElementData(n4, n5, nArray);
    }

    private void makePartialCylinderOutlineIndices(int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getPartialCylinderOutlineDrawMode();
        int n5 = geometryBuilder.getPartialCylinderOutlineIndexCount(n, n2);
        int[] nArray = new int[n5];
        geometryBuilder.makePartialCylinderOutlineIndices(n, n2, nArray);
        geometry.setElementData(n4, n5, nArray);
    }

    private void drawPartialDisk(DrawContext drawContext, double[] dArray, double d, boolean bl, int n, int n2, int n3, double d2, double d3, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "PartialDisk.Vertices", dArray[0], dArray[1], d, bl, n, n2, n3, d2, d3, vec4);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null || this.isExpired(drawContext, geometry)) {
            if (geometry == null) {
                geometry = new Geometry();
            }
            this.makePartialDisk(drawContext, dArray, d, bl, n, n2, n3, d2, d3, vec4, geometry);
            this.updateExpiryCriteria(drawContext, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        cacheKey = new Geometry.CacheKey(this.getClass(), "PartialDisk.Indices", n, n2, n3);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makePartialDiskIndices(n, n2, n3, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.getRenderer().drawGeometry(drawContext, geometry2, geometry);
    }

    private void makePartialDisk(DrawContext drawContext, double[] dArray, double d, boolean bl, int n, int n2, int n3, double d2, double d3, Vec4 vec4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getPartialDiskIndexCount(n, n2);
        int n5 = 3 * n4;
        float[] fArray = new float[n5];
        float[] fArray2 = new float[n5];
        geometryBuilder.makePartialDiskVertices((float)dArray[0], (float)dArray[1], n, n2, (float)d2, (float)d3, fArray);
        this.makePartialDiskTerrainConformant(drawContext, n5, fArray, d, bl, vec4);
        geometryBuilder.makePartialDiskVertexNormals((float)dArray[0], (float)dArray[1], n, n2, (float)d2, (float)d3, fArray, fArray2);
        geometry.setVertexData(n4, fArray);
        geometry.setNormalData(n4, fArray2);
    }

    private void makePartialDiskTerrainConformant(DrawContext drawContext, int n, float[] fArray, double d, boolean bl, Vec4 vec4) {
        Globe globe = drawContext.getGlobe();
        Matrix matrix = this.computeTransform(drawContext);
        for (int i = 0; i < n; i += 3) {
            Vec4 vec42 = new Vec4(fArray[i], fArray[i + 1], fArray[i + 2]);
            vec42 = vec42.transformBy4(matrix);
            Position position = globe.computePositionFromPoint(vec42);
            double d2 = d;
            if (bl) {
                d2 += this.computeElevationAt(drawContext, position.getLatitude(), position.getLongitude());
            }
            vec42 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d2);
            fArray[i] = (float)(vec42.x - vec4.x);
            fArray[i + 1] = (float)(vec42.y - vec4.y);
            fArray[i + 2] = (float)(vec42.z - vec4.z);
        }
    }

    private void makePartialDiskIndices(int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getPartialDiskDrawMode();
        int n5 = geometryBuilder.getPartialDiskIndexCount(n, n2);
        int[] nArray = new int[n5];
        geometryBuilder.makePartialDiskIndices(n, n2, nArray);
        geometry.setElementData(n4, n5, nArray);
    }

    private void drawRadialWall(DrawContext drawContext, double[] dArray, double d, double[] dArray2, boolean[] blArray, int n, int n2, int n3, Vec4 vec4) {
        Geometry geometry = this.createRadialWallVertexGeometry(drawContext, dArray, d, dArray2, blArray, n, n2, n3, vec4);
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "RadialWall.Indices", n, n2, n3);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makeRadialWallIndices(n, n2, n3, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.getRenderer().drawGeometry(drawContext, geometry2, geometry);
    }

    private void drawRadialWallOutline(DrawContext drawContext, double[] dArray, double d, double[] dArray2, boolean[] blArray, int n, int n2, int n3, Vec4 vec4) {
        Geometry geometry = this.createRadialWallVertexGeometry(drawContext, dArray, d, dArray2, blArray, n, n2, n3, vec4);
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "RadialWall.OutlineIndices", n, n2, n3);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makeRadialWallOutlineIndices(n, n2, n3, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.getRenderer().drawGeometry(drawContext, geometry2, geometry);
    }

    private Geometry createRadialWallVertexGeometry(DrawContext drawContext, double[] dArray, double d, double[] dArray2, boolean[] blArray, int n, int n2, int n3, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "RadialWall.Vertices", dArray[0], dArray[1], d, dArray2[0], dArray2[1], blArray[0], blArray[1], n, n2, n3, vec4);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null || this.isExpired(drawContext, geometry)) {
            if (geometry == null) {
                geometry = new Geometry();
            }
            this.makeRadialWall(drawContext, dArray, d, dArray2, blArray, n, n2, n3, vec4, geometry);
            this.updateExpiryCriteria(drawContext, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        return geometry;
    }

    private void makeRadialWall(DrawContext drawContext, double[] dArray, double d, double[] dArray2, boolean[] blArray, int n, int n2, int n3, Vec4 vec4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        float f = (float)(dArray2[1] - dArray2[0]);
        int n4 = geometryBuilder.getRadialWallVertexCount(n, n2);
        int n5 = 3 * n4;
        float[] fArray = new float[n5];
        float[] fArray2 = new float[n5];
        geometryBuilder.makeRadialWallVertices((float)dArray[0], (float)dArray[1], f, (float)d, n, n2, fArray);
        this.makeRadialWallTerrainConformant(drawContext, n, n2, fArray, dArray2, blArray, vec4);
        geometryBuilder.makeRadialWallNormals((float)dArray[0], (float)dArray[1], f, (float)d, n, n2, fArray2);
        geometry.setVertexData(n4, fArray);
        geometry.setNormalData(n4, fArray2);
    }

    private void makeRadialWallTerrainConformant(DrawContext drawContext, int n, int n2, float[] fArray, double[] dArray, boolean[] blArray, Vec4 vec4) {
        Globe globe = drawContext.getGlobe();
        Matrix matrix = this.computeTransform(drawContext);
        for (int i = 0; i <= n; ++i) {
            int n3 = i;
            n3 = 3 * n3;
            Vec4 vec42 = new Vec4(fArray[n3], fArray[n3 + 1], fArray[n3 + 2]);
            vec42 = vec42.transformBy4(matrix);
            Position position = globe.computePositionFromPoint(vec42);
            for (int j = 0; j <= n2; ++j) {
                double d = dArray[j];
                if (blArray[j]) {
                    d += this.computeElevationAt(drawContext, position.getLatitude(), position.getLongitude());
                }
                vec42 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
                n3 = i + j * (n + 1);
                n3 = 3 * n3;
                fArray[n3] = (float)(vec42.x - vec4.x);
                fArray[n3 + 1] = (float)(vec42.y - vec4.y);
                fArray[n3 + 2] = (float)(vec42.z - vec4.z);
            }
        }
    }

    private void makeRadialWallIndices(int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getRadialWallDrawMode();
        int n5 = geometryBuilder.getRadialWallIndexCount(n, n2);
        int[] nArray = new int[n5];
        geometryBuilder.makeRadialWallIndices(n, n2, nArray);
        geometry.setElementData(n4, n5, nArray);
    }

    private void makeRadialWallOutlineIndices(int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getRadialWallOutlineDrawMode();
        int n5 = geometryBuilder.getRadialWallOutlineIndexCount(n, n2);
        int[] nArray = new int[n5];
        geometryBuilder.makeRadialWallOutlineIndices(n, n2, nArray);
        geometry.setElementData(n4, n5, nArray);
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsDouble(stateObject, "leftAzimuthDegrees", this.leftAzimuth.degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "rightAzimuthDegrees", this.rightAzimuth.degrees);
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        super.doRestoreState(restorableSupport, stateObject);
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "leftAzimuthDegrees");
        if (d2 == null) {
            d2 = this.leftAzimuth.degrees;
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "rightAzimuthDegrees")) == null) {
            d = this.rightAzimuth.degrees;
        }
        this.setAzimuths(Angle.fromDegrees(d2), Angle.fromDegrees(d));
    }
}

