/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.Box;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackAirspace
extends AbstractAirspace {
    private List<Box> legs = new ArrayList<Box>();
    private boolean enableInnerCaps = true;
    private boolean legsOutOfDate = true;

    public TrackAirspace(Collection<Box> collection) {
        this.addLegs(collection);
    }

    public TrackAirspace(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
    }

    public TrackAirspace() {
    }

    public List<Box> getLegs() {
        return Collections.unmodifiableList(this.legs);
    }

    public void setLegs(Collection<Box> collection) {
        this.legs.clear();
        this.addLegs(collection);
    }

    protected void addLegs(Iterable<Box> iterable) {
        if (iterable != null) {
            for (Box box : iterable) {
                if (box == null) continue;
                this.addLeg(box);
            }
            this.setLegsOutOfDate();
        }
    }

    public Box addLeg(LatLon latLon, LatLon latLon2, double d, double d2, double d3, double d4) {
        if (latLon == null) {
            String string = "nullValue.StartIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon2 == null) {
            String string = "nullValue.EndIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        boolean[] blArray = this.isTerrainConforming();
        Box box = new Box();
        box.setAltitudes(d, d2);
        box.setTerrainConforming(blArray[0], blArray[1]);
        box.setLocations(latLon, latLon2);
        box.setWidths(d3, d4);
        this.addLeg(box);
        return box;
    }

    protected void addLeg(Box box) {
        if (box == null) {
            String string = "nullValue.LegIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        box.setForceCullFace(true);
        this.legs.add(box);
        this.setExtentOutOfDate();
        this.setLegsOutOfDate();
    }

    public void removeAllLegs() {
        this.legs.clear();
    }

    public boolean isEnableInnerCaps() {
        return this.enableInnerCaps;
    }

    public void setEnableInnerCaps(boolean bl) {
        this.enableInnerCaps = bl;
        this.setLegsOutOfDate();
    }

    @Override
    public void setAltitudes(double d, double d2) {
        super.setAltitudes(d, d2);
        for (Box box : this.legs) {
            box.setAltitudes(d, d2);
        }
        this.setLegsOutOfDate();
    }

    @Override
    public void setTerrainConforming(boolean bl, boolean bl2) {
        super.setTerrainConforming(bl, bl2);
        for (Box box : this.legs) {
            box.setTerrainConforming(bl, bl2);
        }
        this.setLegsOutOfDate();
    }

    @Override
    public boolean isAirspaceVisible(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        for (Box box : this.legs) {
            if (!box.isAirspaceVisible(drawContext)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public Position getReferencePosition() {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(2 * this.legs.size());
        for (Box box : this.legs) {
            LatLon[] latLonArray = box.getLocations();
            arrayList.add(latLonArray[0]);
            arrayList.add(latLonArray[1]);
        }
        return this.computeReferencePosition(arrayList, this.getAltitudes());
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Box box : this.legs) {
            box.doMoveTo(position, position2);
        }
        this.setExtentOutOfDate();
        this.setLegsOutOfDate();
    }

    protected boolean isLegsOutOfDate() {
        return this.legsOutOfDate;
    }

    protected void setLegsOutOfDate() {
        this.legsOutOfDate = true;
    }

    protected void doUpdateLegs(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = this.legs.size();
        Plane plane = null;
        for (int i = 0; i < n; ++i) {
            Box box = this.legs.get(i);
            Box box2 = i + 1 < n ? this.legs.get(i + 1) : null;
            Vec4[] vec4Array = Box.computeStandardVertices(drawContext, box);
            Line line = Line.fromSegment(vec4Array[0], vec4Array[4]);
            Line line2 = Line.fromSegment(vec4Array[1], vec4Array[5]);
            Line line3 = Line.fromSegment(vec4Array[2], vec4Array[6]);
            Line line4 = Line.fromSegment(vec4Array[3], vec4Array[7]);
            Plane plane2 = null;
            if (i == 0) {
                box.setEnableStartCap(true);
            }
            if (box2 != null) {
                box.setEnableEndCap(this.isEnableInnerCaps());
                box2.setEnableStartCap(this.isEnableInnerCaps());
                if (!this.areLegsDisjoint(box, box2)) {
                    plane2 = this.computeJoiningPlane(drawContext, box, box2);
                    vec4Array[4] = plane2.intersect(line);
                    vec4Array[5] = plane2.intersect(line2);
                    vec4Array[6] = plane2.intersect(line3);
                    vec4Array[7] = plane2.intersect(line4);
                } else {
                    plane2 = null;
                    box.setEnableEndCap(true);
                    box2.setEnableStartCap(true);
                }
            } else {
                box.setEnableEndCap(true);
            }
            if (plane != null && i > 0) {
                vec4Array[0] = plane.intersect(line);
                vec4Array[1] = plane.intersect(line2);
                vec4Array[2] = plane.intersect(line3);
                vec4Array[3] = plane.intersect(line4);
            }
            box.setVertices(vec4Array);
            plane = plane2;
        }
        this.legsOutOfDate = false;
    }

    protected Plane computeJoiningPlane(DrawContext drawContext, Box box, Box box2) {
        Vec4 vec4;
        Globe globe = drawContext.getGlobe();
        LatLon[] latLonArray = box.getLocations();
        LatLon[] latLonArray2 = box2.getLocations();
        double[] dArray = box.getAltitudes();
        double[] dArray2 = box2.getAltitudes();
        Vec4 vec42 = globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[0]);
        Vec4 vec43 = globe.computePointFromPosition(latLonArray[1].getLatitude(), latLonArray[1].getLongitude(), dArray[0]);
        Vec4 vec44 = globe.computePointFromPosition(latLonArray[1].getLatitude(), latLonArray[1].getLongitude(), dArray[1]);
        Vec4 vec45 = globe.computePointFromPosition(latLonArray2[1].getLatitude(), latLonArray2[1].getLongitude(), dArray2[0]);
        Vec4 vec46 = vec44.subtract3(vec43).normalize3();
        Vec4 vec47 = vec42.subtract3(vec43).perpendicularTo3(vec46).normalize3();
        Vec4 vec48 = vec47.add3(vec4 = vec45.subtract3(vec43).perpendicularTo3(vec46).normalize3());
        Vec4 vec49 = vec48.getLength3() < 1.0E-7 ? vec47.normalize3() : vec46.cross3(vec48).normalize3();
        double d = -vec43.dot3(vec49);
        return new Plane(vec49.getX(), vec49.getY(), vec49.getZ(), d);
    }

    protected boolean areLegsDisjoint(Box box, Box box2) {
        LatLon[] latLonArray = box.getLocations();
        LatLon[] latLonArray2 = box2.getLocations();
        double[] dArray = box.getAltitudes();
        double[] dArray2 = box2.getAltitudes();
        boolean[] blArray = box.isTerrainConforming();
        boolean[] blArray2 = box2.isTerrainConforming();
        return !latLonArray[1].equals(latLonArray2[0]) || dArray[0] != dArray2[0] || dArray[1] != dArray2[1] || blArray[0] != blArray2[0] || blArray[1] != blArray2[1];
    }

    @Override
    protected Extent doComputeExtent(DrawContext drawContext) {
        return null;
    }

    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.isLegsOutOfDate()) {
            this.doUpdateLegs(drawContext);
        }
        for (Box box : this.legs) {
            box.renderGeometry(drawContext, string);
        }
    }

    @Override
    protected void doRenderExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doRenderExtent(drawContext);
        for (Box box : this.legs) {
            box.renderExtent(drawContext);
        }
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsBoolean(stateObject, "enableInnerCaps", this.isEnableInnerCaps());
        RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "legs");
        for (Box box : this.legs) {
            RestorableSupport.StateObject stateObject3 = restorableSupport.addStateObject(stateObject2, "leg");
            box.doGetRestorableState(restorableSupport, stateObject3);
        }
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject stateObject2;
        super.doRestoreState(restorableSupport, stateObject);
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "enableInnerCaps");
        if (bl != null) {
            this.setEnableInnerCaps(bl);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "legs")) == null) {
            return;
        }
        RestorableSupport.StateObject[] stateObjectArray = restorableSupport.getAllStateObjects(stateObject2, "leg");
        if (stateObjectArray == null || stateObjectArray.length == 0) {
            return;
        }
        ArrayList<Box> arrayList = new ArrayList<Box>(stateObjectArray.length);
        for (RestorableSupport.StateObject stateObject3 : stateObjectArray) {
            if (stateObject3 == null) continue;
            Box box = new Box();
            box.doRestoreState(restorableSupport, stateObject3);
            arrayList.add(box);
        }
        this.setLegs(arrayList);
    }
}

