/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces.editor;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceControlPoint;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceControlPointRenderer;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditEvent;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditListener;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditor;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditorUtil;
import gov.nasa.worldwind.render.airspaces.editor.BasicAirspaceControlPointRenderer;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAirspaceEditor
extends AbstractLayer
implements AirspaceEditor {
    private boolean armed;
    private boolean useRubberBand;
    private boolean keepControlPointsAboveTerrain;
    private AirspaceControlPointRenderer controlPointRenderer;
    private EventListenerList eventListeners = new EventListenerList();
    private ArrayList<AirspaceControlPoint> currentControlPoints = new ArrayList();
    protected static final int LOWER_ALTITUDE = 0;
    protected static final int UPPER_ALTITUDE = 1;

    public AbstractAirspaceEditor(AirspaceControlPointRenderer airspaceControlPointRenderer) {
        if (airspaceControlPointRenderer == null) {
            String string = Logging.getMessage("nullValue.RendererIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.armed = false;
        this.useRubberBand = true;
        this.keepControlPointsAboveTerrain = false;
        this.controlPointRenderer = airspaceControlPointRenderer;
    }

    public AbstractAirspaceEditor() {
        this(new BasicAirspaceControlPointRenderer());
    }

    @Override
    public boolean isArmed() {
        return this.armed;
    }

    @Override
    public void setArmed(boolean bl) {
        this.armed = bl;
    }

    @Override
    public boolean isUseRubberBand() {
        return this.useRubberBand;
    }

    @Override
    public void setUseRubberBand(boolean bl) {
        this.useRubberBand = bl;
    }

    @Override
    public boolean isKeepControlPointsAboveTerrain() {
        return this.keepControlPointsAboveTerrain;
    }

    @Override
    public void setKeepControlPointsAboveTerrain(boolean bl) {
        this.keepControlPointsAboveTerrain = bl;
    }

    @Override
    public AirspaceControlPointRenderer getControlPointRenderer() {
        return this.controlPointRenderer;
    }

    @Override
    public void setControlPointRenderer(AirspaceControlPointRenderer airspaceControlPointRenderer) {
        if (airspaceControlPointRenderer == null) {
            String string = Logging.getMessage("nullValue.RendererIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.controlPointRenderer = airspaceControlPointRenderer;
    }

    @Override
    public AirspaceEditListener[] getEditListeners() {
        return (AirspaceEditListener[])this.eventListeners.getListeners(AirspaceEditListener.class);
    }

    @Override
    public void addEditListener(AirspaceEditListener airspaceEditListener) {
        this.eventListeners.add(AirspaceEditListener.class, airspaceEditListener);
    }

    @Override
    public void removeEditListener(AirspaceEditListener airspaceEditListener) {
        this.eventListeners.remove(AirspaceEditListener.class, airspaceEditListener);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        if (!this.isArmed()) {
            return;
        }
        this.draw(drawContext, null);
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        if (!this.isArmed()) {
            return;
        }
        this.draw(drawContext, point);
    }

    protected void draw(DrawContext drawContext, Point point) {
        this.getCurrentControlPoints().clear();
        this.assembleControlPoints(drawContext);
        if (drawContext.isPickingMode()) {
            this.getControlPointRenderer().pick(drawContext, this.getCurrentControlPoints(), point, this);
        } else {
            this.getControlPointRenderer().render(drawContext, this.getCurrentControlPoints());
        }
    }

    protected List<AirspaceControlPoint> getCurrentControlPoints() {
        return this.currentControlPoints;
    }

    protected void setCurrentControlPoints(List<? extends AirspaceControlPoint> list) {
        this.currentControlPoints.clear();
        this.currentControlPoints.addAll(list);
    }

    protected void addControlPoint(DrawContext drawContext, AirspaceControlPoint airspaceControlPoint) {
        this.currentControlPoints.add(airspaceControlPoint);
    }

    protected abstract void assembleControlPoints(DrawContext var1);

    @Override
    public void moveAirspaceLaterally(WorldWindow worldWindow, Airspace airspace, Point point, Point point2) {
        if (this.getAirspace() == null || this.getAirspace() != airspace) {
            return;
        }
        this.doMoveAirspaceLaterally(worldWindow, airspace, point, point2);
    }

    @Override
    public void moveAirspaceVertically(WorldWindow worldWindow, Airspace airspace, Point point, Point point2) {
        if (this.getAirspace() == null || this.getAirspace() != airspace) {
            return;
        }
        this.doMoveAirspaceVertically(worldWindow, airspace, point, point2);
    }

    @Override
    public AirspaceControlPoint addControlPoint(WorldWindow worldWindow, Airspace airspace, Point point) {
        if (this.getAirspace() == null || this.getAirspace() != airspace) {
            return null;
        }
        if (worldWindow == null || point == null) {
            return null;
        }
        return this.doAddControlPoint(worldWindow, airspace, point);
    }

    @Override
    public void removeControlPoint(WorldWindow worldWindow, AirspaceControlPoint airspaceControlPoint) {
        if (this.getAirspace() == null) {
            return;
        }
        if (worldWindow == null || airspaceControlPoint == null) {
            return;
        }
        if (this != airspaceControlPoint.getEditor() || this.getAirspace() != airspaceControlPoint.getAirspace()) {
            return;
        }
        this.doRemoveControlPoint(worldWindow, airspaceControlPoint);
    }

    @Override
    public void moveControlPoint(WorldWindow worldWindow, AirspaceControlPoint airspaceControlPoint, Point point, Point point2) {
        if (this.getAirspace() == null) {
            return;
        }
        if (this != airspaceControlPoint.getEditor() || this.getAirspace() != airspaceControlPoint.getAirspace()) {
            return;
        }
        this.doMoveControlPoint(worldWindow, airspaceControlPoint, point, point2);
    }

    @Override
    public void resizeAtControlPoint(WorldWindow worldWindow, AirspaceControlPoint airspaceControlPoint, Point point, Point point2) {
        if (this.getAirspace() == null) {
            return;
        }
        if (this != airspaceControlPoint.getEditor() || this.getAirspace() != airspaceControlPoint.getAirspace()) {
            return;
        }
        this.doResizeAtControlPoint(worldWindow, airspaceControlPoint, point, point2);
    }

    protected void fireAirspaceMoved(AirspaceEditEvent airspaceEditEvent) {
        AirspaceEditListener[] airspaceEditListenerArray = (AirspaceEditListener[])this.eventListeners.getListeners(AirspaceEditListener.class);
        for (int i = airspaceEditListenerArray.length - 1; i >= 0; --i) {
            airspaceEditListenerArray[i].airspaceMoved(airspaceEditEvent);
        }
    }

    protected void fireAirspaceResized(AirspaceEditEvent airspaceEditEvent) {
        AirspaceEditListener[] airspaceEditListenerArray = (AirspaceEditListener[])this.eventListeners.getListeners(AirspaceEditListener.class);
        for (int i = airspaceEditListenerArray.length - 1; i >= 0; --i) {
            airspaceEditListenerArray[i].airspaceResized(airspaceEditEvent);
        }
    }

    protected void fireControlPointAdded(AirspaceEditEvent airspaceEditEvent) {
        AirspaceEditListener[] airspaceEditListenerArray = (AirspaceEditListener[])this.eventListeners.getListeners(AirspaceEditListener.class);
        for (int i = airspaceEditListenerArray.length - 1; i >= 0; --i) {
            airspaceEditListenerArray[i].controlPointAdded(airspaceEditEvent);
        }
    }

    protected void fireControlPointRemoved(AirspaceEditEvent airspaceEditEvent) {
        AirspaceEditListener[] airspaceEditListenerArray = (AirspaceEditListener[])this.eventListeners.getListeners(AirspaceEditListener.class);
        for (int i = airspaceEditListenerArray.length - 1; i >= 0; --i) {
            airspaceEditListenerArray[i].controlPointRemoved(airspaceEditEvent);
        }
    }

    protected void fireControlPointChanged(AirspaceEditEvent airspaceEditEvent) {
        AirspaceEditListener[] airspaceEditListenerArray = (AirspaceEditListener[])this.eventListeners.getListeners(AirspaceEditListener.class);
        for (int i = airspaceEditListenerArray.length - 1; i >= 0; --i) {
            airspaceEditListenerArray[i].controlPointChanged(airspaceEditEvent);
        }
    }

    protected abstract AirspaceControlPoint doAddControlPoint(WorldWindow var1, Airspace var2, Point var3);

    protected abstract void doRemoveControlPoint(WorldWindow var1, AirspaceControlPoint var2);

    protected abstract void doMoveControlPoint(WorldWindow var1, AirspaceControlPoint var2, Point var3, Point var4);

    protected abstract void doResizeAtControlPoint(WorldWindow var1, AirspaceControlPoint var2, Point var3, Point var4);

    protected void doMoveAirspaceLaterally(WorldWindow worldWindow, Airspace airspace, Point point, Point point2) {
        if (!(airspace instanceof Movable)) {
            return;
        }
        Movable movable = (Movable)((Object)airspace);
        View view = worldWindow.getView();
        Globe globe = worldWindow.getModel().getGlobe();
        Position position = movable.getReferencePosition();
        Vec4 vec4 = null;
        if (airspace.isTerrainConforming()[0]) {
            vec4 = worldWindow.getSceneController().getTerrain().getSurfacePoint(position);
        }
        if (vec4 == null) {
            vec4 = globe.computePointFromPosition(position);
        }
        position = globe.computePositionFromPoint(vec4);
        Line line = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Line line2 = view.computeRayFromScreenPoint(point2.getX(), point2.getY());
        Vec4 vec42 = AirspaceEditorUtil.intersectGlobeAt(worldWindow, position.getElevation(), line);
        Vec4 vec43 = AirspaceEditorUtil.intersectGlobeAt(worldWindow, position.getElevation(), line2);
        if (vec42 == null || vec43 == null) {
            return;
        }
        Position position2 = globe.computePositionFromPoint(vec42);
        Position position3 = globe.computePositionFromPoint(vec43);
        Position position4 = position2.subtract(position3);
        movable.move(new Position(position4.getLatitude(), position4.getLongitude(), 0.0));
        this.fireAirspaceMoved(new AirspaceEditEvent(worldWindow, airspace, this));
    }

    protected void doMoveAirspaceVertically(WorldWindow worldWindow, Airspace airspace, Point point, Point point2) {
        if (!(airspace instanceof Movable)) {
            return;
        }
        Movable movable = (Movable)((Object)airspace);
        Position position = movable.getReferencePosition();
        Vec4 vec4 = worldWindow.getModel().getGlobe().computePointFromPosition(position);
        Vec4 vec42 = worldWindow.getModel().getGlobe().computeSurfaceNormalAtLocation(position.getLatitude(), position.getLongitude());
        Line line = new Line(vec4, vec42);
        Line line2 = worldWindow.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line3 = worldWindow.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec43 = AirspaceEditorUtil.nearestPointOnLine(line, line2);
        Vec4 vec44 = AirspaceEditorUtil.nearestPointOnLine(line, line3);
        Position position2 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec43);
        Position position3 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec44);
        double d = position3.getElevation() - position2.getElevation();
        double[] dArray = this.getAirspace().getAltitudes();
        boolean[] blArray = this.getAirspace().isTerrainConforming();
        if (this.isKeepControlPointsAboveTerrain()) {
            if (blArray[0]) {
                if (dArray[0] + d < 0.0) {
                    d = 0.0 - dArray[0];
                }
            } else {
                double d2 = AirspaceEditorUtil.computeLowestHeightAboveSurface(worldWindow, this.getCurrentControlPoints(), 0);
                if (d <= -d2) {
                    d = -d2;
                }
            }
        }
        dArray[0] = dArray[0] + d;
        dArray[1] = dArray[1] + d;
        this.getAirspace().setAltitudes(dArray[0], dArray[1]);
        this.fireAirspaceMoved(new AirspaceEditEvent(worldWindow, airspace, this));
    }
}

