/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.markers;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.util.Logging;

public class BasicMarker
implements Marker {
    private Position position;
    private Angle heading;
    private MarkerAttributes attributes;

    public BasicMarker(Position position, MarkerAttributes markerAttributes) {
        if (markerAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
        this.attributes = markerAttributes;
    }

    public BasicMarker(Position position, MarkerAttributes markerAttributes, Angle angle) {
        if (markerAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
        this.heading = angle;
        this.attributes = markerAttributes;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        this.heading = angle;
    }

    public MarkerAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(MarkerAttributes markerAttributes) {
        this.attributes = markerAttributes;
    }

    public void render(DrawContext drawContext, Vec4 vec4, double d) {
        this.attributes.getShape(drawContext).render(drawContext, this, vec4, d);
    }
}

