/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.markers;

import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.markers.BasicMarkerShape;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.render.markers.MarkerShape;
import gov.nasa.worldwind.util.Logging;

public class BasicMarkerAttributes
implements MarkerAttributes {
    private Material material = Material.WHITE;
    private Material headingMaterial = Material.RED;
    protected double headingScale = 3.0;
    private String shapeType = "gov.nasa.worldwind.render.markers.Sphere";
    private double opacity = 1.0;
    private double markerPixels = 8.0;
    private double minMarkerSize = 3.0;
    private double maxMarkerSize = Double.MAX_VALUE;

    public BasicMarkerAttributes() {
    }

    public BasicMarkerAttributes(Material material, String string, double d) {
        if (material == null) {
            String string2 = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.material = material;
        this.shapeType = string;
        this.opacity = d;
    }

    public BasicMarkerAttributes(Material material, String string, double d, double d2, double d3) {
        if (material == null) {
            String string2 = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (d < 0.0) {
            String string4 = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (d2 < 0.0) {
            String string5 = Logging.getMessage("generic.SizeOutOfRange", d2);
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (d3 < 0.0) {
            String string6 = Logging.getMessage("generic.SizeOutOfRange", d3);
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        this.material = material;
        this.shapeType = string;
        this.opacity = d;
        this.markerPixels = d2;
        this.minMarkerSize = d3;
    }

    public BasicMarkerAttributes(Material material, String string, double d, double d2, double d3, double d4) {
        if (material == null) {
            String string2 = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (d < 0.0) {
            String string4 = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (d2 < 0.0) {
            String string5 = Logging.getMessage("generic.SizeOutOfRange", d2);
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (d3 < 0.0) {
            String string6 = Logging.getMessage("generic.SizeOutOfRange", d3);
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        if (d4 < 0.0) {
            String string7 = Logging.getMessage("generic.SizeOutOfRange", d4);
            Logging.logger().severe(string7);
            throw new IllegalArgumentException(string7);
        }
        this.material = material;
        this.shapeType = string;
        this.opacity = d;
        this.markerPixels = d2;
        this.minMarkerSize = d3;
        this.maxMarkerSize = d4;
    }

    public BasicMarkerAttributes(BasicMarkerAttributes basicMarkerAttributes) {
        if (basicMarkerAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.material = basicMarkerAttributes.material;
        this.headingMaterial = basicMarkerAttributes.headingMaterial;
        this.headingScale = basicMarkerAttributes.headingScale;
        this.shapeType = basicMarkerAttributes.shapeType;
        this.opacity = basicMarkerAttributes.opacity;
        this.markerPixels = basicMarkerAttributes.markerPixels;
        this.minMarkerSize = basicMarkerAttributes.minMarkerSize;
        this.maxMarkerSize = basicMarkerAttributes.maxMarkerSize;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.material = material;
    }

    public Material getHeadingMaterial() {
        return this.headingMaterial;
    }

    public void setHeadingMaterial(Material material) {
        if (this.material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.headingMaterial = material;
    }

    public double getHeadingScale() {
        return this.headingScale;
    }

    public void setHeadingScale(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ScaleOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.headingScale = d;
    }

    public String getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.shapeType = string;
    }

    public MarkerShape getShape(DrawContext drawContext) {
        MarkerShape markerShape = (MarkerShape)drawContext.getValue(this.shapeType);
        if (markerShape == null) {
            markerShape = BasicMarkerShape.createShapeInstance(this.shapeType);
            drawContext.setValue(this.shapeType, markerShape);
        }
        return markerShape;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.opacity = d;
    }

    public double getMarkerPixels() {
        return this.markerPixels;
    }

    public void setMarkerPixels(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.markerPixels = d;
    }

    public double getMinMarkerSize() {
        return this.minMarkerSize;
    }

    public void setMinMarkerSize(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minMarkerSize = d;
    }

    public double getMaxMarkerSize() {
        return this.maxMarkerSize;
    }

    public void setMaxMarkerSize(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.maxMarkerSize = d;
    }

    public void apply(DrawContext drawContext) {
        if (!drawContext.isPickingMode() && this.material != null) {
            if (this.opacity < 1.0) {
                this.material.apply(drawContext.getGL(), 1028, (float)this.opacity);
            } else {
                this.material.apply(drawContext.getGL(), 1028);
            }
        }
    }
}

