/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.markers;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.render.markers.MarkerShape;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

public class BasicMarkerShape {
    public static final String SPHERE = "gov.nasa.worldwind.render.markers.Sphere";
    public static final String CONE = "gov.nasa.worldwind.render.markers.Cone";
    public static final String CYLINDER = "gov.nasa.worldwind.render.markers.Cylinder";
    public static final String HEADING_ARROW = "gov.nasa.worldwind.render.markers.HeadingArrow";
    public static final String HEADING_LINE = "gov.nasa.worldwind.render.markers.HeadingLine";
    public static final String ORIENTED_SPHERE = "gov.nasa.worldwind.render.markers.DirectionalSphere";
    public static final String ORIENTED_CONE = "gov.nasa.worldwind.render.markers.DirectionalCone";
    public static final String ORIENTED_CYLINDER = "gov.nasa.worldwind.render.markers.DirectionalCylinder";
    public static final String ORIENTED_SPHERE_LINE = "gov.nasa.worldwind.render.markers.DirectionalSphereLine";
    public static final String ORIENTED_CONE_LINE = "gov.nasa.worldwind.render.markers.DirectionalConeLine";
    public static final String ORIENTED_CYLINDER_LINE = "gov.nasa.worldwind.render.markers.DirectionalCylinderLine";

    public static MarkerShape createShapeInstance(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == SPHERE) {
            return new Sphere();
        }
        if (string == CONE) {
            return new Cone();
        }
        if (string == CYLINDER) {
            return new Cylinder();
        }
        if (string == HEADING_ARROW) {
            return new HeadingArrow();
        }
        if (string == HEADING_LINE) {
            return new HeadingLine();
        }
        if (string == ORIENTED_SPHERE) {
            return new CompoundShape(ORIENTED_SPHERE, "Oriented Sphere", new Sphere(), new HeadingArrow());
        }
        if (string == ORIENTED_CONE) {
            return new CompoundShape(ORIENTED_CONE, "Oriented Cone", new Cone(), new HeadingArrow(), 0.6);
        }
        if (string == ORIENTED_CYLINDER) {
            return new CompoundShape(ORIENTED_CYLINDER, "Oriented Cylinder", new Cylinder(), new HeadingArrow(), 0.6);
        }
        if (string == ORIENTED_SPHERE_LINE) {
            return new CompoundShape(ORIENTED_SPHERE_LINE, "Oriented Sphere Line", new Sphere(), new HeadingLine(), 1.0);
        }
        if (string == ORIENTED_CONE_LINE) {
            return new CompoundShape(ORIENTED_CONE_LINE, "Oriented Cone Line", new Cone(), new HeadingLine(), 2.0);
        }
        if (string == ORIENTED_CYLINDER_LINE) {
            return new CompoundShape(ORIENTED_CYLINDER_LINE, "Oriented Cylinder Line", new Cylinder(), new HeadingLine(), 2.0);
        }
        return new Sphere();
    }

    protected static class HeadingArrow
    extends Shape {
        protected HeadingArrow() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Heading Arrow";
            this.shapeType = BasicMarkerShape.HEADING_ARROW;
            drawContext.getGL().glNewList(this.glListId, 4864);
            drawContext.getGL().glBegin(9);
            drawContext.getGL().glNormal3f(0.0f, 1.0f, 0.0f);
            drawContext.getGL().glVertex3d(-0.5, 0.0, 0.0);
            drawContext.getGL().glVertex3d(0.0, 0.0, 1.0);
            drawContext.getGL().glVertex3d(0.5, 0.0, 0.0);
            drawContext.getGL().glVertex3d(-0.5, 0.0, 0.0);
            drawContext.getGL().glEnd();
            drawContext.getGL().glEndList();
            this.isInitialized = true;
        }

        protected void doRender(DrawContext drawContext, Marker marker, Vec4 vec4, double d) {
            GL gL = drawContext.getGL();
            MarkerAttributes markerAttributes = marker.getAttributes();
            if (marker.getHeading() == null) {
                return;
            }
            if (!drawContext.isPickingMode() && markerAttributes.getHeadingMaterial() != null && !markerAttributes.getHeadingMaterial().equals(markerAttributes.getMaterial())) {
                if (markerAttributes.getOpacity() < 1.0) {
                    markerAttributes.getHeadingMaterial().apply(drawContext.getGL(), 1028, (float)markerAttributes.getOpacity());
                } else {
                    markerAttributes.getHeadingMaterial().apply(drawContext.getGL(), 1028);
                }
            }
            Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, marker.getHeading(), Angle.fromDegrees(0.1));
            Vec4 vec42 = drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), position.getElevation());
            Vec4 vec43 = vec42.subtract3(vec4).normalize3();
            Angle angle = Angle.fromRadians(Math.acos(vec43.z));
            double d2 = -vec43.y;
            double d3 = vec43.x;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            Vec4 vec44 = drawContext.getGlobe().computeSurfaceNormalAtPoint(vec4).cross3(vec43);
            Vec4 vec45 = Vec4.UNIT_X.transformBy3(Matrix.fromAxisAngle(angle, d2 / d4, d3 / d4, 0.0));
            Angle angle2 = vec45.angleBetween3(vec44);
            double d5 = Math.signum(-vec44.cross3(vec45).dot3(vec43));
            gL.glRotated(angle.degrees, d2 / d4, d3 / d4, 0.0);
            gL.glRotated(angle2.degrees, 0.0, 0.0, d5);
            double d6 = markerAttributes.getHeadingScale() * d;
            gL.glScaled(d6, d6, d6);
            drawContext.getGL().glCallList(this.glListId);
            if (!drawContext.isPickingMode() && markerAttributes.getHeadingMaterial() != null && !markerAttributes.getHeadingMaterial().equals(markerAttributes.getMaterial())) {
                markerAttributes.apply(drawContext);
            }
        }
    }

    protected static class HeadingLine
    extends Shape {
        protected HeadingLine() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Heading Line";
            this.shapeType = BasicMarkerShape.HEADING_LINE;
            drawContext.getGL().glNewList(this.glListId, 4864);
            drawContext.getGL().glBegin(3);
            drawContext.getGL().glNormal3f(0.0f, 1.0f, 0.0f);
            drawContext.getGL().glVertex3d(0.0, 0.0, 0.0);
            drawContext.getGL().glVertex3d(0.0, 0.0, 1.0);
            drawContext.getGL().glEnd();
            drawContext.getGL().glEndList();
            this.isInitialized = true;
        }

        protected void doRender(DrawContext drawContext, Marker marker, Vec4 vec4, double d) {
            GL gL = drawContext.getGL();
            MarkerAttributes markerAttributes = marker.getAttributes();
            if (marker.getHeading() == null) {
                return;
            }
            if (!drawContext.isPickingMode() && markerAttributes.getHeadingMaterial() != null && !markerAttributes.getHeadingMaterial().equals(markerAttributes.getMaterial())) {
                if (markerAttributes.getOpacity() < 1.0) {
                    markerAttributes.getHeadingMaterial().apply(drawContext.getGL(), 1028, (float)markerAttributes.getOpacity());
                } else {
                    markerAttributes.getHeadingMaterial().apply(drawContext.getGL(), 1028);
                }
            }
            Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, marker.getHeading(), Angle.fromDegrees(0.1));
            Vec4 vec42 = drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), position.getElevation());
            Vec4 vec43 = vec42.subtract3(vec4).normalize3();
            Angle angle = Angle.fromRadians(Math.acos(vec43.z));
            double d2 = -vec43.y;
            double d3 = vec43.x;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            gL.glRotated(angle.degrees, d2 / d4, d3 / d4, 0.0);
            double d5 = markerAttributes.getHeadingScale() * d;
            gL.glScaled(d5, d5, d5);
            drawContext.getGL().glCallList(this.glListId);
            if (!drawContext.isPickingMode() && markerAttributes.getHeadingMaterial() != null && !markerAttributes.getHeadingMaterial().equals(markerAttributes.getMaterial())) {
                markerAttributes.apply(drawContext);
            }
        }
    }

    protected static class Cylinder
    extends Shape {
        protected Cylinder() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Cylinder";
            this.shapeType = BasicMarkerShape.CYLINDER;
            int n = 30;
            boolean bl = true;
            int n2 = 1;
            drawContext.getGL().glNewList(this.glListId, 4864);
            drawContext.getGLU().gluCylinder(this.quadric, 1.0, 1.0, 2.0, n, (int)(2.0 * Math.sqrt((double)bl) + 1.0));
            drawContext.getGLU().gluDisk(this.quadric, 0.0, 1.0, n, n2);
            drawContext.getGL().glTranslated(0.0, 0.0, 2.0);
            drawContext.getGLU().gluDisk(this.quadric, 0.0, 1.0, n, n2);
            drawContext.getGL().glTranslated(0.0, 0.0, -2.0);
            drawContext.getGL().glEndList();
            this.isInitialized = true;
        }

        protected void doRender(DrawContext drawContext, Marker marker, Vec4 vec4, double d) {
            Vec4 vec42 = drawContext.getGlobe().computeSurfaceNormalAtPoint(vec4);
            Angle angle = Angle.fromRadians(Math.acos(vec42.z));
            double d2 = -vec42.y;
            double d3 = vec42.x;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            drawContext.getGL().glRotated(angle.degrees, d2 / d4, d3 / d4, 0.0);
            drawContext.getGL().glScaled(d, d, d);
            drawContext.getGL().glCallList(this.glListId);
        }
    }

    private static class Cone
    extends Shape {
        private Cone() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Cone";
            this.shapeType = BasicMarkerShape.CONE;
            int n = 30;
            int n2 = 30;
            int n3 = 2;
            drawContext.getGL().glNewList(this.glListId, 4864);
            drawContext.getGLU().gluQuadricOrientation(this.quadric, 100020);
            drawContext.getGLU().gluCylinder(this.quadric, 1.0, 0.0, 2.0, n, (int)(2.0 * Math.sqrt(n2) + 1.0));
            drawContext.getGLU().gluDisk(this.quadric, 0.0, 1.0, n, n3);
            drawContext.getGL().glEndList();
            this.isInitialized = true;
        }

        protected void doRender(DrawContext drawContext, Marker marker, Vec4 vec4, double d) {
            Vec4 vec42 = drawContext.getGlobe().computeSurfaceNormalAtPoint(vec4);
            Angle angle = Angle.fromRadians(Math.acos(vec42.z));
            double d2 = -vec42.y;
            double d3 = vec42.x;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            drawContext.getGL().glRotated(angle.degrees, d2 / d4, d3 / d4, 0.0);
            drawContext.getGL().glScaled(d, d, d);
            drawContext.getGL().glCallList(this.glListId);
        }
    }

    private static class Sphere
    extends Shape {
        private Sphere() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Sphere";
            this.shapeType = BasicMarkerShape.SPHERE;
            double d = 1.0;
            int n = 36;
            int n2 = 18;
            drawContext.getGL().glNewList(this.glListId, 4864);
            drawContext.getGLU().gluSphere(this.quadric, d, n, n2);
            drawContext.getGL().glEndList();
            this.isInitialized = true;
        }

        protected void doRender(DrawContext drawContext, Marker marker, Vec4 vec4, double d) {
            drawContext.getGL().glScaled(d, d, d);
            drawContext.getGL().glCallList(this.glListId);
        }
    }

    protected static abstract class Shape
    implements MarkerShape,
    Disposable {
        protected String name;
        protected String shapeType;
        protected int glListId;
        protected GLUquadric quadric;
        protected boolean isInitialized = false;

        protected Shape() {
        }

        protected abstract void doRender(DrawContext var1, Marker var2, Vec4 var3, double var4);

        protected void initialize(DrawContext drawContext) {
            this.glListId = drawContext.getGL().glGenLists(1);
            this.quadric = drawContext.getGLU().gluNewQuadric();
            drawContext.getGLU().gluQuadricDrawStyle(this.quadric, 100012);
            drawContext.getGLU().gluQuadricNormals(this.quadric, 100000);
            drawContext.getGLU().gluQuadricOrientation(this.quadric, 100020);
            drawContext.getGLU().gluQuadricTexture(this.quadric, false);
        }

        public void dispose() {
            if (this.isInitialized) {
                GLU gLU = new GLU();
                gLU.gluDeleteQuadric(this.quadric);
                this.isInitialized = false;
                GLContext gLContext = GLContext.getCurrent();
                if (gLContext == null) {
                    return;
                }
                gLContext.getGL().glDeleteLists(this.glListId, 1);
                this.glListId = -1;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getShapeType() {
            return this.shapeType;
        }

        public void render(DrawContext drawContext, Marker marker, Vec4 vec4, double d) {
            if (!this.isInitialized) {
                this.initialize(drawContext);
            }
            drawContext.getView().pushReferenceCenter(drawContext, vec4);
            this.doRender(drawContext, marker, vec4, d);
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    private static class CompoundShape
    implements MarkerShape,
    Disposable {
        protected String name;
        protected String shapeType;
        private ArrayList<MarkerShape> shapes = new ArrayList(2);
        private double offset = 0.0;

        public CompoundShape(String string, String string2, MarkerShape markerShape, MarkerShape markerShape2) {
            this.name = string2;
            this.shapes.add(markerShape);
            this.shapes.add(markerShape2);
        }

        public CompoundShape(String string, String string2, MarkerShape markerShape, MarkerShape markerShape2, double d) {
            this.name = string2;
            this.shapes.add(markerShape);
            this.shapes.add(markerShape2);
            this.offset = d;
        }

        public void dispose() {
            for (MarkerShape markerShape : this.shapes) {
                if (!(markerShape instanceof Disposable)) continue;
                ((Disposable)((Object)markerShape)).dispose();
            }
        }

        public String getName() {
            return this.name;
        }

        public String getShapeType() {
            return this.shapeType;
        }

        public void render(DrawContext drawContext, Marker marker, Vec4 vec4, double d) {
            this.shapes.get(0).render(drawContext, marker, vec4, d);
            if (this.offset != 0.0) {
                Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
                vec4 = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), position.getElevation() + d * this.offset);
            }
            this.shapes.get(1).render(drawContext, marker, vec4, d);
        }
    }
}

