/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.retrieve;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.logging.Level;

public final class RetrieveToFilePostProcessor
implements RetrievalPostProcessor {
    File destination;

    public RetrieveToFilePostProcessor(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.DestNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.destination = file;
    }

    public ByteBuffer run(Retriever retriever) {
        ByteBuffer byteBuffer;
        block11: {
            if (retriever == null) {
                String string = Logging.getMessage("nullValue.RetrieverIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            ByteBuffer byteBuffer2 = retriever.getBuffer();
            if (byteBuffer2 == null) {
                Logging.logger().log(Level.SEVERE, "RetrieveToFilePostProcessor.NullBufferPostprocessing", retriever.getName());
                return null;
            }
            Object object = null;
            try {
                object = new FileOutputStream(this.destination);
                ((FileOutputStream)object).getChannel().write(byteBuffer2);
                byteBuffer = null;
                if (object == null) break block11;
            }
            catch (IOException iOException) {
                try {
                    try {
                        throw iOException;
                    }
                    catch (Throwable throwable) {
                        if (object != null) {
                            ((FileOutputStream)object).close();
                        }
                        throw throwable;
                    }
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                    Logging.logger().log(Level.FINE, Logging.getMessage("generic.OperationCancelled", "retrieval to file"), closedByInterruptException);
                    return null;
                }
                catch (IOException iOException2) {
                    object = Logging.getMessage("RetrieveToFilePostProcessor.ErrorPostprocessing", retriever.getName());
                    Logging.logger().severe((String)object);
                    throw new WWRuntimeException((String)object, iOException2);
                }
            }
            ((FileOutputStream)object).close();
        }
        return byteBuffer;
    }
}

