/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.RetrievalService;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.terrain.AbstractElevationModel;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.TileKey;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWXML;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.xml.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicElevationModel
extends AbstractElevationModel
implements BulkRetrievable {
    private final LevelSet levels;
    private final double minElevation;
    private final double maxElevation;
    private String elevationDataPixelType = "gov.nasa.worldwind.avkey.Int16";
    private String elevationDataByteOrder = "gov.nasa.worldwind.avkey.LittleEndian";
    private double detailHint = 0.0;
    private final Object fileLock = new Object();
    private ConcurrentHashMap<TileKey, Tile> levelZeroTiles = new ConcurrentHashMap();
    private MemoryCache memoryCache;
    private int extremesLevel = -1;
    private BufferWrapper extremes = null;
    private int numExpectedValues = -1;
    private long averageTileSize = -1L;

    public BasicElevationModel(AVList aVList) {
        Boolean bl;
        Double d;
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ElevationModelConfigParams");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.ByteOrder");
        if (string != null) {
            this.setByteOrder(string);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.DetailHint")) != null) {
            this.setDetailHint(d);
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.DisplayName")) != null) {
            this.setName(string);
        }
        this.minElevation = (d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.ElevationMinKey")) != null ? d : 0.0;
        d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.ElevationMaxKey");
        this.maxElevation = d != null ? d : 0.0;
        Long l = (Long)aVList.getValue("gov.nasa.worldwind.avkey.ExpiryTime");
        if (l != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ExpiryTime", l);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.MissingDataFlag")) != null) {
            this.setMissingDataSignal(d);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.MissingDataValue")) != null) {
            this.setMissingDataReplacement(d);
        }
        if ((bl = (Boolean)aVList.getValue("gov.nasa.worldwind.avkey.NetworkRetrievalEnabled")) != null) {
            this.setNetworkRetrievalEnabled(bl);
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.PixelType")) != null) {
            this.setPixelType(string);
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.ElevationExtremesFileKey")) != null) {
            this.loadExtremeElevations(string);
        }
        BasicElevationModel.setFallbacks(aVList);
        this.levels = new LevelSet(aVList);
        this.memoryCache = this.createMemoryCache(Tile.class.getName());
        this.setValue("gov.nasa.worldwind.avkey.ConstructionParameters", aVList.copy());
    }

    public BasicElevationModel(Document document, AVList aVList) {
        this(BasicElevationModel.getParamsFromDocument(document.getDocumentElement(), aVList));
    }

    public BasicElevationModel(Element element, AVList aVList) {
        this(BasicElevationModel.getParamsFromDocument(element, aVList));
    }

    public BasicElevationModel(String string) {
        this(BasicElevationModel.restorableStateToParams(string));
        RestorableSupport restorableSupport;
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected static void setFallbacks(AVList aVList) {
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 150);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 150);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".bil");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", 2);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        }
    }

    protected static AVList getParamsFromDocument(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        XPath xPath = WWXML.makeXPath();
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ByteOrder", "ByteOrder", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.DataCacheNameKey", "DataCacheName", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.DetailHint", "DataDetailHint", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.DatasetNameKey", "DatasetName", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.DisplayName", "DisplayName", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ElevationExtremesFileKey", "ExtremeElevations/FileName", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.ElevationMaxKey", "ExtremeElevations/@max", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.ElevationMinKey", "ExtremeElevations/@min", xPath);
        WWXML.checkAndSetLongParam(element, aVList, "gov.nasa.worldwind.avkey.ExpiryTime", "ExpiryTime", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.FormatSuffixKey", "FormatSuffix", xPath);
        WWXML.checkAndSetLatLonParam(element, aVList, "gov.nasa.worldwind.avkey.LevelZeroTileDelta", "LevelZeroTileDelta/LatLon", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.MissingDataFlag", "MissingDataSignal", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.MissingDataValue", "MissingDataReplacement", xPath);
        WWXML.checkAndSetBooleanParam(element, aVList, "gov.nasa.worldwind.avkey.NetworkRetrievalEnabled", "NetworkRetrievalEnabled", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.NumEmptyLevels", "NumLevels/@numEmpty", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.NumLevels", "NumLevels/@count", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.PixelType", "PixelType", xPath);
        WWXML.checkAndSetSectorParam(element, aVList, "gov.nasa.worldwind.avKey.Sector", "Sector", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ServiceName", "Service/@serviceName", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ServiceURLKey", "Service/URL", xPath);
        WWXML.checkAndSetSectorResolutionParam(element, aVList, "gov.nasa.worldwind.avkey.SectorResolutionLimits", "SectorResolutionLimit", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.TileHeightKey", "TileSize/@height", xPath);
        WWXML.checkAndSetLatLonParam(element, aVList, "gov.nasa.worldwind.avkey.TileOrigin", "TileOrigin/LatLon", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.TileWidthKey", "TileSize/@width", xPath);
        return aVList;
    }

    protected MemoryCache getMemoryCache() {
        return this.memoryCache;
    }

    protected MemoryCache createMemoryCache(String string) {
        if (WorldWind.getMemoryCacheSet().containsCache(string)) {
            return WorldWind.getMemoryCache(string);
        }
        long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.ElevationTileCacheSize", 5000000L);
        BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
        basicMemoryCache.setName("Elevation Tiles");
        WorldWind.getMemoryCacheSet().addCache(string, basicMemoryCache);
        return basicMemoryCache;
    }

    public LevelSet getLevels() {
        return this.levels;
    }

    protected Map<TileKey, Tile> getLevelZeroTiles() {
        return this.levelZeroTiles;
    }

    protected int getExtremesLevel() {
        return this.extremesLevel;
    }

    protected BufferWrapper getExtremes() {
        return this.extremes;
    }

    @Override
    public double getMaxElevation() {
        return this.maxElevation;
    }

    @Override
    public double getMinElevation() {
        return this.minElevation;
    }

    @Override
    public double getBestResolution(Sector sector) {
        if (sector == null) {
            return this.levels.getLastLevel().getTexelSize();
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel(sector);
        return level != null ? level.getTexelSize() : Double.MAX_VALUE;
    }

    @Override
    public double getDetailHint(Sector sector) {
        return this.detailHint;
    }

    public void setDetailHint(double d) {
        this.detailHint = d;
    }

    public String getElevationDataPixelType() {
        return this.elevationDataPixelType;
    }

    public void setPixelType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PixelTypeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.elevationDataPixelType = string;
    }

    public String getElevationDataByteOrder() {
        return this.elevationDataByteOrder;
    }

    public void setByteOrder(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ByteOrderIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.elevationDataByteOrder = string;
    }

    @Override
    public int intersects(Sector sector) {
        if (this.levels.getSector().contains(sector)) {
            return 0;
        }
        return this.levels.getSector().intersects(sector) ? 1 : -1;
    }

    @Override
    public boolean contains(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.levels.getSector().contains(angle, angle2);
    }

    protected Tile createTile(TileKey tileKey) {
        gov.nasa.worldwind.util.Level level = this.levels.getLevel(tileKey.getLevelNumber());
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = this.levels.getTileOrigin().getLatitude();
        Angle angle4 = this.levels.getTileOrigin().getLongitude();
        Angle angle5 = Tile.computeRowLatitude(tileKey.getRow(), angle, angle3);
        Angle angle6 = Tile.computeColumnLongitude(tileKey.getColumn(), angle2, angle4);
        Sector sector = new Sector(angle5, angle5.add(angle), angle6, angle6.add(angle2));
        return new Tile(sector, level, tileKey.getRow(), tileKey.getColumn());
    }

    protected void requestTile(TileKey tileKey) {
        if (WorldWind.getTaskService().isFull()) {
            return;
        }
        if (this.getLevels().isResourceAbsent(tileKey)) {
            return;
        }
        RequestTask requestTask = new RequestTask(tileKey, this);
        WorldWind.getTaskService().addTask(requestTask);
    }

    protected boolean loadElevations(Tile tile, URL uRL) throws IOException {
        BufferWrapper bufferWrapper = this.readElevations(uRL);
        if (bufferWrapper == null || bufferWrapper.length() == 0) {
            return false;
        }
        if (this.numExpectedValues > 0 && bufferWrapper.length() != this.numExpectedValues) {
            return false;
        }
        tile.elevations = bufferWrapper;
        this.addTileToCache(tile, bufferWrapper);
        return true;
    }

    protected void addTileToCache(Tile tile, BufferWrapper bufferWrapper) {
        if (tile.getLevelNumber() == 0) {
            this.levelZeroTiles.putIfAbsent(tile.getTileKey(), tile);
        } else {
            this.memoryCache.add(tile.getTileKey(), tile, bufferWrapper.getSizeInBytes());
        }
    }

    protected boolean areElevationsInMemory(TileKey tileKey) {
        Tile tile = this.getTileFromMemory(tileKey);
        return tile != null && tile.elevations != null;
    }

    protected Tile getTileFromMemory(TileKey tileKey) {
        if (tileKey.getLevelNumber() == 0) {
            return this.levelZeroTiles.get(tileKey);
        }
        return (Tile)this.memoryCache.getObject(tileKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferWrapper readElevations(URL uRL) throws IOException {
        try {
            ByteBuffer byteBuffer;
            Object object = this.fileLock;
            synchronized (object) {
                byteBuffer = WWIO.readURLContentToBuffer(uRL);
            }
            object = new AVListImpl();
            object.setValue("gov.nasa.worldwind.avkey.DataType", this.elevationDataPixelType);
            object.setValue("gov.nasa.worldwind.avkey.ByteOrder", this.elevationDataByteOrder);
            return BufferWrapper.wrap(byteBuffer, (AVList)object);
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.SEVERE, "ElevationModel.ExceptionReadingElevationFile", uRL.toString());
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ByteBuffer convertImageToElevations(ByteBuffer byteBuffer, String string) throws IOException {
        File file = File.createTempFile("wwj-", WWIO.makeSuffixForMimeType(string));
        try {
            WWIO.saveBuffer(byteBuffer, file);
            BufferedImage bufferedImage = ImageIO.read(file);
            ByteBuffer byteBuffer2 = BufferUtil.newByteBuffer(bufferedImage.getWidth() * bufferedImage.getHeight() * 2);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            ShortBuffer shortBuffer = byteBuffer2.asShortBuffer();
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[writableRaster.getWidth() * writableRaster.getHeight()];
            writableRaster.getSamples(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), 0, nArray);
            for (int n : nArray) {
                shortBuffer.put((short)n);
            }
            ByteBuffer byteBuffer3 = byteBuffer2;
            return byteBuffer3;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    @Override
    public BulkRetrievalThread makeLocal(Sector sector, double d) {
        BulkTileDownloadThread bulkTileDownloadThread = new BulkTileDownloadThread(this, sector, d);
        bulkTileDownloadThread.setDaemon(true);
        bulkTileDownloadThread.start();
        return bulkTileDownloadThread;
    }

    @Override
    public long getEstimatedMissingDataSize(Sector sector, double d) {
        int n = this.computeLevelForResolution(sector, d);
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            if (this.getLevels().isLevelEmpty(i)) continue;
            n2 += this.countTilesInSector(sector, i);
        }
        Sector[] sectorArray = this.computeRegions(sector, n, 36);
        int n3 = 6;
        int n4 = 0;
        int n5 = 0;
        try {
            if (sectorArray.length <= n3) {
                n5 = this.countTilesInSector(sector, n);
                n4 = this.getMissingTilesInSector(sector, n).size();
            } else {
                Random random = new Random();
                while (n3 > 0) {
                    int n6 = random.nextInt(sectorArray.length);
                    Sector sector2 = sectorArray[n6];
                    if (sector2 == null) continue;
                    n5 += this.countTilesInSector(sector2, n);
                    n4 += this.getMissingTilesInSector(sector2, n).size();
                    sectorArray[n6] = null;
                    --n3;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return 0L;
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionDuringDataSizeEstimate", this.getName());
            Logging.logger().severe(string);
            throw new RuntimeException(string);
        }
        int n7 = n2 * n4 / n5;
        long l = this.estimateAverageTileSize();
        return (long)n7 * l;
    }

    private long estimateAverageTileSize() {
        if (this.averageTileSize != -1L) {
            return this.averageTileSize;
        }
        long l = 0L;
        int n = 0;
        gov.nasa.worldwind.util.Level level = this.getLevels().getFirstLevel();
        while (level.isEmpty() && !level.equals(this.getLevels().getLastLevel())) {
            level = this.getLevels().getLevel(level.getLevelNumber() + 1);
        }
        File file = new File(WorldWind.getDataFileStore().getWriteLocation(), level.getPath());
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) {
                long l2 = BasicElevationModel.computeAverageTileSize(file2);
                if (l2 > 0L) {
                    l += l2;
                    ++n;
                }
                if (n >= 2) break;
            }
        }
        this.averageTileSize = n > 0 ? l / (long)n : 0L;
        return this.averageTileSize;
    }

    private static long computeAverageTileSize(File file) {
        File[] fileArray;
        long l = 0L;
        int n = 0;
        for (File file2 : fileArray = file.listFiles()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                l += (long)fileInputStream.available();
                fileInputStream.close();
                ++n;
            }
            catch (IOException iOException) {
                n += 0;
            }
        }
        return n > 0 ? l / (long)n : 0L;
    }

    public int computeLevelForResolution(Sector sector, double d) {
        double d2;
        gov.nasa.worldwind.util.Level level;
        double d3;
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        gov.nasa.worldwind.util.Level level2 = this.levels.getLastLevel();
        for (int i = 0; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
            double d4;
            if (this.levels.isLevelEmpty(i) || (d4 = this.levels.getLevel(i).getTexelSize()) > d) continue;
            level2 = this.levels.getLevel(i);
            break;
        }
        if (level2.getLevelNumber() != 0 && !this.levels.isLevelEmpty(level2.getLevelNumber() - 1) && (d3 = Math.abs((level = this.levels.getLevel(level2.getLevelNumber() - 1)).getTexelSize() - d)) < (d2 = Math.abs(level2.getTexelSize() - d))) {
            level2 = level;
        }
        return level2.getLevelNumber();
    }

    public int countTilesInSector(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel();
        if (n >= 0) {
            for (int i = n; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
                if (this.levels.isLevelEmpty(i)) continue;
                level = this.levels.getLevel(i);
                break;
            }
        }
        LatLon latLon = level.getTileDelta();
        LatLon latLon2 = this.levels.getTileOrigin();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), latLon2.getLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), latLon2.getLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), latLon2.getLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), latLon2.getLongitude());
        int n6 = n2 - n4 + 1;
        int n7 = n5 - n3 + 1;
        return n6 * n7;
    }

    public Tile[][] getTilesInSector(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel();
        if (n >= 0) {
            for (int i = n; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
                if (this.levels.isLevelEmpty(i)) continue;
                level = this.levels.getLevel(i);
                break;
            }
        }
        LatLon latLon = level.getTileDelta();
        LatLon latLon2 = this.levels.getTileOrigin();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), latLon2.getLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), latLon2.getLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), latLon2.getLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), latLon2.getLongitude());
        int n6 = n2 - n4 + 1;
        int n7 = n5 - n3 + 1;
        Tile[][] tileArray = new Tile[n6][n7];
        for (int i = n2; i >= n4; --i) {
            for (int j = n3; j <= n5; ++j) {
                TileKey tileKey = new TileKey(level.getLevelNumber(), i, j, level.getCacheName());
                Sector sector2 = this.levels.computeSectorForKey(tileKey);
                tileArray[n2 - i][j - n3] = new Tile(sector2, level, i, j);
            }
        }
        return tileArray;
    }

    private ArrayList<Tile> getMissingTilesInSector(Sector sector, int n) throws InterruptedException {
        Tile[][] tileArray;
        ArrayList<Tile> arrayList = new ArrayList<Tile>();
        Tile[][] tileArray2 = tileArray = this.getTilesInSector(sector, n);
        int n2 = tileArray2.length;
        for (int i = 0; i < n2; ++i) {
            Tile[] tileArray3;
            for (Tile tile : tileArray3 = tileArray2[i]) {
                Thread.sleep(1L);
                if (tile == null || this.isTileLocalOrAbsent(tile)) continue;
                arrayList.add(tile);
            }
        }
        return arrayList;
    }

    private Sector[] computeRegions(Sector sector, int n, int n2) {
        int n3 = this.countTilesInSector(sector, n);
        if (n3 <= n2) {
            return new Sector[]{sector};
        }
        int n4 = (int)Math.ceil(Math.sqrt((float)n3 / (float)n2));
        return sector.subdivide(n4);
    }

    private boolean isTileLocalOrAbsent(Tile tile) {
        if (this.getLevels().isResourceAbsent(tile)) {
            return true;
        }
        URL uRL = WorldWind.getDataFileStore().findFile(tile.getPath(), false);
        return uRL != null;
    }

    protected void downloadElevations(Tile tile) {
        this.downloadElevations(tile, null);
    }

    protected void downloadElevations(Tile tile, DownloadPostProcessor downloadPostProcessor) {
        if (!this.isNetworkRetrievalEnabled()) {
            this.getLevels().markResourceAbsent(tile);
            return;
        }
        if (!WorldWind.getRetrievalService().isAvailable()) {
            return;
        }
        URL uRL = null;
        try {
            uRL = tile.getResourceURL();
            if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
                this.getLevels().markResourceAbsent(tile);
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("TiledElevationModel.ExceptionCreatingElevationsUrl", uRL), malformedURLException);
            return;
        }
        if (downloadPostProcessor == null) {
            downloadPostProcessor = new DownloadPostProcessor(tile, this);
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, downloadPostProcessor);
        if (WorldWind.getRetrievalService().contains(hTTPRetriever)) {
            return;
        }
        WorldWind.getRetrievalService().runRetriever(hTTPRetriever, 0.0);
    }

    @Override
    public double getUnmappedElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel(angle, angle2);
        TileKey tileKey = new TileKey(angle, angle2, this.levels, level.getLevelNumber());
        Tile tile = this.getTileFromMemory(tileKey);
        if (tile == null) {
            TileKey tileKey2;
            int n = tileKey.getRow();
            int n2 = tileKey.getColumn();
            for (int i = tileKey.getLevelNumber() - 1; i >= 0 && (tile = this.getTileFromMemory(tileKey2 = new TileKey(i, n /= 2, n2 /= 2, this.levels.getLevel(i).getCacheName()))) == null; --i) {
            }
        }
        if (tile == null) {
            gov.nasa.worldwind.util.Level level2 = this.levels.getFirstLevel();
            TileKey tileKey3 = new TileKey(angle, angle2, this.levels, level2.getLevelNumber());
            this.requestTile(tileKey3);
            return this.getMissingDataSignal();
        }
        return this.lookupElevation(angle.radians, angle2.radians, tile);
    }

    @Override
    public double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ElevationsBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < list.size()) {
            String string = Logging.getMessage("ElevationModel.ElevationsBufferTooSmall", list.size());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gov.nasa.worldwind.util.Level level = this.getTargetLevel(sector, d);
        if (level == null) {
            return 0.0;
        }
        Elevations elevations = this.getElevations(sector, this.levels, level.getLevelNumber());
        if (elevations == null) {
            return 0.0;
        }
        for (int i = 0; i < list.size(); ++i) {
            double d2;
            LatLon latLon = list.get(i);
            if (latLon == null || (d2 = elevations.getElevation(latLon.getLatitude(), latLon.getLongitude())) == this.getMissingDataSignal()) continue;
            dArray[i] = d2;
        }
        return elevations.achievedResolution;
    }

    protected gov.nasa.worldwind.util.Level getTargetLevel(Sector sector, double d) {
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel(sector);
        if (level == null) {
            return null;
        }
        if (level.getTexelSize() >= d) {
            return level;
        }
        for (gov.nasa.worldwind.util.Level level2 : this.levels.getLevels()) {
            if (level2.getTexelSize() <= d) {
                return level2;
            }
            if (level2 != level) continue;
            break;
        }
        return level;
    }

    protected double lookupElevation(double d, double d2, Tile tile) {
        double d3;
        Sector sector = tile.getSector();
        int n = tile.getLevel().getTileHeight();
        int n2 = tile.getLevel().getTileWidth();
        double d4 = sector.getDeltaLat().radians;
        double d5 = sector.getDeltaLon().radians;
        double d6 = sector.getMaxLatitude().radians - d;
        double d7 = d2 - sector.getMinLongitude().radians;
        double d8 = d6 / d4;
        double d9 = d7 / d5;
        int n3 = (int)((double)(n - 1) * d8);
        int n4 = (int)((double)(n2 - 1) * d9);
        int n5 = n3 * n2 + n4;
        double d10 = tile.elevations.getDouble(n5);
        double d11 = d3 = n4 < n2 - 1 ? tile.elevations.getDouble(n5 + 1) : d10;
        if (this.getMissingDataSignal() == d10 || this.getMissingDataSignal() == d3) {
            return this.getMissingDataSignal();
        }
        double d12 = d5 / (double)(n2 - 1);
        double d13 = d4 / (double)(n - 1);
        double d14 = (d7 - (double)n4 * d12) / d12;
        double d15 = (d6 - (double)n3 * d13) / d13;
        double d16 = d10 + d14 * (d3 - d10);
        if (n3 < n - 1 && n4 < n2 - 1) {
            d10 = tile.elevations.getDouble(n5 + n2);
            d3 = tile.elevations.getDouble(n5 + n2 + 1);
            if (this.getMissingDataSignal() == d10 || this.getMissingDataSignal() == d3) {
                return this.getMissingDataSignal();
            }
        }
        double d17 = d10 + d14 * (d3 - d10);
        return d16 + d15 * (d17 - d16);
    }

    @Override
    public double[] getExtremeElevations(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.extremesLevel < 0 || this.extremes == null) {
            return new double[]{this.getMinElevation(), this.getMaxElevation()};
        }
        try {
            LatLon latLon = this.levels.getLevel(this.extremesLevel).getTileDelta();
            LatLon latLon2 = this.levels.getTileOrigin();
            int n = Tile.computeRow(latLon.getLatitude(), angle, latLon2.getLatitude());
            int n2 = Tile.computeColumn(latLon.getLongitude(), angle2, latLon2.getLongitude());
            int n3 = Tile.computeColumn(latLon.getLongitude(), Angle.POS180, Angle.NEG180) + 1;
            int n4 = 2 * (n * n3 + n2);
            double d = this.extremes.getDouble(n4);
            double d2 = this.extremes.getDouble(n4 + 1);
            if (d == this.getMissingDataSignal()) {
                d = this.getMissingDataReplacement();
            }
            if (d2 == this.getMissingDataSignal()) {
                d2 = this.getMissingDataReplacement();
            }
            return new double[]{d, d2};
        }
        catch (Exception exception) {
            String string = Logging.getMessage("BasicElevationModel.ExceptionDeterminingExtremes", new LatLon(angle, angle2));
            Logging.logger().log(Level.WARNING, string, exception);
            return new double[]{this.getMinElevation(), this.getMaxElevation()};
        }
    }

    @Override
    public double[] getExtremeElevations(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.extremesLevel < 0 || this.extremes == null) {
            return new double[]{this.getMinElevation(), this.getMaxElevation()};
        }
        try {
            LatLon latLon = this.levels.getLevel(this.extremesLevel).getTileDelta();
            LatLon latLon2 = this.levels.getTileOrigin();
            int n = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), latLon2.getLatitude());
            int n2 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), latLon2.getLongitude());
            int n3 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), latLon2.getLatitude());
            int n4 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), latLon2.getLongitude());
            int n5 = Tile.computeColumn(latLon.getLongitude(), Angle.POS180, Angle.NEG180) + 1;
            double d = Double.MAX_VALUE;
            double d2 = -1.7976931348623157E308;
            for (int i = n3; i <= n; ++i) {
                for (int j = n2; j <= n4; ++j) {
                    int n6 = 2 * (i * n5 + j);
                    double d3 = this.extremes.getDouble(n6);
                    double d4 = this.extremes.getDouble(n6 + 1);
                    if (d3 == this.getMissingDataSignal()) {
                        d3 = this.getMissingDataReplacement();
                    }
                    if (d4 == this.getMissingDataSignal()) {
                        d4 = this.getMissingDataReplacement();
                    }
                    if (d3 > d2) {
                        d2 = d3;
                    }
                    if (d3 < d) {
                        d = d3;
                    }
                    if (d4 > d2) {
                        d2 = d4;
                    }
                    if (!(d4 < d)) continue;
                    d = d4;
                }
            }
            if (d == Double.MAX_VALUE) {
                d = this.getMinElevation();
            }
            if (d2 == Double.MAX_VALUE) {
                d2 = this.getMaxElevation();
            }
            return new double[]{d, d2};
        }
        catch (Exception exception) {
            String string = Logging.getMessage("BasicElevationModel.ExceptionDeterminingExtremes", sector);
            Logging.logger().log(Level.WARNING, string, exception);
            return new double[]{this.getMinElevation(), this.getMaxElevation()};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadExtremeElevations(String string) {
        block14: {
            InputStream inputStream;
            block13: {
                String[] stringArray;
                block12: {
                    if (string == null) {
                        String string2 = Logging.getMessage("nullValue.ExtremeElevationsFileName");
                        Logging.logger().severe(string2);
                        throw new IllegalArgumentException(string2);
                    }
                    inputStream = null;
                    inputStream = this.getClass().getResourceAsStream("/" + string);
                    if (inputStream == null) {
                        stringArray = new File(string);
                        if (stringArray.exists()) {
                            inputStream = new FileInputStream((File)stringArray);
                        } else {
                            Logging.logger().log(Level.WARNING, "BasicElevationModel.UnavailableExtremesFile", string);
                        }
                    }
                    if (inputStream != null) break block12;
                    WWIO.closeStream(inputStream, string);
                    return;
                }
                stringArray = string.substring(0, string.lastIndexOf(".")).split("_");
                this.extremesLevel = Integer.parseInt(stringArray[stringArray.length - 1]);
                if (this.extremesLevel >= 0) break block13;
                this.extremes = null;
                Logging.logger().log(Level.WARNING, "BasicElevationModel.UnavailableExtremesLevel", string);
                WWIO.closeStream(inputStream, string);
                return;
            }
            try {
                AVListImpl aVListImpl = new AVListImpl();
                aVListImpl.setValue("gov.nasa.worldwind.avkey.DataType", this.elevationDataPixelType);
                aVListImpl.setValue("gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.BigEndian");
                this.extremes = BufferWrapper.wrap(WWIO.readStreamToBuffer(inputStream), aVListImpl);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logging.logger().log(Level.WARNING, Logging.getMessage("BasicElevationModel.ExceptionReadingExtremeElevations", string), fileNotFoundException);
                this.extremes = null;
                this.extremesLevel = -1;
                WWIO.closeStream(inputStream, string);
                break block14;
            }
            catch (IOException iOException) {
                Logging.logger().log(Level.WARNING, Logging.getMessage("BasicElevationModel.ExceptionReadingExtremeElevations", string), iOException);
                this.extremes = null;
                this.extremesLevel = -1;
                {
                    catch (Throwable throwable) {
                        WWIO.closeStream(inputStream, string);
                        throw throwable;
                    }
                }
                WWIO.closeStream(inputStream, string);
            }
            WWIO.closeStream(inputStream, string);
        }
    }

    protected Elevations getElevations(Sector sector, LevelSet levelSet, int n) {
        sector = sector.intersection(levelSet.getSector());
        gov.nasa.worldwind.util.Level level = levelSet.getLevel(n);
        LatLon latLon = level.getTileDelta();
        LatLon latLon2 = levelSet.getTileOrigin();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), latLon2.getLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), latLon2.getLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), latLon2.getLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), latLon2.getLongitude());
        TreeSet<Tile> treeSet = new TreeSet<Tile>(new Comparator<Tile>(){

            @Override
            public int compare(Tile tile, Tile tile2) {
                if (tile2.getLevelNumber() == tile.getLevelNumber() && tile2.getRow() == tile.getRow() && tile2.getColumn() == tile.getColumn()) {
                    return 0;
                }
                return tile.getLevelNumber() > tile2.getLevelNumber() ? -1 : 1;
            }
        });
        ArrayList<TileKey> arrayList = new ArrayList<TileKey>();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = n4; i <= n2; ++i) {
            for (int j = n3; j <= n5; ++j) {
                TileKey tileKey = new TileKey(level.getLevelNumber(), i, j, level.getCacheName());
                Tile tile = this.getTileFromMemory(tileKey);
                if (tile != null) {
                    treeSet.add(tile);
                    continue;
                }
                bl = true;
                this.requestTile(tileKey);
                TileKey tileKey2 = null;
                int n6 = i;
                int n7 = j;
                for (int k = tileKey.getLevelNumber() - 1; k >= 0; --k) {
                    TileKey tileKey3 = new TileKey(k, n6 /= 2, n7 /= 2, this.levels.getLevel(k).getCacheName());
                    tile = this.getTileFromMemory(tileKey3);
                    if (tile != null) {
                        if (treeSet.contains(tile)) break;
                        treeSet.add(tile);
                        break;
                    }
                    if (k == 0) {
                        bl2 = true;
                    }
                    tileKey2 = tileKey3;
                }
                if (tileKey2 == null || arrayList.contains(tileKey2)) continue;
                this.requestTile(tileKey2);
                arrayList.add(tileKey2);
            }
        }
        Elevations elevations = bl2 || treeSet.isEmpty() ? new Elevations(this, Double.MAX_VALUE) : (bl ? new Elevations(this, treeSet.last().getLevel().getTexelSize()) : new Elevations(this, treeSet.last().getLevel().getTexelSize()));
        elevations.tiles = treeSet;
        return elevations;
    }

    public ByteBuffer generateExtremeElevations(int n) {
        return null;
    }

    @Override
    public String getRestorableState() {
        AVList aVList = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
        if (aVList == null) {
            return null;
        }
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        String string2 = Logging.getMessage("RestorableSupport.RestoreRequiresConstructor");
        Logging.logger().severe(string2);
        throw new UnsupportedOperationException(string2);
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        AVList aVList = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
        if (aVList != null) {
            for (Map.Entry<String, Object> object : aVList.getEntries()) {
                this.doGetRestorableStateForAVPair(object.getKey(), object.getValue(), restorableSupport, stateObject);
            }
        }
        restorableSupport.addStateValueAsString(stateObject, "ElevationModel.Name", this.getName());
        restorableSupport.addStateValueAsDouble(stateObject, "ElevationModel.MissingDataFlag", this.getMissingDataSignal());
        restorableSupport.addStateValueAsDouble(stateObject, "ElevationModel.MissingDataValue", this.getMissingDataReplacement());
        restorableSupport.addStateValueAsBoolean(stateObject, "ElevationModel.NetworkRetrievalEnabled", this.isNetworkRetrievalEnabled());
        restorableSupport.addStateValueAsDouble(stateObject, "ElevationModel.MinElevation", this.getMinElevation());
        restorableSupport.addStateValueAsDouble(stateObject, "ElevationModel.MaxElevation", this.getMaxElevation());
        restorableSupport.addStateValueAsString(stateObject, "BasicElevationModel.DataPixelType", this.getElevationDataPixelType());
        restorableSupport.addStateValueAsString(stateObject, "BasicElevationModel.DataByteOrder", this.getElevationDataByteOrder());
        if (this.detailHint != 0.0) {
            restorableSupport.addStateValueAsDouble(stateObject, "BasicElevationModel.DetailHint", this.detailHint);
        }
        RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "avlist");
        for (Map.Entry<String, Object> entry : this.getEntries()) {
            this.doGetRestorableStateForAVPair(entry.getKey(), entry.getValue(), restorableSupport, stateObject2);
        }
    }

    protected void doGetRestorableStateForAVPair(String string, Object object, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (object == null) {
            return;
        }
        if (string.equals("gov.nasa.worldwind.avkey.ConstructionParameters")) {
            return;
        }
        if (object instanceof LatLon) {
            restorableSupport.addStateValueAsLatLon(stateObject, string, (LatLon)object);
        } else if (object instanceof Sector) {
            restorableSupport.addStateValueAsSector(stateObject, string, (Sector)object);
        } else {
            restorableSupport.addStateValueAsString(stateObject, string, object.toString());
        }
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject[] stateObjectArray;
        RestorableSupport.StateObject stateObject2;
        Boolean bl;
        Double d;
        String string = restorableSupport.getStateValueAsString(stateObject, "ElevationModel.Name");
        if (string != null) {
            this.setName(string);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "ElevationModel.MissingDataFlag")) != null) {
            this.setMissingDataSignal(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "ElevationModel.MissingDataValue")) != null) {
            this.setMissingDataReplacement(d);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "ElevationModel.NetworkRetrievalEnabled")) != null) {
            this.setNetworkRetrievalEnabled(bl);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "BasicElevationModel.DataPixelType")) != null) {
            this.setPixelType(string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "BasicElevationModel.DataByteOrder")) != null) {
            this.setByteOrder(string);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "BasicElevationModel.DetailHint")) != null) {
            this.setDetailHint(d);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "avlist")) != null && (stateObjectArray = restorableSupport.getAllStateObjects(stateObject2, "")) != null) {
            for (RestorableSupport.StateObject stateObject3 : stateObjectArray) {
                if (stateObject3 == null) continue;
                this.doRestoreStateForObject(restorableSupport, stateObject3);
            }
        }
    }

    protected void doRestoreStateForObject(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (stateObject == null) {
            return;
        }
        this.setValue(stateObject.getName(), stateObject.getValue());
    }

    protected static AVList restorableStateToParams(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AVListImpl aVListImpl = new AVListImpl();
        BasicElevationModel.restoreStateForParams(restorableSupport, null, aVListImpl);
        return aVListImpl;
    }

    protected static void restoreStateForParams(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject, AVList aVList) {
        Double d;
        Sector sector;
        LatLon latLon;
        Long l;
        Integer n;
        StringBuilder stringBuilder = new StringBuilder();
        String string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.DataCacheNameKey");
        if (string != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.ServiceURLKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.DatasetNameKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.FormatSuffixKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", string);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.NumEmptyLevels")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.NumLevels")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.TileWidthKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.TileHeightKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", n);
        }
        if ((l = restorableSupport.getStateValueAsLong(stateObject, "gov.nasa.worldwind.avkey.ExpiryTime")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ExpiryTime", l);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "gov.nasa.worldwind.avkey.LevelZeroTileDelta")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", latLon);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "gov.nasa.worldwind.avkey.TileOrigin")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileOrigin", latLon);
        }
        if ((sector = restorableSupport.getStateValueAsSector(stateObject, "gov.nasa.worldwind.avKey.Sector")) != null) {
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
        if ((d = restorableSupport.getStateValueAsDouble("ElevationModel.MinElevation")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", d);
        } else {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("term.minElevation");
        }
        d = restorableSupport.getStateValueAsDouble("ElevationModel.MaxElevation");
        if (d != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", d);
        } else {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("term.maxElevation");
        }
        if (stringBuilder.length() > 0) {
            String string2 = Logging.getMessage("BasicElevationModel.InvalidDescriptorFields", stringBuilder.toString());
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
    }

    protected static class Tile
    extends gov.nasa.worldwind.util.Tile
    implements Cacheable {
        private BufferWrapper elevations;

        private Tile(Sector sector, gov.nasa.worldwind.util.Level level, int n, int n2) {
            super(sector, level, n, n2);
        }
    }

    protected static class Elevations {
        protected final BasicElevationModel elevationModel;
        protected Set<Tile> tiles;
        protected double[] extremes = null;
        protected final double achievedResolution;

        protected Elevations(BasicElevationModel basicElevationModel, double d) {
            this.elevationModel = basicElevationModel;
            this.achievedResolution = d;
        }

        public double getElevation(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (this.tiles == null) {
                return this.elevationModel.getMissingDataSignal();
            }
            try {
                for (Tile tile : this.tiles) {
                    if (!tile.getSector().contains(angle, angle2)) continue;
                    return this.elevationModel.lookupElevation(angle.radians, angle2.radians, tile);
                }
                return this.elevationModel.getMissingDataSignal();
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("BasicElevationModel.ExceptionComputingElevation", angle, angle2), exception);
                return this.elevationModel.getMissingDataSignal();
            }
        }

        public double[] getExtremes(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (this.extremes != null) {
                return this.extremes;
            }
            if (this.tiles == null || this.tiles.size() == 0) {
                return this.elevationModel.getExtremeElevations(angle, angle2);
            }
            return this.getExtremes();
        }

        public double[] getExtremes() {
            if (this.extremes != null) {
                return this.extremes;
            }
            if (this.tiles == null || this.tiles.size() == 0) {
                this.extremes = new double[]{this.elevationModel.getMinElevation(), this.elevationModel.getMaxElevation()};
                return this.extremes;
            }
            double d = Double.MAX_VALUE;
            double d2 = -1.7976931348623157E308;
            for (Tile tile : this.tiles) {
                int n = tile.elevations.length();
                if (n == 0) {
                    return null;
                }
                for (int i = 0; i < n; ++i) {
                    double d3 = tile.elevations.getDouble(i);
                    if (d3 == this.elevationModel.getMissingDataSignal()) {
                        d3 = this.elevationModel.getMissingDataReplacement();
                    }
                    if (d3 > d2) {
                        d2 = d3;
                    }
                    if (!(d3 < d)) continue;
                    d = d3;
                }
            }
            if (d == Double.MAX_VALUE) {
                d = this.elevationModel.getMinElevation();
            }
            if (d2 == -1.7976931348623157E308) {
                d2 = this.elevationModel.getMaxElevation();
            }
            this.extremes = new double[]{d, d2};
            return this.extremes;
        }
    }

    protected static class DownloadPostProcessor
    implements RetrievalPostProcessor {
        protected Tile tile;
        protected BasicElevationModel elevationModel;

        public DownloadPostProcessor(Tile tile, BasicElevationModel basicElevationModel) {
            this.tile = tile;
            this.elevationModel = basicElevationModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer run(Retriever retriever) {
            block24: {
                if (retriever == null) {
                    String string = Logging.getMessage("nullValue.RetrieverIsNull");
                    Logging.logger().severe(string);
                    throw new IllegalArgumentException(string);
                }
                try {
                    URLRetriever uRLRetriever;
                    if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                        if (retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusError")) {
                            this.elevationModel.levels.markResourceAbsent(this.tile);
                        }
                        ByteBuffer byteBuffer = null;
                        return byteBuffer;
                    }
                    if (retriever instanceof HTTPRetriever && ((HTTPRetriever)(uRLRetriever = (HTTPRetriever)retriever)).getResponseCode() != 200) {
                        this.elevationModel.levels.markResourceAbsent(this.tile);
                        ByteBuffer byteBuffer = null;
                        return byteBuffer;
                    }
                    uRLRetriever = (URLRetriever)retriever;
                    ByteBuffer byteBuffer = uRLRetriever.getBuffer();
                    File file = WorldWind.getDataFileStore().newFile(this.tile.getPath());
                    if (file == null) {
                        ByteBuffer byteBuffer2 = null;
                        return byteBuffer2;
                    }
                    if (file.exists()) {
                        ByteBuffer byteBuffer3 = byteBuffer;
                        return byteBuffer3;
                    }
                    if (byteBuffer == null) break block24;
                    String string = uRLRetriever.getContentType();
                    if (string.contains("xml") || string.contains("html") || string.contains("text")) {
                        this.elevationModel.getLevels().markResourceAbsent(this.tile);
                        StringBuffer stringBuffer = new StringBuffer();
                        while (byteBuffer.hasRemaining()) {
                            stringBuffer.append((char)byteBuffer.get());
                        }
                        Logging.logger().severe(stringBuffer.toString());
                        ByteBuffer byteBuffer4 = null;
                        return byteBuffer4;
                    }
                    if (string.contains("image") && !string.equals("image/bil")) {
                        byteBuffer = BasicElevationModel.convertImageToElevations(byteBuffer, string);
                        System.out.printf("buffer size %d, content type %s\n", byteBuffer.limit(), string);
                    }
                    Object object = this.elevationModel.fileLock;
                    synchronized (object) {
                        WWIO.saveBuffer(byteBuffer, file);
                    }
                    object = byteBuffer;
                    return object;
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                    Logging.logger().log(Level.FINE, Logging.getMessage("generic.OperationCancelled", "elevations retrieval"), closedByInterruptException);
                }
                catch (IOException iOException) {
                    this.elevationModel.getLevels().markResourceAbsent(this.tile);
                    Logging.logger().log(Level.SEVERE, Logging.getMessage("TiledElevationModel.ExceptionSavingRetrievedElevationFile", this.tile.getPath()), iOException);
                }
                finally {
                    this.elevationModel.firePropertyChange("gov.nasa.worldwind.avkey.ElevationModel", null, this);
                }
            }
            return null;
        }
    }

    private class BulkTileDownloadThread
    extends BulkRetrievalThread {
        private int MAX_TILE_COUNT_PER_REGION;
        private final BasicElevationModel elevationModel;
        private final int level;
        private ArrayList<Tile> missingTiles;

        public BulkTileDownloadThread(BasicElevationModel basicElevationModel2, Sector sector, double d) {
            super(basicElevationModel2, sector, d);
            this.MAX_TILE_COUNT_PER_REGION = 200;
            this.elevationModel = basicElevationModel2;
            this.level = BasicElevationModel.this.computeLevelForResolution(sector, d);
        }

        public void run() {
            try {
                this.progress.setTotalCount(this.countMissingTiles());
                this.progress.setTotalSize((long)this.progress.getTotalCount() * BasicElevationModel.this.estimateAverageTileSize());
                for (int i = 0; i <= this.level; ++i) {
                    Sector[] sectorArray;
                    if (this.elevationModel.getLevels().isLevelEmpty(i)) continue;
                    for (Sector sector : sectorArray = BasicElevationModel.this.computeRegions(this.sector, i, this.MAX_TILE_COUNT_PER_REGION)) {
                        this.missingTiles = BasicElevationModel.this.getMissingTilesInSector(sector, i);
                        while (this.missingTiles.size() > 0) {
                            this.submitMissingTilesRequests();
                            if (this.missingTiles.size() <= 0) continue;
                            Thread.sleep(this.RETRIEVAL_SERVICE_POLL_DELAY);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                String string = Logging.getMessage("generic.BulkRetrievalInterrupted", this.elevationModel.getName());
                Logging.logger().log(Level.WARNING, string, interruptedException);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionDuringBulkRetrieval", this.elevationModel.getName());
                Logging.logger().severe(string);
                throw new RuntimeException(string);
            }
        }

        private int countMissingTiles() throws InterruptedException {
            int n = 0;
            for (int i = 0; i <= this.level; ++i) {
                if (this.elevationModel.getLevels().isLevelEmpty(i)) continue;
                n += BasicElevationModel.this.getMissingTilesInSector(this.sector, i).size();
            }
            return n;
        }

        private synchronized void submitMissingTilesRequests() throws InterruptedException {
            RetrievalService retrievalService = WorldWind.getRetrievalService();
            int n = 0;
            while (this.missingTiles.size() > n && retrievalService.isAvailable()) {
                Thread.sleep(1L);
                Tile tile = this.missingTiles.get(n);
                if (BasicElevationModel.this.getLevels().isResourceAbsent(tile)) {
                    this.removeAbsentTile(tile);
                    continue;
                }
                URL uRL = WorldWind.getDataFileStore().findFile(tile.getPath(), false);
                if (uRL != null) {
                    this.removeRetrievedTile(tile);
                    continue;
                }
                BasicElevationModel.this.downloadElevations(tile, new BulkDownloadPostProcessor(tile, this.elevationModel));
                ++n;
            }
        }

        private synchronized void removeRetrievedTile(Tile tile) {
            this.missingTiles.remove(tile);
            this.progress.setCurrentCount(this.progress.getCurrentCount() + 1);
            this.progress.setCurrentSize(this.progress.getCurrentSize() + BasicElevationModel.this.estimateAverageTileSize());
            this.progress.setLastUpdateTime(System.currentTimeMillis());
        }

        private synchronized void removeAbsentTile(Tile tile) {
            this.missingTiles.remove(tile);
            this.progress.setTotalCount(this.progress.getTotalCount() - 1);
            this.progress.setTotalSize(this.progress.getTotalSize() - BasicElevationModel.this.estimateAverageTileSize());
            this.progress.setLastUpdateTime(System.currentTimeMillis());
        }

        private class BulkDownloadPostProcessor
        extends DownloadPostProcessor {
            public BulkDownloadPostProcessor(Tile tile, BasicElevationModel basicElevationModel) {
                super(tile, basicElevationModel);
            }

            public ByteBuffer run(Retriever retriever) {
                ByteBuffer byteBuffer = super.run(retriever);
                if (byteBuffer != null) {
                    BulkTileDownloadThread.this.removeRetrievedTile(this.tile);
                }
                return byteBuffer;
            }
        }
    }

    protected static class RequestTask
    implements Runnable {
        protected final BasicElevationModel elevationModel;
        protected final TileKey tileKey;

        protected RequestTask(TileKey tileKey, BasicElevationModel basicElevationModel) {
            this.elevationModel = basicElevationModel;
            this.tileKey = tileKey;
        }

        public final void run() {
            try {
                if (this.elevationModel.areElevationsInMemory(this.tileKey)) {
                    return;
                }
                Tile tile = this.elevationModel.createTile(this.tileKey);
                URL uRL = WorldWind.getDataFileStore().findFile(tile.getPath(), false);
                if (uRL != null) {
                    if (this.elevationModel.loadElevations(tile, uRL)) {
                        this.elevationModel.levels.unmarkResourceAbsent(tile);
                        this.elevationModel.firePropertyChange("gov.nasa.worldwind.avkey.ElevationModel", null, this);
                        return;
                    }
                    WorldWind.getDataFileStore().removeFile(uRL);
                    this.elevationModel.levels.markResourceAbsent(tile);
                    String string = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                    Logging.logger().info(string);
                }
                this.elevationModel.downloadElevations(tile);
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("ElevationModel.ExceptionRequestingElevations", this.tileKey.toString());
                Logging.logger().log(Level.FINE, string, iOException);
            }
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tileKey != null ? !this.tileKey.equals(requestTask.tileKey) : requestTask.tileKey != null);
        }

        public final int hashCode() {
            return this.tileKey != null ? this.tileKey.hashCode() : 0;
        }

        public final String toString() {
            return this.tileKey.toString();
        }
    }
}

