/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.BasicFactory;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.exception.WWUnrecognizedException;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.terrain.BasicElevationModel;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.terrain.WMSBasicElevationModel;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.wms.Capabilities;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BasicElevationModelFactory
extends BasicFactory {
    public ElevationModel createFromConfigFile(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = null;
        try {
            Document document = WWXML.openDocumentFile(string, this.getClass());
            NodeList nodeList = (NodeList)WWXML.makeXPath().evaluate("//ElevationModel", document, XPathConstants.NODESET);
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new IllegalStateException();
            }
            CompoundElevationModel compoundElevationModel = null;
            CompoundElevationModel compoundElevationModel2 = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                BasicElevationModel basicElevationModel;
                Element element = (Element)nodeList.item(i);
                String string4 = WWXML.getText(element, "@modelType");
                if (string4 != null && string4.equalsIgnoreCase("Compound")) {
                    CompoundElevationModel compoundElevationModel3 = new CompoundElevationModel();
                    if (compoundElevationModel2 == null) {
                        compoundElevationModel = compoundElevationModel2 = compoundElevationModel3;
                        continue;
                    }
                    compoundElevationModel2.addElevationModel(compoundElevationModel3);
                    compoundElevationModel2 = compoundElevationModel3;
                    continue;
                }
                string3 = WWXML.getText(element, "Service/@serviceName");
                if (string3.equals("WWTileService")) {
                    basicElevationModel = new BasicElevationModel(element, null);
                } else if (string3.equals("OGC:WMS")) {
                    basicElevationModel = new WMSBasicElevationModel(element, null);
                } else {
                    throw new IllegalStateException();
                }
                if (compoundElevationModel2 == null) {
                    return basicElevationModel;
                }
                compoundElevationModel2.addElevationModel(basicElevationModel);
            }
            return compoundElevationModel;
        }
        catch (IllegalStateException illegalStateException) {
            String string5 = Logging.getMessage("generic.UnrecognizedServiceName", string3 != null ? string3 : "null");
            throw new WWUnrecognizedException(string5);
        }
        catch (Exception exception) {
            String string6 = Logging.getMessage("generic.CreationFromConfigurationFileFailed", string);
            throw new WWRuntimeException(string6, exception);
        }
    }

    protected ElevationModel doCreateFromCapabilities(Capabilities capabilities, AVList aVList) {
        String string = capabilities.getServiceName();
        if (string == null || !string.equalsIgnoreCase("OGC:WMS")) {
            String string2 = Logging.getMessage("WMS.NotWMSService", string != null ? string : "null");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames") == null) {
            Element[] elementArray = capabilities.getNamedLayers();
            if (elementArray == null || elementArray.length == 0) {
                String string3 = Logging.getMessage("WMS.NoLayersFound");
                Logging.logger().severe(string3);
                throw new IllegalStateException(string3);
            }
            aVList.setValue("gov.nasa.worldwind.avkey.LayerNames", capabilities.getLayerName(elementArray[0]));
        }
        return new WMSBasicElevationModel(capabilities, aVList);
    }
}

