/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.terrain.AbstractElevationModel;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundElevationModel
extends AbstractElevationModel {
    protected CopyOnWriteArrayList<ElevationModel> elevationModels = new CopyOnWriteArrayList();

    public void addElevationModel(ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = Logging.getMessage("nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.elevationModels.add(elevationModel);
    }

    public void addElevationModel(int n, ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = Logging.getMessage("nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.elevationModels.add(n, elevationModel);
    }

    public void removeElevationModel(ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = Logging.getMessage("nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.elevationModels.remove(elevationModel);
    }

    public void removeElevationModel(int n) {
        if (n < 0 || n >= this.elevationModels.size()) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.elevationModels.remove(n);
    }

    public void setElevationModel(int n, ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = Logging.getMessage("nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this.elevationModels.size()) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.elevationModels.set(n, elevationModel);
    }

    public List<ElevationModel> getElevationModels() {
        return new ArrayList<ElevationModel>(this.elevationModels);
    }

    @Override
    public double getMaxElevation() {
        double d = -1.7976931348623157E308;
        for (ElevationModel elevationModel : this.elevationModels) {
            double d2 = elevationModel.getMaxElevation();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d == -1.7976931348623157E308 ? 0.0 : d;
    }

    @Override
    public double getMinElevation() {
        double d = Double.MAX_VALUE;
        for (ElevationModel elevationModel : this.elevationModels) {
            double d2 = elevationModel.getMinElevation();
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d == Double.MAX_VALUE ? 0.0 : d;
    }

    @Override
    public double[] getExtremeElevations(Angle angle, Angle angle2) {
        double[] dArray;
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray2 = null;
        for (ElevationModel elevationModel : this.elevationModels) {
            double[] dArray3 = elevationModel.getExtremeElevations(angle, angle2);
            if (dArray2 == null) {
                dArray2 = new double[]{dArray3[0], dArray3[1]};
                continue;
            }
            if (dArray3[0] < dArray2[0]) {
                dArray2[0] = dArray3[0];
            }
            if (!(dArray3[1] > dArray2[1])) continue;
            dArray2[1] = dArray3[1];
        }
        if (dArray2 == null) {
            double[] dArray4 = new double[2];
            dArray4[0] = 0.0;
            dArray = dArray4;
            dArray4[1] = 0.0;
        } else {
            dArray = dArray2;
        }
        return dArray;
    }

    @Override
    public double[] getExtremeElevations(Sector sector) {
        double[] dArray;
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray2 = null;
        for (ElevationModel elevationModel : this.elevationModels) {
            int n = elevationModel.intersects(sector);
            if (n == 0) {
                return elevationModel.getExtremeElevations(sector);
            }
            if (n != 1) continue;
            double[] dArray3 = elevationModel.getExtremeElevations(sector);
            if (dArray2 == null) {
                dArray2 = new double[]{dArray3[0], dArray3[1]};
                continue;
            }
            if (dArray3[0] < dArray2[0]) {
                dArray2[0] = dArray3[0];
            }
            if (!(dArray3[1] > dArray2[1])) continue;
            dArray2[1] = dArray3[1];
        }
        if (dArray2 == null) {
            double[] dArray4 = new double[2];
            dArray4[0] = 0.0;
            dArray = dArray4;
            dArray4[1] = 0.0;
        } else {
            dArray = dArray2;
        }
        return dArray;
    }

    @Override
    public double getBestResolution(Sector sector) {
        double d = 0.0;
        for (ElevationModel elevationModel : this.elevationModels) {
            double d2;
            if (elevationModel.intersects(sector) < 0 || !((d2 = elevationModel.getBestResolution(sector)) > d)) continue;
            d = d2;
        }
        return d != 0.0 ? d : Double.MAX_VALUE;
    }

    @Override
    public double getDetailHint(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = this.elevationModels.size() - 1; i >= 0; --i) {
            ElevationModel elevationModel = this.elevationModels.get(i);
            int n = elevationModel.intersects(sector);
            if (n == -1) continue;
            return elevationModel.getDetailHint(sector);
        }
        return 0.0;
    }

    @Override
    public int intersects(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        for (ElevationModel elevationModel : this.elevationModels) {
            int n = elevationModel.intersects(sector);
            if (n == 0) {
                return 0;
            }
            if (n != 1) continue;
            bl = true;
        }
        return bl ? 1 : -1;
    }

    @Override
    public boolean contains(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (ElevationModel elevationModel : this.elevationModels) {
            if (!elevationModel.contains(angle, angle2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getUnmappedElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Double d = this.missingDataFlag;
        for (int i = this.elevationModels.size() - 1; i >= 0; --i) {
            double d2;
            ElevationModel elevationModel = this.elevationModels.get(i);
            if (!elevationModel.contains(angle, angle2) || (d2 = elevationModel.getUnmappedElevation(angle, angle2)) == elevationModel.getMissingDataSignal()) continue;
            d = d2;
            break;
        }
        return d;
    }

    @Override
    public double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ElevationsBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < list.size()) {
            String string = Logging.getMessage("ElevationModel.ElevationsBufferTooSmall", list.size());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = 0.0;
        for (ElevationModel elevationModel : this.elevationModels) {
            double d3;
            int n = elevationModel.intersects(sector);
            if (n < 0 || !((d3 = elevationModel.getElevations(sector, list, d, dArray)) > d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    @Override
    public void setNetworkRetrievalEnabled(boolean bl) {
        super.setNetworkRetrievalEnabled(bl);
        for (ElevationModel elevationModel : this.elevationModels) {
            elevationModel.setNetworkRetrievalEnabled(bl);
        }
    }
}

