/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.pick.Pickable;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Point;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SectorGeometry
extends Renderable,
Pickable {
    public Extent getExtent();

    public Sector getSector();

    public Vec4 getSurfacePoint(Angle var1, Angle var2, double var3);

    public void renderMultiTexture(DrawContext var1, int var2);

    public void renderWireframe(DrawContext var1, boolean var2, boolean var3);

    public void renderBoundingVolume(DrawContext var1);

    public PickedObject[] pick(DrawContext var1, List<? extends Point> var2);

    public Intersection[] intersect(Line var1);

    public Intersection[] intersect(double var1);

    public DoubleBuffer makeTextureCoordinates(GeographicTextureCoordinateComputer var1);

    public ExtractedShapeDescription getIntersectingTessellationPieces(Plane[] var1);

    public ExtractedShapeDescription getIntersectingTessellationPieces(Vec4 var1, Vec4 var2, Vec4 var3, double var4, double var6);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtractedShapeDescription {
        public ArrayList<Vec4[]> interiorPolys;
        public ArrayList<BoundaryEdge> shapeOutline;

        public ExtractedShapeDescription(ArrayList<Vec4[]> arrayList, ArrayList<BoundaryEdge> arrayList2) {
            this.interiorPolys = arrayList;
            this.shapeOutline = arrayList2;
        }
    }

    public static class BoundaryEdge {
        public Vec4[] vertices;
        public int i1;
        public int i2;
        public Vec4 toMidPoint;

        public BoundaryEdge(Vec4[] vec4Array, int n, int n2) {
            this(vec4Array, n, n2, null);
        }

        public BoundaryEdge(Vec4[] vec4Array, int n, int n2, Vec4 vec4) {
            this.vertices = vec4Array;
            this.i1 = n;
            this.i2 = n2;
            this.toMidPoint = vec4;
        }
    }

    public static interface GeographicTextureCoordinateComputer {
        public double[] compute(Angle var1, Angle var2);
    }
}

