/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain.ebs;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.terrain.ebs.Edge;

public class GreatEllipseEdge
implements Edge {
    private Angle startLat;
    private Angle endLat;
    private Angle startLon;
    private Angle endLon;
    private Globe theGlobe;
    private Vec4 startPnt;
    private Vec4 endPnt;

    public GreatEllipseEdge(Globe globe, Angle angle, Angle angle2, Angle angle3, Angle angle4) {
        this.startLat = angle;
        this.endLat = angle2;
        this.startLon = angle3;
        this.endLon = angle4;
        this.theGlobe = globe;
        this.startPnt = globe.computePointFromPosition(angle, angle3, globe.getElevation(angle, angle3));
        this.endPnt = globe.computePointFromPosition(angle2, angle4, globe.getElevation(angle2, angle4));
    }

    public GreatEllipseEdge(Globe globe, LatLon latLon, LatLon latLon2) {
        this(globe, latLon.getLatitude(), latLon2.getLatitude(), latLon.getLongitude(), latLon2.getLongitude());
    }

    public LatLon arcLengthPointOnEdge(double d) {
        return this.pointOnEdge(d);
    }

    private static Vec4 centralPlaneNormal(Vec4 vec4, Vec4 vec42) {
        Vec4 vec43 = vec4.cross3(vec42);
        return vec43.normalize3();
    }

    public static LatLon findCentralPoint(Globe globe, LatLon[] latLonArray) {
        Vec4 vec4 = globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), 0.0);
        Vec4 vec42 = globe.computePointFromPosition(latLonArray[1].getLatitude(), latLonArray[1].getLongitude(), 0.0);
        Vec4 vec43 = globe.computePointFromPosition(latLonArray[2].getLatitude(), latLonArray[2].getLongitude(), 0.0);
        Vec4 vec44 = globe.computePointFromPosition(latLonArray[3].getLatitude(), latLonArray[3].getLongitude(), 0.0);
        Vec4 vec45 = GreatEllipseEdge.centralPlaneNormal(vec4, vec43);
        Vec4 vec46 = GreatEllipseEdge.centralPlaneNormal(vec42, vec44);
        Vec4 vec47 = vec45.cross3(vec46);
        if ((vec47 = vec47.normalize3()).dot3(vec4) < 0.0) {
            vec47 = vec47.getNegative3();
        }
        return globe.getIntersectionPosition(new Line(Vec4.ZERO, vec47));
    }

    public Edge.EdgeType getEdgeType() {
        return Edge.EdgeType.GreatEllipse;
    }

    public Vec4 getOutwardPointingNormal() {
        return GreatEllipseEdge.centralPlaneNormal(this.endPnt, this.startPnt);
    }

    public LatLon getStartPoint() {
        return new LatLon(this.startLat, this.startLon);
    }

    public Vec4 getStartPointXYZ() {
        return this.startPnt;
    }

    public LatLon getEndPoint() {
        return new LatLon(this.endLat, this.endLon);
    }

    public double maxLongitudeDegrees() {
        double d;
        double d2 = this.startLon.getDegrees();
        if (d2 > (d = this.endLon.getDegrees())) {
            return d2;
        }
        return d;
    }

    public LatLon pointOnEdge(double d) {
        Vec4 vec4 = Vec4.mix3(d, this.startPnt, this.endPnt);
        return this.theGlobe.getIntersectionPosition(new Line(Vec4.ZERO, vec4.normalize3()));
    }

    public Edge.EdgeType subdivide(Edge[] edgeArray) {
        LatLon latLon = this.pointOnEdge(0.5);
        edgeArray[0] = new GreatEllipseEdge(this.theGlobe, this.startLat, latLon.getLatitude(), this.startLon, latLon.getLongitude());
        edgeArray[1] = new GreatEllipseEdge(this.theGlobe, latLon.getLatitude(), this.endLat, latLon.getLongitude(), this.endLon);
        return Edge.EdgeType.GreatEllipse;
    }

    public String toString() {
        return "GreatEllipse, lat range: " + this.startLat + " to " + this.endLat + "; lon range: " + this.startLon + " to " + this.endLon;
    }
}

