/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.util.Logging;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public abstract class BufferWrapper {
    public abstract int length();

    public abstract int getInt(int var1);

    public abstract double getDouble(int var1);

    public abstract BufferWrapper getInt(int var1, int[] var2, int var3, int var4);

    public abstract BufferWrapper getDouble(int var1, double[] var2, int var3, int var4);

    public abstract BufferWrapper putInt(int var1, int var2);

    public abstract BufferWrapper putDouble(int var1, double var2);

    public abstract BufferWrapper putInt(int var1, int[] var2, int var3, int var4);

    public abstract BufferWrapper putDouble(int var1, double[] var2, int var3, int var4);

    public abstract long getSizeInBytes();

    public static BufferWrapper wrap(ByteBuffer byteBuffer, AVList aVList) {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = BufferWrapper.validate(aVList);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder");
        byteBuffer.order("gov.nasa.worldwind.avkey.LittleEndian".equals(object) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        object = aVList.getValue("gov.nasa.worldwind.avkey.DataType");
        NIOBufferWrapper nIOBufferWrapper = null;
        if ("gov.nasa.worldwind.avkey.Int8".equals(object)) {
            nIOBufferWrapper = new ByteBufferWrapper(byteBuffer);
        } else if ("gov.nasa.worldwind.avkey.Int16".equals(object)) {
            nIOBufferWrapper = new ShortBufferWrapper(byteBuffer.asShortBuffer());
        } else if ("gov.nasa.worldwind.avkey.Int32".equals(object)) {
            nIOBufferWrapper = new IntBufferWrapper(byteBuffer.asIntBuffer());
        } else if ("gov.nasa.worldwind.avkey.Float32".equals(object)) {
            nIOBufferWrapper = new FloatBufferWrapper(byteBuffer.asFloatBuffer());
        }
        return nIOBufferWrapper;
    }

    private static String validate(AVList aVList) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder");
        if (object == null || !BufferWrapper.validateByteOrder(object)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.byteOrder"));
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DataType")) == null || !BufferWrapper.validateDataType(object)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.dataType"));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return Logging.getMessage("BufferWrapper.InvalidBufferParameters", stringBuilder.toString());
    }

    private static boolean validateByteOrder(Object object) {
        return "gov.nasa.worldwind.avkey.BigEndian".equals(object) || "gov.nasa.worldwind.avkey.LittleEndian".equals(object);
    }

    private static boolean validateDataType(Object object) {
        return "gov.nasa.worldwind.avkey.Int8".equals(object) || "gov.nasa.worldwind.avkey.Int16".equals(object) || "gov.nasa.worldwind.avkey.Int32".equals(object) || "gov.nasa.worldwind.avkey.Float32".equals(object);
    }

    public static class FloatBufferWrapper
    extends NIOBufferWrapper {
        private FloatBuffer floatBuffer;

        public FloatBufferWrapper(FloatBuffer floatBuffer) {
            super(floatBuffer);
            this.floatBuffer = floatBuffer;
        }

        public int getInt(int n) {
            return (int)this.floatBuffer.get(n);
        }

        public double getDouble(int n) {
            return this.floatBuffer.get(n);
        }

        public BufferWrapper getInt(int n, int[] nArray, int n2, int n3) {
            if (nArray == null) {
                String string = Logging.getMessage("nullValue.DestinationIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            float[] fArray = new float[n3];
            this.floatBuffer.position(n);
            this.floatBuffer.get(fArray, 0, n3);
            this.floatBuffer.rewind();
            for (int i = 0; i < n3; ++i) {
                nArray[i + n2] = (int)fArray[i];
            }
            return this;
        }

        public BufferWrapper getDouble(int n, double[] dArray, int n2, int n3) {
            if (dArray == null) {
                String string = Logging.getMessage("nullValue.DestinationIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            float[] fArray = new float[n3];
            this.floatBuffer.position(n);
            this.floatBuffer.get(fArray, 0, n3);
            this.floatBuffer.rewind();
            for (int i = 0; i < n3; ++i) {
                dArray[i + n2] = fArray[i];
            }
            return this;
        }

        public BufferWrapper putInt(int n, int n2) {
            this.floatBuffer.put(n, n2);
            return this;
        }

        public BufferWrapper putDouble(int n, double d) {
            this.floatBuffer.put(n, (float)d);
            return this;
        }

        public BufferWrapper putInt(int n, int[] nArray, int n2, int n3) {
            if (nArray == null) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            float[] fArray = new float[n3];
            for (int i = 0; i < n3; ++i) {
                fArray[i] = nArray[i + n2];
            }
            this.floatBuffer.position(n);
            this.floatBuffer.put(fArray, 0, n3);
            this.floatBuffer.rewind();
            return this;
        }

        public BufferWrapper putDouble(int n, double[] dArray, int n2, int n3) {
            if (dArray == null) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            float[] fArray = new float[n3];
            for (int i = 0; i < n3; ++i) {
                fArray[i] = (float)dArray[i + n2];
            }
            this.floatBuffer.position(n);
            this.floatBuffer.put(fArray, 0, n3);
            this.floatBuffer.rewind();
            return this;
        }

        public long getSizeInBytes() {
            return 4 * this.floatBuffer.capacity();
        }
    }

    public static class IntBufferWrapper
    extends NIOBufferWrapper {
        private IntBuffer intBuffer;

        public IntBufferWrapper(IntBuffer intBuffer) {
            super(intBuffer);
            this.intBuffer = intBuffer;
        }

        public int getInt(int n) {
            return this.intBuffer.get(n);
        }

        public double getDouble(int n) {
            return this.intBuffer.get(n);
        }

        public BufferWrapper getInt(int n, int[] nArray, int n2, int n3) {
            if (nArray == null) {
                String string = Logging.getMessage("nullValue.DestinationIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.intBuffer.position(n);
            this.intBuffer.get(nArray, n2, n3);
            this.intBuffer.rewind();
            return this;
        }

        public BufferWrapper getDouble(int n, double[] dArray, int n2, int n3) {
            if (dArray == null) {
                String string = Logging.getMessage("nullValue.DestinationIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            int[] nArray = new int[n3];
            this.intBuffer.position(n);
            this.intBuffer.get(nArray, 0, n3);
            this.intBuffer.rewind();
            for (int i = 0; i < n3; ++i) {
                dArray[i + n2] = nArray[i];
            }
            return this;
        }

        public BufferWrapper putInt(int n, int n2) {
            this.intBuffer.put(n, n2);
            return this;
        }

        public BufferWrapper putDouble(int n, double d) {
            this.intBuffer.put(n, (int)d);
            return this;
        }

        public BufferWrapper putInt(int n, int[] nArray, int n2, int n3) {
            if (nArray == null) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.intBuffer.position(n);
            this.intBuffer.put(nArray, n2, n3);
            this.intBuffer.rewind();
            return this;
        }

        public BufferWrapper putDouble(int n, double[] dArray, int n2, int n3) {
            if (dArray == null) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = (int)dArray[i + n2];
            }
            this.intBuffer.position(n);
            this.intBuffer.put(nArray, 0, n3);
            this.intBuffer.rewind();
            return this;
        }

        public long getSizeInBytes() {
            return 4 * this.intBuffer.capacity();
        }
    }

    public static class ShortBufferWrapper
    extends NIOBufferWrapper {
        private ShortBuffer shortBuffer;

        public ShortBufferWrapper(ShortBuffer shortBuffer) {
            super(shortBuffer);
            this.shortBuffer = shortBuffer;
        }

        public int getInt(int n) {
            return this.shortBuffer.get(n);
        }

        public double getDouble(int n) {
            return this.shortBuffer.get(n);
        }

        public BufferWrapper getInt(int n, int[] nArray, int n2, int n3) {
            if (nArray == null) {
                String string = Logging.getMessage("nullValue.DestinationIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            short[] sArray = new short[n3];
            this.shortBuffer.position(n);
            this.shortBuffer.get(sArray, 0, n3);
            this.shortBuffer.rewind();
            for (int i = 0; i < n3; ++i) {
                nArray[i + n2] = sArray[i];
            }
            return this;
        }

        public BufferWrapper getDouble(int n, double[] dArray, int n2, int n3) {
            if (dArray == null) {
                String string = Logging.getMessage("nullValue.DestinationIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            short[] sArray = new short[n3];
            this.shortBuffer.position(n);
            this.shortBuffer.get(sArray, 0, n3);
            this.shortBuffer.rewind();
            for (int i = 0; i < n3; ++i) {
                dArray[i + n2] = sArray[i];
            }
            return this;
        }

        public BufferWrapper putInt(int n, int n2) {
            this.shortBuffer.put(n, (short)n2);
            return this;
        }

        public BufferWrapper putDouble(int n, double d) {
            this.shortBuffer.put(n, (short)d);
            return this;
        }

        public BufferWrapper putInt(int n, int[] nArray, int n2, int n3) {
            if (nArray == null) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            short[] sArray = new short[n3];
            for (int i = 0; i < n3; ++i) {
                sArray[i] = (short)nArray[i + n2];
            }
            this.shortBuffer.position(n);
            this.shortBuffer.put(sArray, 0, n3);
            this.shortBuffer.rewind();
            return this;
        }

        public BufferWrapper putDouble(int n, double[] dArray, int n2, int n3) {
            if (dArray == null) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            short[] sArray = new short[n3];
            for (int i = 0; i < n3; ++i) {
                sArray[i] = (short)dArray[i + n2];
            }
            this.shortBuffer.position(n);
            this.shortBuffer.put(sArray, 0, n3);
            this.shortBuffer.rewind();
            return this;
        }

        public long getSizeInBytes() {
            return 2 * this.shortBuffer.capacity();
        }
    }

    public static class ByteBufferWrapper
    extends NIOBufferWrapper {
        private ByteBuffer byteBuffer;

        public ByteBufferWrapper(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.byteBuffer = byteBuffer;
        }

        public int getInt(int n) {
            return this.byteBuffer.get(n);
        }

        public double getDouble(int n) {
            return this.byteBuffer.get(n);
        }

        public BufferWrapper getInt(int n, int[] nArray, int n2, int n3) {
            if (nArray == null) {
                String string = Logging.getMessage("nullValue.DestinationIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            byte[] byArray = new byte[n3];
            this.byteBuffer.position(n);
            this.byteBuffer.get(byArray, 0, n3);
            this.byteBuffer.rewind();
            for (int i = 0; i < n3; ++i) {
                nArray[i + n2] = byArray[i];
            }
            return this;
        }

        public BufferWrapper getDouble(int n, double[] dArray, int n2, int n3) {
            if (dArray == null) {
                String string = Logging.getMessage("nullValue.DestinationIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            byte[] byArray = new byte[n3];
            this.byteBuffer.position(n);
            this.byteBuffer.get(byArray, 0, n3);
            this.byteBuffer.rewind();
            for (int i = 0; i < n3; ++i) {
                dArray[i + n2] = byArray[i];
            }
            return this;
        }

        public BufferWrapper putInt(int n, int n2) {
            this.byteBuffer.put(n, (byte)n2);
            return this;
        }

        public BufferWrapper putDouble(int n, double d) {
            this.byteBuffer.put(n, (byte)d);
            return this;
        }

        public BufferWrapper putInt(int n, int[] nArray, int n2, int n3) {
            if (nArray == null) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            byte[] byArray = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray[i] = (byte)nArray[i + n2];
            }
            this.byteBuffer.position(n);
            this.byteBuffer.put(byArray, 0, n3);
            this.byteBuffer.rewind();
            return this;
        }

        public BufferWrapper putDouble(int n, double[] dArray, int n2, int n3) {
            if (dArray == null) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            byte[] byArray = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray[i] = (byte)dArray[i + n2];
            }
            this.byteBuffer.position(n);
            this.byteBuffer.put(byArray, 0, n3);
            this.byteBuffer.rewind();
            return this;
        }

        public long getSizeInBytes() {
            return this.byteBuffer.capacity();
        }
    }

    public static abstract class NIOBufferWrapper
    extends BufferWrapper {
        private Buffer sourceBuffer;

        public NIOBufferWrapper(Buffer buffer) {
            if (buffer == null) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.sourceBuffer = buffer;
            this.sourceBuffer.rewind();
        }

        public int length() {
            return this.sourceBuffer.limit();
        }
    }

    public static class IntArrayWrapper
    extends BufferWrapper {
        private int[] source;
        private int length;

        public IntArrayWrapper(int[] nArray, int n) {
            if (nArray == null) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.source = nArray;
            this.length = n;
        }

        public int length() {
            return this.length;
        }

        public int getInt(int n) {
            return this.source[n];
        }

        public double getDouble(int n) {
            return this.source[n];
        }

        public BufferWrapper getInt(int n, int[] nArray, int n2, int n3) {
            System.arraycopy(this.source, n, nArray, n2, n3);
            return this;
        }

        public BufferWrapper getDouble(int n, double[] dArray, int n2, int n3) {
            for (int i = 0; i < n3; ++i) {
                dArray[n2 + i] = this.source[n + i];
            }
            return this;
        }

        public BufferWrapper putInt(int n, int n2) {
            this.source[n] = n2;
            return this;
        }

        public BufferWrapper putDouble(int n, double d) {
            this.source[n] = (int)d;
            return this;
        }

        public BufferWrapper putInt(int n, int[] nArray, int n2, int n3) {
            System.arraycopy(nArray, n2, this.source, n, n3);
            return this;
        }

        public BufferWrapper putDouble(int n, double[] dArray, int n2, int n3) {
            for (int i = 0; i < n3; ++i) {
                this.source[n + i] = (int)dArray[n2 + i];
            }
            return this;
        }

        public long getSizeInBytes() {
            return 4 * this.length;
        }
    }
}

