/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.WorldWind;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheCleaner {
    private static long HIGH_WATER_IN_BYTES = 20000L * (long)Math.pow(2.0, 20.0);
    private static long LOW_WATER_IN_BYTES = (long)((double)HIGH_WATER_IN_BYTES * 0.8);

    private static CacheLocationData analyseCacheLocation(File file) {
        CacheLocationData cacheLocationData = new CacheLocationData(file);
        cacheLocationData.directories = CacheCleaner.getDirectories(file);
        for (CacheDirectory cacheDirectory : cacheLocationData.directories) {
            cacheLocationData.fileCount += (long)cacheDirectory.fileCount;
            cacheLocationData.sizeInBytes += cacheDirectory.sizeInBytes;
        }
        Collections.sort(cacheLocationData.directories);
        return cacheLocationData;
    }

    private static List<CacheDirectory> getDirectories(File file) {
        LinkedList<CacheDirectory> linkedList = new LinkedList<CacheDirectory>();
        if (file.exists()) {
            File[] fileArray;
            CacheDirectory cacheDirectory = new CacheDirectory(file);
            LinkedList<CacheDirectory> linkedList2 = new LinkedList<CacheDirectory>();
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isFile()) {
                    ++cacheDirectory.fileCount;
                    cacheDirectory.sizeInBytes += file2.length();
                    continue;
                }
                if (!file2.isDirectory()) continue;
                linkedList2.addAll(CacheCleaner.getDirectories(file2));
            }
            if (cacheDirectory.fileCount > 0) {
                linkedList.add(cacheDirectory);
            }
            if (linkedList2.size() > 0) {
                linkedList.addAll(linkedList2);
            }
        }
        return linkedList;
    }

    private static void cleanupCacheLocation(CacheLocationData cacheLocationData, long l) {
        for (CacheDirectory cacheDirectory : cacheLocationData.directories) {
            File[] fileArray;
            if (cacheLocationData.sizeInBytes <= l) break;
            for (File file : fileArray = cacheDirectory.file.listFiles()) {
                long l2 = file.length();
                if (!file.delete()) continue;
                --cacheLocationData.fileCount;
                cacheLocationData.sizeInBytes -= l2;
            }
            cacheDirectory.file.delete();
        }
    }

    public static void main(String[] stringArray) {
        File file = WorldWind.getDataFileStore().getWriteLocation();
        System.out.println("Analyzing: " + file.getAbsolutePath());
        CacheLocationData cacheLocationData = CacheCleaner.analyseCacheLocation(file);
        System.out.println("Size: " + (int)((double)cacheLocationData.sizeInBytes / Math.pow(2.0, 20.0)) + "Mb in " + cacheLocationData.fileCount + " file(s) from " + cacheLocationData.directories.size() + " dir(s)");
        if (cacheLocationData.sizeInBytes >= HIGH_WATER_IN_BYTES) {
            System.out.println("Cleaning down to " + (int)((double)LOW_WATER_IN_BYTES / Math.pow(2.0, 20.0)) + "Mb");
            CacheCleaner.cleanupCacheLocation(cacheLocationData, LOW_WATER_IN_BYTES);
            System.out.println("Size: " + (int)((double)cacheLocationData.sizeInBytes / Math.pow(2.0, 20.0)) + "Mb in " + cacheLocationData.fileCount + " file(s)");
        } else {
            System.out.println("No cleanup needed until " + (int)((double)HIGH_WATER_IN_BYTES / Math.pow(2.0, 20.0)) + "Mb");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheDirectory
    implements Comparable<CacheDirectory> {
        public File file;
        public int fileCount;
        public long sizeInBytes;

        public CacheDirectory(File file) {
            this.file = file;
            this.fileCount = 0;
            this.sizeInBytes = 0L;
        }

        @Override
        public int compareTo(CacheDirectory cacheDirectory) {
            return (int)(this.file.lastModified() - cacheDirectory.file.lastModified());
        }
    }

    private static class CacheLocationData {
        public File cacheLocation;
        public List<CacheDirectory> directories;
        public long fileCount;
        public long sizeInBytes;

        public CacheLocationData(File file) {
            this.cacheLocation = file;
            this.fileCount = 0L;
            this.sizeInBytes = 0L;
        }
    }
}

