/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryMath {
    public static boolean isPolygonClosed(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends LatLon> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        LatLon latLon = iterator.next();
        LatLon latLon2 = null;
        while (iterator.hasNext()) {
            latLon2 = iterator.next();
        }
        return latLon2 != null && latLon2.equals(latLon);
    }

    public static boolean isPolygonClosed2(Iterable<? extends Vec4> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends Vec4> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        Vec4 vec4 = iterator.next();
        Vec4 vec42 = null;
        while (iterator.hasNext()) {
            vec42 = iterator.next();
        }
        return vec42 != null && vec42.equals(vec4);
    }

    public static double computePolygonArea(Iterable<? extends LatLon> iterable) {
        LatLon latLon;
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends LatLon> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return 0.0;
        }
        double d = 0.0;
        LatLon latLon2 = latLon = iterator.next();
        while (iterator.hasNext()) {
            LatLon latLon3 = iterator.next();
            d += latLon2.getLongitude().degrees * latLon3.getLatitude().degrees;
            d -= latLon3.getLongitude().degrees * latLon2.getLatitude().degrees;
            latLon2 = latLon3;
        }
        if (!latLon2.equals(latLon)) {
            d += latLon2.getLongitude().degrees * latLon.getLatitude().degrees;
            d -= latLon.getLongitude().degrees * latLon2.getLatitude().degrees;
        }
        return d /= 2.0;
    }

    public static double computePolygonArea2(Iterable<? extends Vec4> iterable) {
        Vec4 vec4;
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends Vec4> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return 0.0;
        }
        double d = 0.0;
        Vec4 vec42 = vec4 = iterator.next();
        while (iterator.hasNext()) {
            Vec4 vec43 = iterator.next();
            d += vec42.x * vec43.y;
            d -= vec43.x * vec42.y;
            vec42 = vec43;
        }
        if (!vec42.equals(vec4)) {
            d += vec42.x * vec4.y;
            d -= vec4.x * vec42.y;
        }
        return d /= 2.0;
    }

    public static String computePolygonWindingOrder(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = GeometryMath.computePolygonArea(iterable);
        if (d < 0.0) {
            return "gov.nasa.worldwind.avkey.ClockWise";
        }
        return "gov.nasa.worldwind.avkey.CounterClockWise";
    }

    public static String computePolygonWindingOrder2(Iterable<? extends Vec4> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = GeometryMath.computePolygonArea2(iterable);
        if (d < 0.0) {
            return "gov.nasa.worldwind.avkey.ClockWise";
        }
        return "gov.nasa.worldwind.avkey.CounterClockWise";
    }

    public static boolean isSegmentIntersectingSector(LatLon latLon, LatLon latLon2, Sector sector) {
        if (latLon == null) {
            String string = Logging.getMessage("");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon2 == null) {
            String string = Logging.getMessage("");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = new Vec4(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 0.0);
        Vec4 vec42 = new Vec4(latLon2.getLongitude().degrees, latLon2.getLatitude().degrees, 0.0);
        Vec4 vec43 = vec42.subtract3(vec4);
        Vec4 vec44 = vec4.add3(vec42).divide3(2.0);
        Vec4 vec45 = vec43.normalize3();
        double d = vec43.getLength3() / 2.0;
        LatLon latLon3 = sector.getCentroid();
        Vec4 vec46 = new Vec4(latLon3.getLongitude().degrees, latLon3.getLatitude().degrees, 0.0);
        double d2 = sector.getDeltaLonDegrees() / 2.0;
        double d3 = sector.getDeltaLatDegrees() / 2.0;
        Vec4 vec47 = vec44.subtract3(vec46);
        if (Math.abs(vec47.x) > d2 + d * Math.abs(vec45.x)) {
            return false;
        }
        if (Math.abs(vec47.y) > d3 + d * Math.abs(vec45.y)) {
            return false;
        }
        Vec4 vec48 = new Vec4(vec45.y, -vec45.x, 0.0);
        return Math.abs(vec48.dot3(vec47)) <= d2 * Math.abs(vec48.x) + d3 * Math.abs(vec48.y);
    }
}

