/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatLonQuadTree {
    private static final Sector DEFAULT_SECTOR = Sector.FULL_SPHERE;
    private static final int DEFAULT_MAX_LIST_SIZE = 1000;
    private static final int DEFAULT_MAX_LEVELS = 9;
    private final Sector sector;
    private final int maxListSize;
    private final int maxLevels;
    ArrayList<LatLonEntry> entries;
    LatLonQuadTree[] childs;

    public LatLonQuadTree() {
        this(DEFAULT_SECTOR, 1000, 9);
    }

    public LatLonQuadTree(Sector sector) {
        this(sector, 1000, 9);
    }

    public LatLonQuadTree(Sector sector, int n, int n2) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1 || n2 < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.maxListSize = n;
        this.maxLevels = n2;
    }

    public Sector getSector() {
        return this.sector;
    }

    public int getMaxListSize() {
        return this.maxListSize;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public LatLonQuadTree add(Object object, LatLon latLon) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.add(new LatLonEntry(latLon, object));
    }

    private LatLonQuadTree add(LatLonEntry latLonEntry) {
        if (!this.sector.contains(latLonEntry.latLon)) {
            return null;
        }
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        if (this.childs == null && (this.entries.size() <= this.maxListSize || this.maxLevels == 1)) {
            this.entries.add(latLonEntry);
            return this;
        }
        if (this.childs == null) {
            this.split();
        }
        for (LatLonQuadTree latLonQuadTree : this.childs) {
            LatLonQuadTree latLonQuadTree2 = latLonQuadTree.add(latLonEntry);
            if (latLonQuadTree2 == null) continue;
            return latLonQuadTree2;
        }
        return null;
    }

    private void split() {
        this.childs = new LatLonQuadTree[4];
        Sector[] sectorArray = this.sector.subdivide();
        this.childs[0] = new LatLonQuadTree(sectorArray[0], this.maxListSize, this.maxLevels - 1);
        this.childs[1] = new LatLonQuadTree(sectorArray[1], this.maxListSize, this.maxLevels - 1);
        this.childs[2] = new LatLonQuadTree(sectorArray[2], this.maxListSize, this.maxLevels - 1);
        this.childs[3] = new LatLonQuadTree(sectorArray[3], this.maxListSize, this.maxLevels - 1);
        for (LatLonEntry latLonEntry : this.entries) {
            for (LatLonQuadTree latLonQuadTree : this.childs) {
                if (latLonQuadTree.add(latLonEntry) != null) break;
            }
        }
        this.entries.clear();
    }

    public ArrayList<Object> get(Sector sector) {
        if (this.sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.sector.intersects(sector)) {
            return null;
        }
        if (this.entries == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.childs != null) {
            for (LatLonQuadTree latLonQuadTree : this.childs) {
                ArrayList<Object> arrayList2 = latLonQuadTree.get(sector);
                if (arrayList2 == null) continue;
                arrayList.addAll(arrayList2);
            }
        } else if (this.sector.intersection(sector).equals(this.sector)) {
            for (LatLonEntry latLonEntry : this.entries) {
                arrayList.add(latLonEntry.object);
            }
        } else {
            for (LatLonEntry latLonEntry : this.entries) {
                if (!sector.contains(latLonEntry.latLon)) continue;
                arrayList.add(latLonEntry.object);
            }
        }
        return arrayList;
    }

    public LatLonQuadTree remove(Object object, LatLon latLon) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.sector.contains(latLon)) {
            return null;
        }
        if (this.entries == null) {
            return null;
        }
        if (this.childs != null) {
            for (LatLonQuadTree latLonQuadTree : this.childs) {
                LatLonQuadTree latLonQuadTree2 = latLonQuadTree.remove(object, latLon);
                if (latLonQuadTree2 == null) continue;
                return latLonQuadTree2;
            }
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.get(i).object != object) continue;
            this.entries.remove(i);
            return this;
        }
        return null;
    }

    public String toString() {
        String string = "LatLonQuadTree: max Levels: " + this.maxLevels + ", entries: " + (this.entries != null ? Integer.valueOf(this.entries.size()) : "0") + " " + this.sector;
        if (this.childs != null) {
            for (LatLonQuadTree latLonQuadTree : this.childs) {
                string = string + "\n" + latLonQuadTree.toString();
            }
        }
        return string;
    }

    public static void main(String[] stringArray) {
        ArrayList<Object> arrayList;
        LatLonQuadTree latLonQuadTree = new LatLonQuadTree();
        long l = 1000000L;
        System.out.println("Adding " + l + " entries...");
        long l2 = System.nanoTime();
        int n = 0;
        while ((double)n < 1000000.0) {
            arrayList = LatLon.fromDegrees(Math.random() * 180.0 - 90.0, Math.random() * 360.0 - 180.0);
            latLonQuadTree.add(arrayList, (LatLon)((Object)arrayList));
            ++n;
        }
        long l3 = System.nanoTime() - l2;
        System.out.println("Elapsed: " + l3 / 1000L + " micro sec. (average " + l3 / l + " ns)");
        System.out.println(latLonQuadTree);
        Sector sector = Sector.fromDegrees(0.0, 15.0, -100.0, -80.0);
        l2 = System.nanoTime();
        arrayList = latLonQuadTree.get(sector);
        l3 = System.nanoTime() - l2;
        if (arrayList != null) {
            System.out.println(arrayList.size() + " objects found inside " + sector + " in " + l3 / 1000L + " micro sec.");
        } else {
            System.out.println("No object found inside " + sector);
        }
        if (arrayList != null) {
            System.out.println("Removing found objects...");
            for (Object e : arrayList) {
                latLonQuadTree.remove(e, (LatLon)e);
            }
            l2 = System.nanoTime();
            arrayList = latLonQuadTree.get(sector);
            l3 = System.nanoTime() - l2;
            if (arrayList != null) {
                System.out.println(arrayList.size() + " objects found inside " + sector + " in " + l3 / 1000L + " micro sec.");
            } else {
                System.out.println("No object found inside " + sector);
            }
        }
    }

    private class LatLonEntry {
        private LatLon latLon;
        private Object object;

        public LatLonEntry(LatLon latLon, Object object) {
            this.latLon = latLon;
            this.object = object;
        }
    }
}

