/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import javax.media.opengl.GL;

public class OGLOrtho2DSupport {
    protected int width;
    protected int height;
    protected OGLStackHandler stackHandler = new OGLStackHandler();

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void beginRendering(GL gL) {
        if (gL == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = 0;
        this.height = 0;
        this.stackHandler.pushAttrib(gL, 10249);
        this.stackHandler.pushTextureIdentity(gL);
        this.stackHandler.pushProjectionIdentity(gL);
        this.stackHandler.pushModelviewIdentity(gL);
        gL.glDisable(2929);
        gL.glEnable(2884);
        gL.glCullFace(1029);
    }

    public void endRendering(GL gL) {
        if (gL == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.stackHandler.pop(gL);
        this.width = 0;
        this.height = 0;
    }

    public void setSize(GL gL, int n, int n2) {
        if (gL == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = n;
        this.height = n2;
        int[] nArray = new int[4];
        gL.glGetIntegerv(2978, nArray, 0);
        if (this.width > nArray[2]) {
            this.width = WWMath.powerOfTwoFloor(nArray[2]);
        }
        if (this.height > nArray[3]) {
            this.height = WWMath.powerOfTwoFloor(nArray[3]);
        }
        gL.glMatrixMode(5889);
        gL.glViewport(0, 0, this.width, this.height);
        gL.glOrtho(0.0, this.width, 0.0, this.height, -1.0, 1.0);
        gL.glMatrixMode(5888);
    }

    public void clear(GL gL, Color color) {
        if (gL == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[0] = fArray[0] * fArray[3];
        fArray[1] = fArray[1] * fArray[3];
        fArray[2] = fArray[2] * fArray[3];
        gL.glClearColor(fArray[0], fArray[1], fArray[2], fArray[3]);
        gL.glClear(16384);
    }
}

