/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import javax.media.opengl.GL;

public class OGLStackHandler {
    private boolean attribsPushed;
    private boolean clientAttribsPushed;
    private boolean modelviewPushed;
    private boolean projectionPushed;
    private boolean texturePushed;

    public void pushAttrib(GL gL, int n) {
        gL.glPushAttrib(n);
        this.attribsPushed = true;
    }

    public void pushClientAttrib(GL gL, int n) {
        gL.glPushClientAttrib(n);
        this.clientAttribsPushed = true;
    }

    public void pushModelview(GL gL) {
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        this.modelviewPushed = true;
    }

    public void pushProjection(GL gL) {
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        this.projectionPushed = true;
    }

    public void pushTexture(GL gL) {
        gL.glMatrixMode(5890);
        gL.glPushMatrix();
        this.texturePushed = true;
    }

    public void pop(GL gL) {
        if (this.attribsPushed) {
            gL.glPopAttrib();
            this.attribsPushed = false;
        }
        if (this.clientAttribsPushed) {
            gL.glPopClientAttrib();
            this.clientAttribsPushed = false;
        }
        if (this.modelviewPushed) {
            gL.glMatrixMode(5888);
            gL.glPopMatrix();
            this.modelviewPushed = false;
        }
        if (this.projectionPushed) {
            gL.glMatrixMode(5889);
            gL.glPopMatrix();
            this.projectionPushed = false;
        }
        if (this.texturePushed) {
            gL.glMatrixMode(5890);
            gL.glPopMatrix();
            this.texturePushed = false;
        }
    }

    public void pushModelviewIdentity(GL gL) {
        gL.glMatrixMode(5888);
        this.modelviewPushed = true;
        gL.glPushMatrix();
        gL.glLoadIdentity();
    }

    public void pushProjectionIdentity(GL gL) {
        gL.glMatrixMode(5889);
        this.projectionPushed = true;
        gL.glPushMatrix();
        gL.glLoadIdentity();
    }

    public void pushTextureIdentity(GL gL) {
        gL.glMatrixMode(5890);
        this.texturePushed = true;
        gL.glPushMatrix();
        gL.glLoadIdentity();
    }
}

