/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.util.Logging;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class WWIO {
    public static final String ILLEGAL_FILE_PATH_PART_CHARACTERS = "[?/\\\\=+<>:;\\,\"\\|^\\[\\]]";

    public static String formPath(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.separator);
            }
            stringBuilder.append(string.replaceAll(ILLEGAL_FILE_PATH_PART_CHARACTERS, "_"));
        }
        return stringBuilder.toString();
    }

    public static String stripIllegalFileNameCharacters(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return string.replaceAll(ILLEGAL_FILE_PATH_PART_CHARACTERS, "_");
    }

    public static String stripTrailingSeparator(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.endsWith("/") || string.endsWith("\\")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String stripLeadingSeparator(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.startsWith("/") || string.startsWith("\\")) {
            return string.substring(1, string.length());
        }
        return string;
    }

    public static String stripLeadingZeros(String string) {
        int n;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        int n2 = string.length();
        if (n2 < 2) {
            return string;
        }
        for (n = 0; n < n2 && string.charAt(n) == '0'; ++n) {
        }
        if (n == n2) {
            n = n2 - 1;
        }
        if (n == 0) {
            return string;
        }
        return string.substring(n, n2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveBuffer(ByteBuffer byteBuffer, File file, boolean bl) throws IOException {
        boolean bl2;
        int n;
        FileChannel fileChannel;
        FileOutputStream fileOutputStream;
        block12: {
            if (byteBuffer == null) {
                String string = Logging.getMessage("nullValue.BufferNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (file == null) {
                String string = Logging.getMessage("nullValue.FileIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            fileOutputStream = null;
            fileChannel = null;
            n = 0;
            fileOutputStream = new FileOutputStream(file);
            fileChannel = fileOutputStream.getChannel();
            FileLock fileLock = fileChannel.tryLock();
            if (fileLock != null) break block12;
            Logging.logger().log(Level.FINER, "WWIO.UnableToAcquireLockFor", file.getPath());
            boolean bl3 = false;
            WWIO.closeStream(fileChannel, file.getPath());
            WWIO.closeStream(fileOutputStream, file.getPath());
            return bl3;
        }
        try {
            byteBuffer.rewind();
            while (byteBuffer.hasRemaining()) {
                n += fileChannel.write(byteBuffer);
            }
            if (bl) {
                fileChannel.force(true);
            }
            fileOutputStream.flush();
            bl2 = true;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            try {
                Logging.logger().log(Level.FINE, Logging.getMessage("generic.interrupted", "WWIO.saveBuffer", file.getPath()), closedByInterruptException);
                if (n > 0) {
                    file.delete();
                }
                throw closedByInterruptException;
                catch (IOException iOException) {
                    Logging.logger().log(Level.SEVERE, Logging.getMessage("WWIO.ErrorSavingBufferTo", file.getPath()), iOException);
                    if (n > 0) {
                        file.delete();
                    }
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                WWIO.closeStream(fileChannel, file.getPath());
                WWIO.closeStream(fileOutputStream, file.getPath());
                throw throwable;
            }
        }
        WWIO.closeStream(fileChannel, file.getPath());
        WWIO.closeStream(fileOutputStream, file.getPath());
        return bl2;
    }

    public static boolean saveBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        return WWIO.saveBuffer(byteBuffer, file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MappedByteBuffer mapFile(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            MappedByteBuffer mappedByteBuffer = fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            return mappedByteBuffer;
        }
        finally {
            WWIO.closeStream(fileInputStream, file.getPath());
        }
    }

    public static ByteBuffer readURLContentToBuffer(URL uRL) throws IOException {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        InputStream inputStream = uRL.openStream();
        return WWIO.readStreamToBuffer(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readFileToBuffer(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
            int n = 0;
            while (n >= 0 && byteBuffer.hasRemaining()) {
                n = fileChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        finally {
            WWIO.closeStream(fileInputStream, file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readZipEntryToBuffer(File file, String string) throws IOException {
        ByteBuffer byteBuffer;
        if (file == null) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry;
            ZipFile zipFile = new ZipFile(file);
            if (zipFile.size() < 1) {
                String string3 = Logging.getMessage("WWIO.ZipFileIsEmpty", file.getPath());
                Logging.logger().severe(string3);
                throw new IOException(string3);
            }
            if (string != null) {
                zipEntry = zipFile.getEntry(string);
                if (zipEntry == null) {
                    String string4 = Logging.getMessage("WWIO.ZipFileEntryNIF", string, file.getPath());
                    Logging.logger().severe(string4);
                    throw new IOException(string4);
                }
            } else {
                zipEntry = zipFile.entries().nextElement();
            }
            inputStream = zipFile.getInputStream(zipEntry);
            ByteBuffer byteBuffer2 = null;
            if (zipEntry.getSize() > 0L) {
                byteBuffer2 = WWIO.transferStreamToByteBuffer(inputStream, (int)zipEntry.getSize());
                byteBuffer2.rewind();
            }
            byteBuffer = byteBuffer2;
        }
        catch (Throwable throwable) {
            WWIO.closeStream(inputStream, string);
            throw throwable;
        }
        WWIO.closeStream(inputStream, string);
        return byteBuffer;
    }

    private static ByteBuffer transferStreamToByteBuffer(InputStream inputStream, int n) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1) {
            Logging.logger().severe("WWIO.NumberBytesTransferLessThanOne");
            throw new IllegalArgumentException(Logging.getMessage("WWIO.NumberBytesTransferLessThanOne"));
        }
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[n];
        while (n3 >= 0 && n - n2 > 0) {
            n3 = inputStream.read(byArray, n2, n - n2);
            if (n3 <= 0) continue;
            n2 += n3;
        }
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(byArray.length);
        return byteBuffer.put(byArray);
    }

    public static ByteBuffer readStreamToBuffer(InputStream inputStream) throws IOException {
        int n = (int)Math.round(Math.pow(2.0, 16.0));
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        int n2 = 0;
        while (n2 >= 0) {
            n2 = readableByteChannel.read(byteBuffer);
            if (n2 <= 0 || byteBuffer.hasRemaining()) continue;
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.limit() + n);
            byteBuffer2.put((ByteBuffer)byteBuffer.rewind());
            byteBuffer = byteBuffer2;
        }
        if (byteBuffer != null) {
            byteBuffer.flip();
        }
        return byteBuffer;
    }

    public static String replaceSuffix(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = string2 != null ? string2 : "";
        int n = string.lastIndexOf(".");
        return n >= 0 ? string.substring(0, n) + string4 : string + string4;
    }

    public static String getSuffix(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        int n = string.length();
        int n2 = string.lastIndexOf(".");
        return n2 >= 0 && n2 + 1 < n ? string.substring(n2 + 1, n) : null;
    }

    public static File saveBufferToTempFile(ByteBuffer byteBuffer, String string) throws IOException {
        if (byteBuffer == null) {
            String string2 = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = File.createTempFile("WorldWind", string != null ? string : "");
        file.deleteOnExit();
        byteBuffer.rewind();
        WWIO.saveBuffer(byteBuffer, file);
        return file;
    }

    public static boolean isFileOutOfDate(URL uRL, long l) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            URI uRI = uRL.toURI();
            if (uRI.isOpaque()) {
                return false;
            }
            File file = new File(uRI);
            return file.exists() && file.lastModified() < l;
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.logger().log(Level.SEVERE, "WWIO.ExceptionValidatingFileExpiration", uRL);
            return false;
        }
    }

    public static Proxy configureProxy() {
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.UrlProxyHost");
        if (string == null) {
            return null;
        }
        Proxy proxy = null;
        try {
            int n = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.UrlProxyPort");
            String string2 = Configuration.getStringValue("gov.nasa.worldwind.avkey.UrlProxyType");
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            if (string2.equals("Proxy.Type.Http")) {
                proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
            } else if (string2.equals("Proxy.Type.SOCKS")) {
                proxy = new Proxy(Proxy.Type.SOCKS, inetSocketAddress);
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.WARNING, Logging.getMessage("URLRetriever.ErrorConfiguringProxy", string), exception);
        }
        return proxy;
    }

    public static String makeSuffixForMimeType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ImageFomat");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        if (!string.contains("/") || string.endsWith("/")) {
            String string3 = Logging.getMessage("generic.InvalidImageFormat");
            Logging.logger().severe(string3);
            throw new IllegalStateException(string3);
        }
        String string4 = string.substring(string.lastIndexOf("/") + 1);
        string4 = string4.replaceFirst("jpeg", "jpg");
        string4 = string4.replaceFirst("tiff", "tif");
        return "." + string4;
    }

    public static Object getFileOrResourceAsStream(String string, Class clazz) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        File file = new File(string);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (Exception exception) {
                return exception;
            }
        }
        if (clazz == null) {
            clazz = WWIO.class;
        }
        try {
            return clazz.getResourceAsStream("/" + string);
        }
        catch (Exception exception) {
            return exception;
        }
    }

    public static InputStream getInputStreamFromString(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        try {
            return new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WWRuntimeException(unsupportedEncodingException);
        }
    }

    public static InputStream getInputStreamFromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (byteBuffer.hasArray()) {
            return new ByteArrayInputStream(byteBuffer.array());
        }
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return new ByteArrayInputStream(byArray);
    }

    public static boolean isAncestorOf(File file, File file2) {
        File file3;
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (file2 == null) {
            String string = Logging.getMessage("nullValue.AncestorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (file3 = file; file3 != null && !file3.equals(file2); file3 = file3.getParentFile()) {
        }
        return file3 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (file2 == null) {
            String string = Logging.getMessage("nullValue.DestinationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            fileOutputStream = new FileOutputStream(file2);
            FileChannel fileChannel2 = fileOutputStream.getChannel();
            fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
            fileOutputStream.flush();
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            WWIO.closeStream(fileInputStream, file.getPath());
            WWIO.closeStream(fileOutputStream, file2.getPath());
            throw throwable;
        }
        WWIO.closeStream(fileInputStream, file.getPath());
        WWIO.closeStream(fileOutputStream, file2.getPath());
    }

    public static void copyDirectory(File file, File file2, boolean bl) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (file2 == null) {
            String string = Logging.getMessage("nullValue.DestinationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file2.exists()) {
            String string = Logging.getMessage("generic.CannotCreateFile", file2);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file3 : fileArray) {
            if (file3 == null) continue;
            if (file3.isDirectory()) {
                arrayList2.add(file3);
                continue;
            }
            arrayList.add(file3);
        }
        for (File file4 : arrayList) {
            File file5 = new File(file2, file4.getName());
            WWIO.copyFile(file4, file5);
        }
        if (bl) {
            for (File file6 : arrayList2) {
                File file7 = new File(file2, file6.getName());
                WWIO.copyDirectory(file6, file7, bl);
            }
        }
    }

    public static void deleteDirectory(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            ArrayList<File> arrayList = new ArrayList<File>();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            for (File file2 : fileArray) {
                if (file2 == null) continue;
                if (file2.isDirectory()) {
                    arrayList2.add(file2);
                    continue;
                }
                arrayList.add(file2);
            }
            for (File file3 : arrayList) {
                file3.delete();
            }
            for (File file4 : arrayList2) {
                WWIO.deleteDirectory(file4);
            }
        }
    }

    public static void closeStream(Object object, String string) {
        if (object == null) {
            return;
        }
        try {
            if (object instanceof InputStream) {
                ((InputStream)object).close();
            } else if (object instanceof OutputStream) {
                ((OutputStream)object).close();
            } else if (object instanceof Reader) {
                ((Reader)object).close();
            } else if (object instanceof Writer) {
                ((Writer)object).close();
            } else if (object instanceof FileChannel) {
                ((FileChannel)object).close();
            } else {
                String string2 = Logging.getMessage("WWIO.StreamTypeNotSupported", string != null ? string : "Unknown");
                Logging.logger().warning(string2);
            }
        }
        catch (IOException iOException) {
            String string3 = Logging.getMessage("generic.ExceptionClosingStream", iOException, string != null ? string : "Unknown");
            Logging.logger().severe(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        catch (IOException iOException) {
            String string;
            try {
                iOException.printStackTrace();
                string = null;
            }
            catch (Throwable throwable) {
                WWIO.closeStream(bufferedReader, file.getPath());
                throw throwable;
            }
            WWIO.closeStream(bufferedReader, file.getPath());
            return string;
        }
        WWIO.closeStream(bufferedReader, file.getPath());
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(String string, File file) {
        if (file == null) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string);
        }
        catch (IOException iOException) {
            try {
                iOException.printStackTrace();
            }
            catch (Throwable throwable) {
                WWIO.closeStream(bufferedWriter, file.getPath());
                throw throwable;
            }
            WWIO.closeStream(bufferedWriter, file.getPath());
        }
        WWIO.closeStream(bufferedWriter, file.getPath());
    }

    public static InputStream openFileOrResourceStream(String string, Class clazz) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Object object = WWIO.getFileOrResourceAsStream(string, clazz);
        if (object == null || object instanceof Exception) {
            String string3 = Logging.getMessage("generic.CannotOpenFile", string);
            if (object != null) {
                Logging.logger().log(Level.SEVERE, string3, object);
            } else {
                Logging.logger().log(Level.SEVERE, string3);
            }
            throw new WWRuntimeException(string3, (Exception)object);
        }
        return (InputStream)object;
    }
}

