/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WWXML {
    public static DocumentBuilder createDocumentBuilder(boolean bl) {
        String string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(bl);
        if ((double)Configuration.getJavaVersion() >= 1.6) {
            try {
                documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                string = Logging.getMessage("XML.NonvalidatingNotSupported");
                Logging.logger().finest(string);
            }
        }
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            string = Logging.getMessage("XML.ParserConfigurationException");
            Logging.logger().finest(string);
            throw new WWRuntimeException(parserConfigurationException);
        }
    }

    public static Document openDocumentFile(String string, Class clazz) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            InputStream inputStream = WWIO.openFileOrResourceStream(string, clazz);
            return WWXML.createDocumentBuilder(true).parse(inputStream);
        }
        catch (SAXException sAXException) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseXml", string);
            Logging.logger().severe(string3);
            throw new WWRuntimeException(sAXException);
        }
        catch (IOException iOException) {
            String string4 = Logging.getMessage("generic.ExceptionAttemptingToParseXml", string);
            Logging.logger().severe(string4);
            throw new WWRuntimeException(iOException);
        }
    }

    public static XPath makeXPath() {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        return xPathFactory.newXPath();
    }

    public static String getText(Element element, String string) {
        return WWXML.getText(element, string, null);
    }

    public static String checkOGCException(Document document) {
        if (document == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            XPath xPath = WWXML.makeXPath();
            String string = xPath.evaluate("ServiceExceptionReport", document);
            if (string == null || string.length() == 0) {
                return null;
            }
            return xPath.evaluate("ServiceExceptionReport/ServiceException/text()", document);
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = Logging.getMessage("XML.XPathExpressionException");
            Logging.logger().warning(string);
            return null;
        }
    }

    public static String extractOGCServiceException(ByteBuffer byteBuffer) {
        return null;
    }

    public static String getText(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        try {
            return xPath.evaluate(string, element);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static String[] getTextArray(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        try {
            NodeList nodeList = (NodeList)xPath.evaluate(string, element, XPathConstants.NODESET);
            if (nodeList == null || nodeList.getLength() == 0) {
                return null;
            }
            String[] stringArray = new String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                stringArray[i] = nodeList.item(i).getTextContent();
            }
            return stringArray;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static String[] getUniqueText(Element element, String string, XPath xPath) {
        String[] stringArray;
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        if ((stringArray = WWXML.getTextArray(element, string, xPath)) == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : stringArray) {
            if (arrayList.contains(string4)) continue;
            arrayList.add(string4);
        }
        return arrayList.toArray(new String[1]);
    }

    public static Element getElement(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        try {
            Node node = (Node)xPath.evaluate(string, element, XPathConstants.NODE);
            if (node == null) {
                return null;
            }
            return node instanceof Element ? (Element)node : null;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static Element[] getElements(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        try {
            NodeList nodeList = (NodeList)xPath.evaluate(string, element, XPathConstants.NODESET);
            if (nodeList == null || nodeList.getLength() == 0) {
                return null;
            }
            Element[] elementArray = new Element[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                elementArray[i] = (Element)node;
            }
            return elementArray;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static Element[] getUniqueElements(Element element, String string, String string2, XPath xPath) {
        Element[] elementArray;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            String string5 = Logging.getMessage("nullValue.UniqueTagIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (xPath == null) {
            xPath = WWXML.makeXPath();
        }
        if ((elementArray = WWXML.getElements(element, string, xPath)) == null) {
            return null;
        }
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        for (Element element2 : elementArray) {
            String string6 = WWXML.getText(element2, string2, xPath);
            if (string6 == null) continue;
            hashMap.put(string6, element2);
        }
        return hashMap.values().toArray(new Element[1]);
    }

    public static Double getDouble(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = null;
        try {
            string4 = WWXML.getText(element, string, xPath);
            if (string4 == null || string4.length() == 0) {
                return null;
            }
            return Double.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("generic.ConversionError", string4);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public static Integer getInteger(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = null;
        try {
            string4 = WWXML.getText(element, string, xPath);
            if (string4 == null || string4.length() == 0) {
                return null;
            }
            return Integer.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("generic.ConversionError", string4);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public static Long getLong(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = null;
        try {
            string4 = WWXML.getText(element, string, xPath);
            if (string4 == null || string4.length() == 0) {
                return null;
            }
            return Long.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("generic.ConversionError", string4);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public static Boolean getBoolean(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = null;
        try {
            string4 = WWXML.getText(element, string, xPath);
            if (string4 == null || string4.length() == 0) {
                return null;
            }
            return Boolean.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("generic.ConversionError", string4);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public static LatLon getLatLon(Element element, String string, XPath xPath) {
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        try {
            Element element2;
            Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
            if (element2 == null) {
                return null;
            }
            String string4 = WWXML.getText(element2, "@units", xPath);
            Double d = WWXML.getDouble(element2, "@latitude", xPath);
            Double d2 = WWXML.getDouble(element2, "@longitude", xPath);
            if (d == null || d2 == null) {
                return null;
            }
            if (string4 == null || string4.equals("degrees")) {
                return LatLon.fromDegrees(d, d2);
            }
            if (string4.equals("radians")) {
                return LatLon.fromRadians(d, d2);
            }
            String string5 = Logging.getMessage("XML.UnitsUnrecognized", string4);
            Logging.logger().warning(string5);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            String string6 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string6, numberFormatException);
            return null;
        }
    }

    public static Sector getSector(Element element, String string, XPath xPath) {
        Element element2;
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
        if (element2 == null) {
            return null;
        }
        LatLon latLon = WWXML.getLatLon(element2, "SouthWest/LatLon", xPath);
        LatLon latLon2 = WWXML.getLatLon(element2, "NorthEast/LatLon", xPath);
        if (latLon == null || latLon2 == null) {
            return null;
        }
        return new Sector(latLon.latitude, latLon2.latitude, latLon.longitude, latLon2.longitude);
    }

    public static LevelSet.SectorResolution getSectorResolutionLimit(Element element, String string, XPath xPath) {
        Element element2;
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
        if (element2 == null) {
            return null;
        }
        Integer n = WWXML.getInteger(element2, "@maxLevelNum", xPath);
        Sector sector = WWXML.getSector(element2, "Sector", xPath);
        if (n == null || sector == null) {
            return null;
        }
        return new LevelSet.SectorResolution(sector, n);
    }

    public static void checkAndSetStringParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        String string7 = aVList.getStringValue(string);
        if (string7 == null && (string7 = WWXML.getText(element, string2, xPath)) != null && string7.length() > 0) {
            aVList.setValue(string, string7);
        }
    }

    public static void checkAndSetDoubleParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Double d;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (d = WWXML.getDouble(element, string2, xPath)) != null) {
            aVList.setValue(string, d);
        }
    }

    public static void checkAndSetIntegerParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Integer n;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (n = WWXML.getInteger(element, string2, xPath)) != null) {
            aVList.setValue(string, n);
        }
    }

    public static void checkAndSetLongParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Long l;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (l = WWXML.getLong(element, string2, xPath)) != null) {
            aVList.setValue(string, l);
        }
    }

    public static void checkAndSetBooleanParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Boolean bl;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (bl = WWXML.getBoolean(element, string2, xPath)) != null) {
            aVList.setValue(string, bl);
        }
    }

    public static void checkAndSetLatLonParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        LatLon latLon;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (latLon = WWXML.getLatLon(element, string2, xPath)) != null) {
            aVList.setValue(string, latLon);
        }
    }

    public static void checkAndSetSectorParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        Sector sector;
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null && (sector = WWXML.getSector(element, string2, xPath)) != null) {
            aVList.setValue(string, sector);
        }
    }

    public static void checkAndSetSectorResolutionParam(Element element, AVList aVList, String string, String string2, XPath xPath) {
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.ParameterKeyIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            String string6 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        Object object = aVList.getValue(string);
        if (object == null) {
            Element[] elementArray = WWXML.getElements(element, string2, xPath);
            if (elementArray == null || elementArray.length == 0) {
                return;
            }
            LevelSet.SectorResolution[] sectorResolutionArray = new LevelSet.SectorResolution[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                LevelSet.SectorResolution sectorResolution = WWXML.getSectorResolutionLimit(elementArray[i], null, xPath);
                if (sectorResolution == null) continue;
                sectorResolutionArray[i] = sectorResolution;
            }
            aVList.setValue(string, sectorResolutionArray);
        }
    }

    public static String fixGetMapString(String string) {
        int n = (string = string.trim()).indexOf("?");
        if (n < 0) {
            string = string + "?";
        } else if (n != string.length() - 1 && string.lastIndexOf("&") != string.length() - 1) {
            string = string + "&";
        }
        return string;
    }
}

