/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.ViewStateIterator;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import javax.media.opengl.GL;

public abstract class AbstractView
extends WWObjectImpl
implements View {
    private boolean detectCollisions = true;
    protected boolean hadCollisions;
    protected ViewStateIterator viewStateIterator;

    public boolean isDetectCollisions() {
        return this.detectCollisions;
    }

    public void setDetectCollisions(boolean bl) {
        this.detectCollisions = bl;
    }

    public boolean hadCollisions() {
        boolean bl = this.hadCollisions;
        this.hadCollisions = false;
        return bl;
    }

    protected void flagHadCollisions() {
        this.hadCollisions = true;
    }

    public void stopMovement() {
        this.forceStopStateIterators();
        this.firePropertyChange("gov.nasa.worldwind.View.ViewStopped", null, this);
    }

    public void apply(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("layers.AbstractLayer.NoGlobeSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.updateStateIterator();
        this.doApply(drawContext);
    }

    protected abstract void doApply(DrawContext var1);

    public Matrix pushReferenceCenter(DrawContext drawContext, Vec4 vec4) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = this.getModelviewMatrix();
        Matrix matrix2 = null;
        if (matrix != null) {
            matrix2 = matrix.multiply(Matrix.fromTranslation(vec4));
        }
        GL gL = drawContext.getGL();
        int[] nArray = new int[1];
        gL.glGetIntegerv(2976, nArray, 0);
        if (nArray[0] != 5888) {
            gL.glMatrixMode(5888);
        }
        gL.glPushMatrix();
        if (matrix2 != null) {
            double[] dArray = new double[16];
            matrix2.toArray(dArray, 0, false);
            gL.glLoadMatrixd(dArray, 0);
        }
        if (nArray[0] != 5888) {
            gL.glMatrixMode(nArray[0]);
        }
        return matrix2;
    }

    public void popReferenceCenter(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL gL = drawContext.getGL();
        int[] nArray = new int[1];
        gL.glGetIntegerv(2976, nArray, 0);
        if (nArray[0] != 5888) {
            gL.glMatrixMode(5888);
        }
        gL.glPopMatrix();
        if (nArray[0] != 5888) {
            gL.glMatrixMode(nArray[0]);
        }
    }

    public void applyStateIterator(ViewStateIterator viewStateIterator) {
        ViewStateIterator viewStateIterator2 = this.viewStateIterator;
        this.viewStateIterator = viewStateIterator;
        if (this.viewStateIterator != null) {
            this.viewStateIterator = this.viewStateIterator.coalesceWith(this, viewStateIterator2);
            this.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this);
        }
    }

    public boolean hasStateIterator() {
        return this.viewStateIterator != null;
    }

    public void stopStateIterators() {
        this.forceStopStateIterators();
    }

    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void updateStateIterator() {
        if (this.viewStateIterator != null) {
            if (this.viewStateIterator.hasNextState(this)) {
                this.viewStateIterator.nextState(this);
                this.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this);
            } else {
                this.forceStopStateIterators();
                this.firePropertyChange("gov.nasa.worldwind.avkey.ViewQuiet", null, this);
            }
        }
    }

    protected void forceStopStateIterators() {
        this.viewStateIterator = null;
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsBoolean(stateObject, "detectCollisions", this.isDetectCollisions());
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "detectCollisions");
        if (bl != null) {
            this.setDetectCollisions(bl);
        }
    }
}

