/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.view.OrbitView;
import gov.nasa.worldwind.view.OrbitViewLimits;

public class BasicOrbitViewLimits
implements OrbitViewLimits {
    protected Sector centerLocationLimits = Sector.FULL_SPHERE;
    protected double minCenterElevation = -1.7976931348623157E308;
    protected double maxCenterElevation = Double.MAX_VALUE;
    protected Angle minHeading = Angle.NEG180;
    protected Angle maxHeading = Angle.POS180;
    protected Angle minPitch = Angle.ZERO;
    protected Angle maxPitch = Angle.POS90;
    protected double minZoom = 0.0;
    protected double maxZoom = Double.MAX_VALUE;

    public Sector getCenterLocationLimits() {
        return this.centerLocationLimits;
    }

    public void setCenterLocationLimits(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centerLocationLimits = sector;
    }

    public double[] getCenterElevationLimits() {
        return new double[]{this.minCenterElevation, this.maxCenterElevation};
    }

    public void setCenterElevationLimits(double d, double d2) {
        this.minCenterElevation = d;
        this.maxCenterElevation = d2;
    }

    public Angle[] getHeadingLimits() {
        return new Angle[]{this.minHeading, this.maxHeading};
    }

    public void setHeadingLimits(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.MinOrMaxAngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minHeading = angle;
        this.maxHeading = angle2;
    }

    public Angle[] getPitchLimits() {
        return new Angle[]{this.minPitch, this.maxPitch};
    }

    public void setPitchLimits(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.MinOrMaxAngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minPitch = angle;
        this.maxPitch = angle2;
    }

    public double[] getZoomLimits() {
        return new double[]{this.minZoom, this.maxZoom};
    }

    public void setZoomLimits(double d, double d2) {
        this.minZoom = d;
        this.maxZoom = d2;
    }

    public static void applyLimits(OrbitView orbitView, OrbitViewLimits orbitViewLimits) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        orbitView.setCenterPosition(BasicOrbitViewLimits.limitCenterPosition(orbitView.getCenterPosition(), orbitViewLimits));
        orbitView.setHeading(BasicOrbitViewLimits.limitHeading(orbitView.getHeading(), orbitViewLimits));
        orbitView.setPitch(BasicOrbitViewLimits.limitPitch(orbitView.getPitch(), orbitViewLimits));
        orbitView.setZoom(BasicOrbitViewLimits.limitZoom(orbitView.getZoom(), orbitViewLimits));
    }

    public static Position limitCenterPosition(Position position, OrbitViewLimits orbitViewLimits) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Position(BasicOrbitViewLimits.limitCenterLocation(position.getLatitude(), position.getLongitude(), orbitViewLimits), BasicOrbitViewLimits.limitCenterElevation(position.getElevation(), orbitViewLimits));
    }

    public static LatLon limitCenterLocation(Angle angle, Angle angle2, OrbitViewLimits orbitViewLimits) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Sector sector = orbitViewLimits.getCenterLocationLimits();
        Angle angle3 = angle;
        Angle angle4 = angle2;
        if (angle.compareTo(sector.getMinLatitude()) < 0) {
            angle3 = sector.getMinLatitude();
        } else if (angle.compareTo(sector.getMaxLatitude()) > 0) {
            angle3 = sector.getMaxLatitude();
        }
        if (angle2.compareTo(sector.getMinLongitude()) < 0) {
            angle4 = sector.getMinLongitude();
        } else if (angle2.compareTo(sector.getMaxLongitude()) > 0) {
            angle4 = sector.getMaxLongitude();
        }
        return new LatLon(angle3, angle4);
    }

    public static double limitCenterElevation(double d, OrbitViewLimits orbitViewLimits) {
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = orbitViewLimits.getCenterElevationLimits();
        double d2 = d;
        if (d < dArray[0]) {
            d2 = dArray[0];
        } else if (d > dArray[1]) {
            d2 = dArray[1];
        }
        return d2;
    }

    public static Angle limitHeading(Angle angle, OrbitViewLimits orbitViewLimits) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle[] angleArray = orbitViewLimits.getHeadingLimits();
        Angle angle2 = angle;
        if (angle.compareTo(angleArray[0]) < 0) {
            angle2 = angleArray[0];
        } else if (angle.compareTo(angleArray[1]) > 0) {
            angle2 = angleArray[1];
        }
        return angle2;
    }

    public static Angle limitPitch(Angle angle, OrbitViewLimits orbitViewLimits) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle[] angleArray = orbitViewLimits.getPitchLimits();
        Angle angle2 = angle;
        if (angle.compareTo(angleArray[0]) < 0) {
            angle2 = angleArray[0];
        } else if (angle.compareTo(angleArray[1]) > 0) {
            angle2 = angleArray[1];
        }
        return angle2;
    }

    public static double limitZoom(double d, OrbitViewLimits orbitViewLimits) {
        if (orbitViewLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = orbitViewLimits.getZoomLimits();
        double d2 = d;
        if (d < dArray[0]) {
            d2 = dArray[0];
        } else if (d > dArray[1]) {
            d2 = dArray[1];
        }
        return d2;
    }

    public void getRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsSector(stateObject, "centerLocationLimits", this.centerLocationLimits);
        restorableSupport.addStateValueAsDouble(stateObject, "minCenterElevation", this.minCenterElevation);
        restorableSupport.addStateValueAsDouble(stateObject, "maxCenterElevation", this.maxCenterElevation);
        restorableSupport.addStateValueAsDouble(stateObject, "minHeadingDegrees", this.minHeading.degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "maxHeadingDegrees", this.maxHeading.degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "minPitchDegrees", this.minPitch.degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "maxPitchDegrees", this.maxPitch.degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "minZoom", this.minZoom);
        restorableSupport.addStateValueAsDouble(stateObject, "maxZoom", this.maxZoom);
    }

    public void restoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        Sector sector = restorableSupport.getStateValueAsSector(stateObject, "centerLocationLimits");
        if (sector != null) {
            this.setCenterLocationLimits(sector);
        }
        double[] dArray = this.getCenterElevationLimits();
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "minCenterElevation");
        if (d2 != null) {
            dArray[0] = d2;
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "maxCenterElevation")) != null) {
            dArray[1] = d;
        }
        if (d2 != null || d != null) {
            this.setCenterElevationLimits(dArray[0], dArray[1]);
        }
        Angle[] angleArray = this.getHeadingLimits();
        d2 = restorableSupport.getStateValueAsDouble(stateObject, "minHeadingDegrees");
        if (d2 != null) {
            angleArray[0] = Angle.fromDegrees(d2);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "maxHeadingDegrees")) != null) {
            angleArray[1] = Angle.fromDegrees(d);
        }
        if (d2 != null || d != null) {
            this.setHeadingLimits(angleArray[0], angleArray[1]);
        }
        angleArray = this.getPitchLimits();
        d2 = restorableSupport.getStateValueAsDouble(stateObject, "minPitchDegrees");
        if (d2 != null) {
            angleArray[0] = Angle.fromDegrees(d2);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "maxPitchDegrees")) != null) {
            angleArray[1] = Angle.fromDegrees(d);
        }
        if (d2 != null || d != null) {
            this.setPitchLimits(angleArray[0], angleArray[1]);
        }
        dArray = this.getZoomLimits();
        d2 = restorableSupport.getStateValueAsDouble(stateObject, "minZoom");
        if (d2 != null) {
            dArray[0] = d2;
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "maxZoom")) != null) {
            dArray[1] = d;
        }
        if (d2 != null || d != null) {
            this.setZoomLimits(dArray[0], dArray[1]);
        }
    }
}

