/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.OrbitViewModel;

public class BasicOrbitViewModel
implements OrbitViewModel {
    public Matrix computeTransformMatrix(Globe globe, Position position, Angle angle, Angle angle2, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2 == null) {
            String string = Logging.getMessage("nullValue.PitchIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = this.computeHeadingPitchZoomTransform(angle, angle2, d);
        matrix = matrix.multiply(this.computeCenterTransform(globe, position));
        return matrix;
    }

    public OrbitViewModel.ModelCoordinates computeModelCoordinates(Globe globe, Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = "nullValue.EyePointIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec42 == null) {
            String string = "nullValue.CenterPointIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec43 == null) {
            String string = "nullValue.UpIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromViewLookAt(vec4, vec42, vec43);
        return this.computeModelCoordinates(globe, matrix, vec42);
    }

    public OrbitViewModel.ModelCoordinates computeModelCoordinates(Globe globe, Matrix matrix, Vec4 vec4) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null) {
            String string = "nullValue.ModelTransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = "nullValue.CenterPointIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = globe.computePositionFromPoint(vec4);
        Matrix matrix2 = this.computeCenterTransform(globe, position);
        Matrix matrix3 = matrix2.getInverse();
        if (matrix3 == null) {
            String string = Logging.getMessage("generic.NoninvertibleMatrix");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Matrix matrix4 = matrix.multiply(matrix3);
        Angle angle = this.computeHeading(matrix4);
        Angle angle2 = this.computePitch(matrix4);
        double d = this.computeZoom(matrix4);
        if (angle == null || angle2 == null) {
            return null;
        }
        return new BasicModelCoordinates(position, angle, angle2, d);
    }

    protected Matrix computeCenterTransform(Globe globe, Position position) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computeSurfaceNormalAtLocation(position.getLatitude(), position.getLongitude());
        Vec4 vec43 = vec4.subtract3(vec42);
        Vec4 vec44 = globe.computeNorthPointingTangentAtLocation(position.getLatitude(), position.getLongitude());
        return Matrix.fromViewLookAt(vec4, vec43, vec44);
    }

    protected Matrix computeHeadingPitchZoomTransform(Angle angle, Angle angle2, double d) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2 == null) {
            String string = Logging.getMessage("nullValue.PitchIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromTranslation(0.0, 0.0, -d);
        matrix = matrix.multiply(Matrix.fromRotationX(angle2.multiply(-1.0)));
        matrix = matrix.multiply(Matrix.fromRotationZ(angle));
        return matrix;
    }

    protected Angle computeHeading(Matrix matrix) {
        if (matrix == null) {
            String string = "nullValue.HeadingPitchZoomTransformTransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return matrix.getRotationZ();
    }

    protected Angle computePitch(Matrix matrix) {
        if (matrix == null) {
            String string = "nullValue.HeadingPitchZoomTransformTransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = matrix.getRotationX();
        if (angle != null) {
            angle = angle.multiply(-1.0);
        }
        return angle;
    }

    protected double computeZoom(Matrix matrix) {
        if (matrix == null) {
            String string = "nullValue.HeadingPitchZoomTransformTransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = matrix.getTranslation();
        return vec4 != null ? vec4.getLength3() : 0.0;
    }

    protected static class BasicModelCoordinates
    implements OrbitViewModel.ModelCoordinates {
        private final Position center;
        private final Angle heading;
        private final Angle pitch;
        private final double zoom;

        public BasicModelCoordinates(Position position, Angle angle, Angle angle2, double d) {
            if (position == null) {
                String string = Logging.getMessage("nullValue.CenterIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (angle == null) {
                String string = Logging.getMessage("nullValue.HeadingIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (angle2 == null) {
                String string = Logging.getMessage("nullValue.PitchIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.center = position;
            this.heading = angle;
            this.pitch = angle2;
            this.zoom = d;
        }

        public Position getCenterPosition() {
            return this.center;
        }

        public Angle getHeading() {
            return this.heading;
        }

        public Angle getPitch() {
            return this.pitch;
        }

        public double getZoom() {
            return this.zoom;
        }
    }
}

