/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.AbstractViewStateIterator;

public class EyePositionIterator
extends AbstractViewStateIterator {
    private final Position begin;
    private final Position end;

    public EyePositionIterator(long l, Position position, Position position2) {
        super(l);
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.begin = position;
        this.end = position2;
    }

    public EyePositionIterator(long l, long l2, Position position, Position position2) {
        super(l, l2);
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.begin = position;
        this.end = position2;
    }

    public final Position getBeginEyePosition() {
        return this.begin;
    }

    public final Position getEndEyePosition() {
        return this.end;
    }

    protected void doNextState(double d, View view) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = this.computeNextPosition(d);
        view.setEyePosition(position);
    }

    protected Position computeNextPosition(double d) {
        Angle angle = LatLon.greatCircleAzimuth(this.begin, this.end);
        Angle angle2 = LatLon.greatCircleDistance(this.begin, this.end);
        Angle angle3 = Angle.fromDegrees(angle2.degrees * d);
        LatLon latLon = LatLon.greatCircleEndPosition((LatLon)this.begin, angle, angle3);
        double d2 = (1.0 - d) * this.begin.getElevation() + d * this.end.getElevation();
        return new Position(latLon, d2);
    }
}

